/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.repositories;

import io.lucenia.plugins.RepositoryPlugin;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.env.Environment;
import io.skylite.core.indices.recovery.RecoverySettings;
import io.skylite.core.repositories.RepositoriesService;
import io.skylite.core.repositories.Repository;
import io.skylite.core.settings.Settings;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.transport.TransportService;
import io.skylite.core.xcontent.NamedXContentRegistry;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opensearch.repositories.fs.FsRepository;
import org.opensearch.repositories.fs.ReloadableFsRepository;

public final class RepositoriesModule {
    private final RepositoriesService repositoriesService;

    public RepositoriesModule(Environment env, List<RepositoryPlugin> repoPlugins, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, NamedXContentRegistry namedXContentRegistry, RecoverySettings recoverySettings) {
        HashMap<String, Repository.Factory> factories = new HashMap<String, Repository.Factory>();
        factories.put("fs", metadata -> new FsRepository(metadata, env, namedXContentRegistry, clusterService, recoverySettings));
        factories.put("reloadable-fs", metadata -> new ReloadableFsRepository(metadata, env, namedXContentRegistry, clusterService, recoverySettings));
        for (RepositoryPlugin repositoryPlugin : repoPlugins) {
            Map<String, Repository.Factory> newRepoTypes = repositoryPlugin.getRepositories(env, namedXContentRegistry, clusterService, recoverySettings);
            for (Map.Entry<String, Repository.Factory> entry : newRepoTypes.entrySet()) {
                if (factories.put(entry.getKey(), entry.getValue()) == null) continue;
                throw new IllegalArgumentException("Repository type [" + entry.getKey() + "] is already registered");
            }
        }
        HashMap<String, Repository.Factory> internalFactories = new HashMap<String, Repository.Factory>();
        for (RepositoryPlugin repoPlugin : repoPlugins) {
            Map<String, Repository.Factory> newRepoTypes = repoPlugin.getInternalRepositories(env, namedXContentRegistry, clusterService, recoverySettings);
            for (Map.Entry<String, Repository.Factory> entry : newRepoTypes.entrySet()) {
                if (internalFactories.put(entry.getKey(), entry.getValue()) != null) {
                    throw new IllegalArgumentException("Internal repository type [" + entry.getKey() + "] is already registered");
                }
                if (factories.put(entry.getKey(), entry.getValue()) == null) continue;
                throw new IllegalArgumentException("Internal repository type [" + entry.getKey() + "] is already registered as a non-internal repository");
            }
        }
        Settings settings = env.settings();
        Map repositoryTypes = Collections.unmodifiableMap(factories);
        Map internalRepositoryTypes = Collections.unmodifiableMap(internalFactories);
        this.repositoriesService = new RepositoriesService(settings, clusterService, transportService, repositoryTypes, internalRepositoryTypes, threadPool);
    }

    public RepositoriesService getRepositoryService() {
        return this.repositoriesService;
    }
}

