/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.repositories.fs;

import io.skylite.common.blobstore.BlobPath;
import io.skylite.core.blobstore.BlobStore;
import io.skylite.core.blobstore.fs.FsBlobStore;
import io.skylite.core.cluster.metadata.RepositoryMetadata;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.Strings;
import io.skylite.core.common.unit.ByteSizeValue;
import io.skylite.core.env.Environment;
import io.skylite.core.indices.recovery.RecoverySettings;
import io.skylite.core.repositories.RepositoryException;
import io.skylite.core.repositories.blobstore.BlobStoreRepository;
import io.skylite.core.settings.Setting;
import io.skylite.core.settings.spi.SettingsProvider;
import io.skylite.core.xcontent.NamedXContentRegistry;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FsRepository
extends BlobStoreRepository {
    private static final Logger logger = LogManager.getLogger(FsRepository.class);
    public static final String TYPE = "fs";
    public static final Setting<String> LOCATION_SETTING = new Setting("location", "", Function.identity(), new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<String> REPOSITORIES_LOCATION_SETTING = new Setting("repositories.fs.location", LOCATION_SETTING, Function.identity(), new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<ByteSizeValue> CHUNK_SIZE_SETTING = Setting.byteSizeSetting((String)"chunk_size", (ByteSizeValue)new ByteSizeValue(Long.MAX_VALUE), (ByteSizeValue)new ByteSizeValue(5L), (ByteSizeValue)new ByteSizeValue(Long.MAX_VALUE), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<ByteSizeValue> REPOSITORIES_CHUNK_SIZE_SETTING = Setting.byteSizeSetting((String)"repositories.fs.chunk_size", (ByteSizeValue)new ByteSizeValue(Long.MAX_VALUE), (ByteSizeValue)new ByteSizeValue(5L), (ByteSizeValue)new ByteSizeValue(Long.MAX_VALUE), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<Boolean> REPOSITORIES_COMPRESS_SETTING = Setting.boolSetting((String)"repositories.fs.compress", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Deprecated});
    public static final Setting<String> BASE_PATH_SETTING = Setting.simpleString((String)"base_path", (Setting.Property[])new Setting.Property[0]);
    protected final Environment environment;
    protected ByteSizeValue chunkSize;
    protected BlobPath basePath;

    public FsRepository(RepositoryMetadata metadata, Environment environment, NamedXContentRegistry namedXContentRegistry, ClusterService clusterService, RecoverySettings recoverySettings) {
        super(metadata, namedXContentRegistry, clusterService, recoverySettings);
        this.environment = environment;
        this.validateLocation();
        this.readMetadata();
    }

    protected void readMetadata() {
        this.chunkSize = CHUNK_SIZE_SETTING.exists(this.metadata.settings()) ? (ByteSizeValue)CHUNK_SIZE_SETTING.get(this.metadata.settings()) : (ByteSizeValue)REPOSITORIES_CHUNK_SIZE_SETTING.get(this.environment.settings());
        String basePath = (String)BASE_PATH_SETTING.get(this.metadata.settings());
        this.basePath = Strings.hasLength((String)basePath) ? new BlobPath().add(basePath) : BlobPath.cleanPath();
    }

    protected void validateLocation() {
        String location = (String)REPOSITORIES_LOCATION_SETTING.get(this.metadata.settings());
        if (location.isEmpty()) {
            logger.warn("the repository location is missing, it should point to a shared file system location that is available on all cluster-manager and data nodes");
            throw new RepositoryException(this.metadata.name(), "missing location");
        }
        Path locationFile = this.environment.resolveRepoFile(location);
        if (locationFile == null) {
            if (this.environment.repoFiles().length > 0) {
                logger.warn("The specified location [{}] doesn't start with any repository paths specified by the path.repo setting: [{}] ", (Object)location, (Object)this.environment.repoFiles());
                throw new RepositoryException(this.metadata.name(), "location [" + location + "] doesn't match any of the locations specified by path.repo");
            }
            logger.warn("The specified location [{}] should start with a repository path specified by the path.repo setting, but the path.repo setting was not set on this node", (Object)location);
            throw new RepositoryException(this.metadata.name(), "location [" + location + "] doesn't match any of the locations specified by path.repo because this setting is empty");
        }
    }

    protected BlobStore createBlobStore() throws Exception {
        String location = (String)REPOSITORIES_LOCATION_SETTING.get(this.getMetadata().settings());
        Path locationFile = this.environment.resolveRepoFile(location);
        return new FsBlobStore(this.bufferSize, locationFile, this.isReadOnly());
    }

    protected ByteSizeValue chunkSize() {
        return this.chunkSize;
    }

    public BlobPath basePath() {
        return this.basePath;
    }

    public List<Setting<?>> getRestrictedSystemRepositorySettings() {
        ArrayList restrictedSettings = new ArrayList();
        restrictedSettings.addAll(super.getRestrictedSystemRepositorySettings());
        restrictedSettings.add(LOCATION_SETTING);
        return restrictedSettings;
    }

    public static final class SettingsProviderImpl
    implements SettingsProvider {
        public List<? extends Setting<?>> getSettings() {
            return Arrays.asList(REPOSITORIES_CHUNK_SIZE_SETTING, REPOSITORIES_COMPRESS_SETTING, REPOSITORIES_LOCATION_SETTING);
        }
    }
}

