/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.rest;

import io.skylite.SkyliteException;
import io.skylite.SkyliteExceptionsHelper;
import io.skylite.SkyliteStatusException;
import io.skylite.core.common.bytes.BytesArray;
import io.skylite.core.common.bytes.BytesReference;
import io.skylite.core.rest.RestChannel;
import io.skylite.core.rest.RestRequest;
import io.skylite.core.rest.RestResponse;
import io.skylite.core.rest.RestStatus;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import java.io.IOException;
import java.util.Collections;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.logging.log4j.util.Supplier;

public class BytesRestResponse
extends RestResponse {
    public static final String TEXT_CONTENT_TYPE = "text/plain; charset=UTF-8";
    private static final String STATUS = "status";
    private static final Logger SUPPRESSED_ERROR_LOGGER = LogManager.getLogger((String)"rest.suppressed");
    private final RestStatus status;
    private final BytesReference content;
    private final String contentType;

    public BytesRestResponse(RestStatus status, XContentBuilder builder) {
        this(status, builder.contentType().mediaType(), BytesReference.bytes((XContentBuilder)builder));
    }

    public BytesRestResponse(RestStatus status, String content) {
        this(status, TEXT_CONTENT_TYPE, (BytesReference)new BytesArray(content));
    }

    public BytesRestResponse(RestStatus status, String contentType, String content) {
        this(status, contentType, (BytesReference)new BytesArray(content));
    }

    public BytesRestResponse(RestStatus status, String contentType, byte[] content) {
        this(status, contentType, (BytesReference)new BytesArray(content));
    }

    public BytesRestResponse(RestStatus status, String contentType, BytesReference content) {
        this.status = status;
        this.content = content;
        this.contentType = contentType;
    }

    public BytesRestResponse(RestChannel channel, Exception e) throws IOException {
        this(channel, SkyliteExceptionsHelper.status((Throwable)e), e);
    }

    public BytesRestResponse(RestChannel channel, RestStatus status, Exception e) throws IOException {
        ToXContent.Params params = this.paramsFromRequest(channel.request());
        if (params.paramAsBoolean("rest.exception.stacktrace.skip", true) && e != null) {
            Supplier messageSupplier = () -> new ParameterizedMessage("path: {}, params: {}", (Object)channel.request().rawPath(), (Object)channel.request().params());
            if (status.getStatus() < 500) {
                SUPPRESSED_ERROR_LOGGER.debug(messageSupplier, (Throwable)e);
            } else {
                SUPPRESSED_ERROR_LOGGER.warn(messageSupplier, (Throwable)e);
            }
        }
        this.status = status;
        try (XContentBuilder builder = channel.newErrorBuilder();){
            this.build(builder, params, status, channel.detailedErrorsEnabled(), e);
            this.content = BytesReference.bytes((XContentBuilder)builder);
            this.contentType = builder.contentType().mediaType();
        }
        if (e instanceof SkyliteException) {
            this.copyHeaders((SkyliteException)e);
        }
    }

    public String contentType() {
        return this.contentType;
    }

    public BytesReference content() {
        return this.content;
    }

    public RestStatus status() {
        return this.status;
    }

    private ToXContent.Params paramsFromRequest(RestRequest restRequest) {
        RestRequest params = restRequest;
        if (params.paramAsBoolean("error_trace", false) && !this.skipStackTrace()) {
            params = new ToXContent.DelegatingMapParams(Collections.singletonMap("rest.exception.stacktrace.skip", "false"), (ToXContent.Params)params);
        }
        return params;
    }

    protected boolean skipStackTrace() {
        return false;
    }

    private void build(XContentBuilder builder, ToXContent.Params params, RestStatus status, boolean detailedErrorsEnabled, Exception e) throws IOException {
        builder.startObject();
        SkyliteException.generateFailureXContent((XContentBuilder)builder, (ToXContent.Params)params, (Exception)e, (boolean)detailedErrorsEnabled);
        builder.field(STATUS, status.getStatus());
        builder.endObject();
    }

    static BytesRestResponse createSimpleErrorResponse(RestChannel channel, RestStatus status, String errorMessage) throws IOException {
        return new BytesRestResponse(status, channel.newErrorBuilder().startObject().field("error", errorMessage).field(STATUS, status.getStatus()).endObject());
    }

    public static SkyliteStatusException errorFromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token = parser.nextToken();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)token, (XContentParser)parser);
        SkyliteException exception = null;
        RestStatus status = null;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
            }
            if (STATUS.equals(currentFieldName)) {
                if (token == XContentParser.Token.FIELD_NAME) continue;
                XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.VALUE_NUMBER, (XContentParser.Token)token, (XContentParser)parser);
                status = RestStatus.fromCode((int)parser.intValue());
                continue;
            }
            exception = SkyliteException.failureFromXContent((XContentParser)parser);
        }
        if (exception == null) {
            throw new IllegalStateException("Failed to parse opensearch status exception: no exception was found");
        }
        SkyliteStatusException result = new SkyliteStatusException(exception.getMessage(), status, exception.getCause(), new Object[0]);
        for (String header : exception.getHeaderKeys()) {
            result.addHeader(header, exception.getHeader(header));
        }
        for (String metadata : exception.getMetadataKeys()) {
            result.addMetadata(metadata, exception.getMetadata(metadata));
        }
        return result;
    }
}

