/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.rest;

import io.skylite.SkyliteException;
import io.skylite.common.Nullable;
import io.skylite.common.PathTrie;
import io.skylite.common.rest.RestHeaderDefinition;
import io.skylite.common.util.io.Streams;
import io.skylite.common.xcontent.XContentType;
import io.skylite.core.FeatureFlags;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.common.Strings;
import io.skylite.core.common.breaker.CircuitBreaker;
import io.skylite.core.common.bytes.BytesArray;
import io.skylite.core.common.bytes.BytesReference;
import io.skylite.core.common.concurrent.ThreadContext;
import io.skylite.core.common.io.stream.BytesStreamOutput;
import io.skylite.core.common.logging.DeprecationLogger;
import io.skylite.core.http.HttpServerTransport;
import io.skylite.core.identity.IdentityService;
import io.skylite.core.identity.Subject;
import io.skylite.core.identity.tokens.AuthToken;
import io.skylite.core.identity.tokens.RestTokenExtractor;
import io.skylite.core.indices.breaker.CircuitBreakerService;
import io.skylite.core.rest.RestChannel;
import io.skylite.core.rest.RestHandler;
import io.skylite.core.rest.RestRequest;
import io.skylite.core.rest.RestResponse;
import io.skylite.core.rest.RestStatus;
import io.skylite.core.rest.RestUtils;
import io.skylite.core.xcontent.MediaType;
import io.skylite.core.xcontent.MediaTypeRegistry;
import io.skylite.core.xcontent.XContentBuilder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.DeprecationRestHandler;
import org.opensearch.rest.MethodHandlers;
import org.opensearch.usage.UsageService;

public class RestController
implements HttpServerTransport.Dispatcher {
    private static final Logger logger = LogManager.getLogger(RestController.class);
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(RestController.class);
    private static final String LUCENIA_PRODUCT_ORIGIN_HTTP_HEADER = "X-lucenia-product-origin";
    private static final BytesReference FAVICON_RESPONSE;
    private final PathTrie<MethodHandlers> handlers = new PathTrie(RestUtils.REST_DECODER);
    private final UnaryOperator<RestHandler> handlerWrapper;
    private final NodeClient client;
    private final CircuitBreakerService circuitBreakerService;
    private final Set<RestHeaderDefinition> headersToCopy;
    private final UsageService usageService;
    private final IdentityService identityService;

    public RestController(Set<RestHeaderDefinition> headersToCopy, UnaryOperator<RestHandler> handlerWrapper, NodeClient client, CircuitBreakerService circuitBreakerService, UsageService usageService, IdentityService identityService) {
        this.headersToCopy = headersToCopy;
        this.usageService = usageService;
        if (handlerWrapper == null) {
            handlerWrapper = h -> h;
        }
        this.handlerWrapper = handlerWrapper;
        this.client = client;
        this.circuitBreakerService = circuitBreakerService;
        this.identityService = identityService;
        this.registerHandlerNoWrap(RestRequest.Method.GET, "/favicon.ico", (request, channel, clnt) -> channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.OK, "image/x-icon", FAVICON_RESPONSE)));
    }

    protected void registerAsDeprecatedHandler(RestRequest.Method method, String path, RestHandler handler, String deprecationMessage) {
        assert (!(handler instanceof DeprecationRestHandler));
        this.registerHandler(method, path, new DeprecationRestHandler(handler, deprecationMessage, deprecationLogger));
    }

    protected void registerWithDeprecatedHandler(RestRequest.Method method, String path, RestHandler handler, RestRequest.Method deprecatedMethod, String deprecatedPath) {
        String deprecationMessage = "[" + deprecatedMethod.name() + " " + deprecatedPath + "] is deprecated! Use [" + method.name() + " " + path + "] instead.";
        this.registerHandler(method, path, handler);
        this.registerAsDeprecatedHandler(deprecatedMethod, deprecatedPath, handler, deprecationMessage);
    }

    protected void registerHandler(RestRequest.Method method, String path, RestHandler handler) {
        if (handler instanceof BaseRestHandler) {
            this.usageService.addRestHandler((BaseRestHandler)handler);
        }
        this.registerHandlerNoWrap(method, path, (RestHandler)this.handlerWrapper.apply(handler));
    }

    private void registerHandlerNoWrap(RestRequest.Method method, String path, RestHandler maybeWrappedHandler) {
        this.handlers.insertOrUpdate(path, (Object)new MethodHandlers(path, maybeWrappedHandler, method), (mHandlers, newMHandler) -> mHandlers.addMethods(maybeWrappedHandler, method));
    }

    public void registerHandler(RestHandler restHandler) {
        restHandler.routes().forEach(route -> this.registerHandler(route.getMethod(), route.getPath(), restHandler));
        restHandler.deprecatedRoutes().forEach(route -> this.registerAsDeprecatedHandler(route.getMethod(), route.getPath(), restHandler, route.getDeprecationMessage()));
        restHandler.replacedRoutes().forEach(route -> this.registerWithDeprecatedHandler(route.getMethod(), route.getPath(), restHandler, route.getDeprecatedMethod(), route.getDeprecatedPath()));
    }

    public void dispatchRequest(RestRequest request, RestChannel channel, ThreadContext threadContext) {
        try {
            this.tryAllHandlers(request, channel, threadContext);
        }
        catch (Exception e) {
            try {
                channel.sendResponse((RestResponse)new BytesRestResponse(channel, e));
            }
            catch (Exception inner) {
                inner.addSuppressed(e);
                logger.error(() -> new ParameterizedMessage("failed to send failure response for uri [{}]", (Object)request.uri()), (Throwable)inner);
            }
        }
    }

    public void dispatchBadRequest(RestChannel channel, ThreadContext threadContext, Throwable cause) {
        try {
            Exception e = cause == null ? new SkyliteException("unknown cause", new Object[0]) : (cause instanceof Exception ? (Exception)cause : new SkyliteException(cause));
            channel.sendResponse((RestResponse)new BytesRestResponse(channel, RestStatus.BAD_REQUEST, e));
        }
        catch (IOException e) {
            if (cause != null) {
                e.addSuppressed(cause);
            }
            logger.warn("failed to send bad request response", (Throwable)e);
            channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.INTERNAL_SERVER_ERROR, "text/plain; charset=UTF-8", (BytesReference)BytesArray.EMPTY));
        }
    }

    private void dispatchRequest(RestRequest request, RestChannel channel, RestHandler handler) throws Exception {
        int contentLength = request.content().length();
        if (contentLength > 0) {
            MediaType mediaType = request.getMediaType();
            if (mediaType == null) {
                this.sendContentTypeErrorMessage(request.getAllHeaderValues("Content-Type"), channel);
                return;
            }
            if (handler.supportsContentStream() && mediaType != MediaTypeRegistry.JSON && mediaType != XContentType.SMILE) {
                channel.sendResponse((RestResponse)BytesRestResponse.createSimpleErrorResponse(channel, RestStatus.NOT_ACCEPTABLE, "Content-Type [" + String.valueOf(mediaType) + "] does not support stream parsing. Use JSON or SMILE instead"));
                return;
            }
        }
        RestChannel responseChannel = channel;
        try {
            if (handler.canTripCircuitBreaker()) {
                RestController.inFlightRequestsBreaker(this.circuitBreakerService).addEstimateBytesAndMaybeBreak((long)contentLength, "<http_request>");
            } else {
                RestController.inFlightRequestsBreaker(this.circuitBreakerService).addWithoutBreaking((long)contentLength);
            }
            responseChannel = new ResourceHandlingHttpChannel(channel, this.circuitBreakerService, contentLength);
            if (!handler.allowsUnsafeBuffers()) {
                request.ensureSafeBuffers();
            }
            if (!handler.allowSystemIndexAccessByDefault() && request.header(LUCENIA_PRODUCT_ORIGIN_HTTP_HEADER) == null) {
                this.client.threadPool().getThreadContext().putHeader("_system_index_access_allowed", Boolean.FALSE.toString());
            }
            handler.handleRequest(request, responseChannel, this.client);
        }
        catch (Exception e) {
            responseChannel.sendResponse((RestResponse)new BytesRestResponse(responseChannel, e));
        }
    }

    private boolean handleNoHandlerFound(String rawPath, RestRequest.Method method, String uri, RestChannel channel) {
        Set<RestRequest.Method> validMethodSet = this.getValidHandlerMethodSet(rawPath);
        if (!validMethodSet.contains(method)) {
            if (method == RestRequest.Method.OPTIONS) {
                this.handleOptionsRequest(channel, validMethodSet);
                return true;
            }
            if (!validMethodSet.isEmpty()) {
                this.handleUnsupportedHttpMethod(uri, method, channel, validMethodSet, null);
                return true;
            }
        }
        return false;
    }

    private void sendContentTypeErrorMessage(@Nullable List<String> contentTypeHeader, RestChannel channel) throws IOException {
        Object errorMessage = contentTypeHeader == null ? "Content-Type header is missing" : "Content-Type header [" + Strings.collectionToCommaDelimitedString(contentTypeHeader) + "] is not supported";
        channel.sendResponse((RestResponse)BytesRestResponse.createSimpleErrorResponse(channel, RestStatus.NOT_ACCEPTABLE, (String)errorMessage));
    }

    private void tryAllHandlers(RestRequest request, RestChannel channel, ThreadContext threadContext) throws Exception {
        RestRequest.Method requestMethod;
        for (RestHeaderDefinition restHeader : this.headersToCopy) {
            String name = restHeader.getName();
            List headerValues = request.getAllHeaderValues(name);
            if (headerValues == null || headerValues.isEmpty()) continue;
            List distinctHeaderValues = headerValues.stream().distinct().collect(Collectors.toList());
            if (!restHeader.isMultiValueAllowed() && distinctHeaderValues.size() > 1) {
                channel.sendResponse((RestResponse)BytesRestResponse.createSimpleErrorResponse(channel, RestStatus.BAD_REQUEST, "multiple values for single-valued header [" + name + "]."));
                return;
            }
            threadContext.putHeader(name, String.join((CharSequence)",", distinctHeaderValues));
        }
        if (request.paramAsBoolean("error_trace", false) && !channel.detailedErrorsEnabled()) {
            channel.sendResponse((RestResponse)BytesRestResponse.createSimpleErrorResponse(channel, RestStatus.BAD_REQUEST, "error traces in responses are disabled."));
            return;
        }
        String rawPath = request.rawPath();
        String uri = request.uri();
        try {
            requestMethod = request.method();
            Iterator<MethodHandlers> allHandlers = this.getAllHandlers(request.params(), rawPath);
            while (allHandlers.hasNext()) {
                MethodHandlers handlers = allHandlers.next();
                RestHandler handler = handlers == null ? null : handlers.getHandler(requestMethod);
                if (handler == null) {
                    if (!this.handleNoHandlerFound(rawPath, requestMethod, uri, channel)) continue;
                    return;
                }
                if (FeatureFlags.isEnabled((String)"lucenia.experimental.feature.identity.enabled") && !this.handleAuthenticateUser(request, channel)) {
                    return;
                }
                this.dispatchRequest(request, channel, handler);
                return;
            }
        }
        catch (IllegalArgumentException e) {
            this.handleUnsupportedHttpMethod(uri, null, channel, this.getValidHandlerMethodSet(rawPath), e);
            return;
        }
        this.handleBadRequest(uri, requestMethod, channel);
    }

    Iterator<MethodHandlers> getAllHandlers(@Nullable Map<String, String> requestParamsRef, String rawPath) {
        Supplier<Map> paramsSupplier;
        if (requestParamsRef == null) {
            paramsSupplier = () -> null;
        } else {
            HashMap<String, String> originalParams = new HashMap<String, String>(requestParamsRef);
            paramsSupplier = () -> {
                requestParamsRef.clear();
                requestParamsRef.putAll(originalParams);
                return requestParamsRef;
            };
        }
        return this.handlers.retrieveAll(rawPath, paramsSupplier);
    }

    private void handleUnsupportedHttpMethod(String uri, @Nullable RestRequest.Method method, RestChannel channel, Set<RestRequest.Method> validMethodSet, @Nullable IllegalArgumentException exception) {
        try {
            StringBuilder msg = new StringBuilder();
            if (exception == null) {
                msg.append("Incorrect HTTP method for uri [").append(uri);
                msg.append("] and method [").append(method).append("]");
            } else {
                msg.append("Unexpected HTTP method");
            }
            if (!validMethodSet.isEmpty()) {
                msg.append(", allowed: ").append(validMethodSet);
            }
            BytesRestResponse bytesRestResponse = BytesRestResponse.createSimpleErrorResponse(channel, RestStatus.METHOD_NOT_ALLOWED, msg.toString());
            if (!validMethodSet.isEmpty()) {
                bytesRestResponse.addHeader("Allow", Strings.collectionToDelimitedString(validMethodSet, (String)","));
            }
            channel.sendResponse((RestResponse)bytesRestResponse);
        }
        catch (IOException e) {
            logger.warn("failed to send bad request response", (Throwable)e);
            channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.INTERNAL_SERVER_ERROR, "text/plain; charset=UTF-8", (BytesReference)BytesArray.EMPTY));
        }
    }

    private void handleOptionsRequest(RestChannel channel, Set<RestRequest.Method> validMethodSet) {
        BytesRestResponse bytesRestResponse = new BytesRestResponse(RestStatus.OK, "text/plain; charset=UTF-8", (BytesReference)BytesArray.EMPTY);
        if (!validMethodSet.isEmpty()) {
            bytesRestResponse.addHeader("Allow", Strings.collectionToDelimitedString(validMethodSet, (String)","));
        }
        channel.sendResponse((RestResponse)bytesRestResponse);
    }

    private void handleBadRequest(String uri, RestRequest.Method method, RestChannel channel) throws IOException {
        try (XContentBuilder builder = channel.newErrorBuilder();){
            builder.startObject();
            try {
                uri = new URI(uri).getPath();
                builder.field("error", "no handler found for uri [" + uri + "] and method [" + String.valueOf(method) + "]");
            }
            catch (Exception e) {
                builder.field("error", "invalid uri has been requested");
            }
            builder.endObject();
            channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.BAD_REQUEST, builder));
        }
    }

    private boolean handleAuthenticateUser(RestRequest request, RestChannel channel) {
        try {
            AuthToken token = RestTokenExtractor.extractToken((RestRequest)request);
            if (token == null) {
                return true;
            }
            Subject currentSubject = this.identityService.getSubject();
            currentSubject.authenticate(token);
            logger.debug("Logged in as user " + String.valueOf(currentSubject));
        }
        catch (Exception e) {
            try {
                BytesRestResponse bytesRestResponse = BytesRestResponse.createSimpleErrorResponse(channel, RestStatus.UNAUTHORIZED, e.getMessage());
                channel.sendResponse((RestResponse)bytesRestResponse);
            }
            catch (Exception ex) {
                BytesRestResponse bytesRestResponse = new BytesRestResponse(RestStatus.UNAUTHORIZED, ex.getMessage());
                channel.sendResponse((RestResponse)bytesRestResponse);
            }
            return false;
        }
        return true;
    }

    private Set<RestRequest.Method> getValidHandlerMethodSet(String rawPath) {
        HashSet<RestRequest.Method> validMethods = new HashSet<RestRequest.Method>();
        Iterator<MethodHandlers> allHandlers = this.getAllHandlers(null, rawPath);
        while (allHandlers.hasNext()) {
            MethodHandlers methodHandlers = allHandlers.next();
            if (methodHandlers == null) continue;
            validMethods.addAll(methodHandlers.getValidMethods());
        }
        return validMethods;
    }

    private static CircuitBreaker inFlightRequestsBreaker(CircuitBreakerService circuitBreakerService) {
        return circuitBreakerService.getBreaker("in_flight_requests");
    }

    static {
        try (InputStream stream = RestController.class.getResourceAsStream("/config/favicon.ico");){
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            Streams.copy((InputStream)stream, (OutputStream)out);
            FAVICON_RESPONSE = new BytesArray(out.toByteArray());
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static final class ResourceHandlingHttpChannel
    implements RestChannel {
        private final RestChannel delegate;
        private final CircuitBreakerService circuitBreakerService;
        private final int contentLength;
        private final AtomicBoolean closed = new AtomicBoolean();

        ResourceHandlingHttpChannel(RestChannel delegate, CircuitBreakerService circuitBreakerService, int contentLength) {
            this.delegate = delegate;
            this.circuitBreakerService = circuitBreakerService;
            this.contentLength = contentLength;
        }

        public XContentBuilder newBuilder() throws IOException {
            return this.delegate.newBuilder();
        }

        public XContentBuilder newErrorBuilder() throws IOException {
            return this.delegate.newErrorBuilder();
        }

        public XContentBuilder newBuilder(@Nullable MediaType mediaType, boolean useFiltering) throws IOException {
            return this.delegate.newBuilder(mediaType, useFiltering);
        }

        public XContentBuilder newBuilder(MediaType mediaType, MediaType responseContentType, boolean useFiltering) throws IOException {
            return this.delegate.newBuilder(mediaType, responseContentType, useFiltering);
        }

        public BytesStreamOutput bytesOutput() {
            return this.delegate.bytesOutput();
        }

        public RestRequest request() {
            return this.delegate.request();
        }

        public boolean detailedErrorsEnabled() {
            return this.delegate.detailedErrorsEnabled();
        }

        public void sendResponse(RestResponse response) {
            this.close();
            this.delegate.sendResponse(response);
        }

        private void close() {
            if (!this.closed.compareAndSet(false, true)) {
                throw new IllegalStateException("Channel is already closed");
            }
            RestController.inFlightRequestsBreaker(this.circuitBreakerService).addWithoutBreaking((long)(-this.contentLength));
        }
    }
}

