/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.rest;

import io.skylite.SkyliteException;
import io.skylite.common.collect.Tuple;
import io.skylite.core.common.Strings;
import io.skylite.core.common.bytes.BytesReference;
import io.skylite.core.rest.RestRequest;
import io.skylite.core.xcontent.MediaType;
import io.skylite.core.xcontent.XContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentHelper;
import io.skylite.core.xcontent.util.XContentMapValuesUtil;
import java.io.IOException;
import java.util.Map;
import java.util.Set;

public interface RestRequestFilter {
    default public RestRequest getFilteredRequest(final RestRequest restRequest) throws IOException {
        final Set<String> fields = this.getFilteredFields();
        if (restRequest.hasContent() && !fields.isEmpty()) {
            return new RestRequest(this, restRequest){
                private BytesReference filteredBytes;
                {
                    super(restRequest3);
                    this.filteredBytes = null;
                }

                public boolean hasContent() {
                    return true;
                }

                public BytesReference content() {
                    if (this.filteredBytes == null) {
                        BytesReference content = restRequest.content();
                        Tuple result = XContentHelper.convertToMap((BytesReference)content, (boolean)true);
                        Map transformedSource = XContentMapValuesUtil.filter((Map)((Map)result.v2()), null, (String[])fields.toArray(Strings.EMPTY_ARRAY));
                        try {
                            XContentBuilder xContentBuilder = XContentBuilder.builder((XContent)((MediaType)result.v1()).xContent()).map(transformedSource);
                            this.filteredBytes = BytesReference.bytes((XContentBuilder)xContentBuilder);
                        }
                        catch (IOException e) {
                            throw new SkyliteException("failed to parse request", (Throwable)e, new Object[0]);
                        }
                    }
                    return this.filteredBytes;
                }
            };
        }
        return restRequest;
    }

    public Set<String> getFilteredFields();
}

