/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.rest.action.admin.cluster;

import io.skylite.common.unit.TimeValue;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionType;
import io.skylite.core.action.admin.cluster.configuration.AddVotingConfigExclusionsAction;
import io.skylite.core.action.admin.cluster.configuration.AddVotingConfigExclusionsRequest;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.common.Strings;
import io.skylite.core.rest.RestChannel;
import io.skylite.core.rest.RestHandler;
import io.skylite.core.rest.RestRequest;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.action.RestToXContentListener;

public class RestAddVotingConfigExclusionAction
extends BaseRestHandler {
    private static final TimeValue DEFAULT_TIMEOUT = TimeValue.timeValueSeconds((long)30L);
    private static final Logger logger = LogManager.getLogger(RestAddVotingConfigExclusionAction.class);
    private static final String DEPRECATION_MESSAGE = "POST /_cluster/voting_config_exclusions/{node_name} will be removed in a future version. Please use POST /_cluster/voting_config_exclusions?node_ids=... or POST /_cluster/voting_config_exclusions?node_names=... instead.";

    @Override
    public String getName() {
        return "add_voting_config_exclusions_action";
    }

    public List<RestHandler.Route> routes() {
        return Arrays.asList(new RestHandler.DeprecatedRoute(RestRequest.Method.POST, "/_cluster/voting_config_exclusions/{node_name}", DEPRECATION_MESSAGE), new RestHandler.Route(RestRequest.Method.POST, "/_cluster/voting_config_exclusions"));
    }

    @Override
    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        AddVotingConfigExclusionsRequest votingConfigExclusionsRequest = this.resolveVotingConfigExclusionsRequest(request);
        return channel -> client.execute((ActionType)AddVotingConfigExclusionsAction.INSTANCE, (ActionRequest)votingConfigExclusionsRequest, new RestToXContentListener((RestChannel)channel));
    }

    AddVotingConfigExclusionsRequest resolveVotingConfigExclusionsRequest(RestRequest request) {
        String deprecatedNodeDescription = null;
        String nodeIds = null;
        String nodeNames = null;
        if (request.hasParam("node_name")) {
            deprecatedNodeDescription = request.param("node_name");
        }
        if (request.hasParam("node_ids")) {
            nodeIds = request.param("node_ids");
        }
        if (request.hasParam("node_names")) {
            nodeNames = request.param("node_names");
        }
        return new AddVotingConfigExclusionsRequest(Strings.splitStringByCommaToArray((String)deprecatedNodeDescription), Strings.splitStringByCommaToArray((String)nodeIds), Strings.splitStringByCommaToArray((String)nodeNames), TimeValue.parseTimeValue((String)request.param("timeout"), (TimeValue)DEFAULT_TIMEOUT, (String)(this.getClass().getSimpleName() + ".timeout")));
    }
}

