/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.rest.action.admin.cluster;

import io.skylite.common.unit.TimeValue;
import io.skylite.core.action.admin.cluster.decommission.awareness.put.DecommissionRequest;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.cluster.decommission.DecommissionAttribute;
import io.skylite.core.rest.RestChannel;
import io.skylite.core.rest.RestHandler;
import io.skylite.core.rest.RestRequest;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.action.RestToXContentListener;

public class RestDecommissionAction
extends BaseRestHandler {
    public List<RestHandler.Route> routes() {
        return Collections.singletonList(new RestHandler.Route(RestRequest.Method.PUT, "/_cluster/decommission/awareness/{awareness_attribute_name}/{awareness_attribute_value}"));
    }

    @Override
    public String getName() {
        return "decommission_action";
    }

    @Override
    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        DecommissionRequest decommissionRequest = this.createRequest(request);
        return channel -> client.admin().cluster().decommission(decommissionRequest, new RestToXContentListener((RestChannel)channel));
    }

    DecommissionRequest createRequest(RestRequest request) throws IOException {
        DecommissionRequest decommissionRequest = new DecommissionRequest();
        String attributeName = request.param("awareness_attribute_name");
        String attributeValue = request.param("awareness_attribute_value");
        boolean noDelay = request.paramAsBoolean("no_delay", false);
        decommissionRequest.setNoDelay(noDelay);
        if (request.hasParam("delay_timeout")) {
            TimeValue delayTimeout = request.paramAsTime("delay_timeout", DecommissionRequest.DEFAULT_NODE_DRAINING_TIMEOUT);
            decommissionRequest.setDelayTimeout(delayTimeout);
        }
        return decommissionRequest.setDecommissionAttribute(new DecommissionAttribute(attributeName, attributeValue));
    }
}

