/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.rest.action.admin.cluster;

import io.skylite.core.action.admin.cluster.repositories.get.GetRepositoriesRequest;
import io.skylite.core.action.clustermanager.ClusterManagerNodeRequest;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.common.Strings;
import io.skylite.core.common.logging.DeprecationLogger;
import io.skylite.core.rest.RestChannel;
import io.skylite.core.rest.RestHandler;
import io.skylite.core.rest.RestRequest;
import io.skylite.core.settings.Settings;
import io.skylite.core.settings.SettingsFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.action.RestToXContentListener;

public class RestGetRepositoriesAction
extends BaseRestHandler {
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(RestGetRepositoriesAction.class);
    private final SettingsFilter settingsFilter;

    public RestGetRepositoriesAction(SettingsFilter settingsFilter) {
        this.settingsFilter = settingsFilter;
    }

    @Override
    public String getName() {
        return "get_repositories_action";
    }

    public List<RestHandler.Route> routes() {
        return Collections.unmodifiableList(Arrays.asList(new RestHandler.Route(RestRequest.Method.GET, "/_snapshot"), new RestHandler.Route(RestRequest.Method.GET, "/_snapshot/{repository}")));
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        String[] repositories = request.paramAsStringArray("repository", Strings.EMPTY_ARRAY);
        GetRepositoriesRequest getRepositoriesRequest = new GetRepositoriesRequest(repositories);
        getRepositoriesRequest.clusterManagerNodeTimeout(request.paramAsTime("cluster_manager_timeout", getRepositoriesRequest.clusterManagerNodeTimeout()));
        RestGetRepositoriesAction.parseDeprecatedMasterTimeoutParameter((ClusterManagerNodeRequest)getRepositoriesRequest, request, deprecationLogger, this.getName());
        getRepositoriesRequest.local(request.paramAsBoolean("local", getRepositoriesRequest.local()));
        request.addSettingFilterParams(this.settingsFilter);
        return channel -> client.admin().cluster().getRepositories(getRepositoriesRequest, new RestToXContentListener((RestChannel)channel));
    }

    @Override
    protected Set<String> responseParams() {
        return Settings.FORMAT_PARAMS;
    }
}

