/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.rest.action.admin.cluster;

import io.skylite.common.action.ActionListener;
import io.skylite.core.action.admin.cluster.node.usage.NodesUsageRequest;
import io.skylite.core.action.admin.cluster.node.usage.NodesUsageResponse;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.common.Strings;
import io.skylite.core.rest.RestHandler;
import io.skylite.core.rest.RestRequest;
import io.skylite.core.rest.RestResponse;
import io.skylite.core.rest.RestStatus;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.action.RestActions;
import org.opensearch.rest.action.RestBuilderListener;

public class RestNodesUsageAction
extends BaseRestHandler {
    public List<RestHandler.Route> routes() {
        return Collections.unmodifiableList(Arrays.asList(new RestHandler.Route(RestRequest.Method.GET, "/_nodes/usage"), new RestHandler.Route(RestRequest.Method.GET, "/_nodes/{nodeId}/usage"), new RestHandler.Route(RestRequest.Method.GET, "/_nodes/usage/{metric}"), new RestHandler.Route(RestRequest.Method.GET, "/_nodes/{nodeId}/usage/{metric}")));
    }

    @Override
    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        String[] nodesIds = Strings.splitStringByCommaToArray((String)request.param("nodeId"));
        Set metrics = Strings.tokenizeByCommaToSet((String)request.param("metric", "_all"));
        NodesUsageRequest nodesUsageRequest = new NodesUsageRequest(nodesIds);
        nodesUsageRequest.timeout(request.param("timeout"));
        if (metrics.size() == 1 && metrics.contains("_all")) {
            nodesUsageRequest.all();
        } else {
            if (metrics.contains("_all")) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "request [%s] contains _all and individual metrics [%s]", request.path(), request.param("metric")));
            }
            nodesUsageRequest.clear();
            nodesUsageRequest.restActions(metrics.contains("rest_actions"));
            nodesUsageRequest.aggregations(metrics.contains("aggregations"));
        }
        return channel -> client.admin().cluster().nodesUsage(nodesUsageRequest, (ActionListener)new RestBuilderListener<NodesUsageResponse>(this, channel){

            @Override
            public RestResponse buildResponse(NodesUsageResponse response, XContentBuilder builder) throws Exception {
                builder.startObject();
                RestActions.buildNodesHeader(builder, (ToXContent.Params)this.channel.request(), response);
                builder.field("cluster_name", response.getClusterName().value());
                response.toXContent(builder, (ToXContent.Params)this.channel.request());
                builder.endObject();
                return new BytesRestResponse(RestStatus.OK, builder);
            }
        });
    }

    @Override
    public String getName() {
        return "nodes_usage_action";
    }

    public boolean canTripCircuitBreaker() {
        return false;
    }
}

