/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.rest.action.admin.cluster;

import io.skylite.core.action.admin.cluster.storedscripts.PutStoredScriptRequest;
import io.skylite.core.action.clustermanager.ClusterManagerNodeRequest;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.common.bytes.BytesReference;
import io.skylite.core.common.logging.DeprecationLogger;
import io.skylite.core.rest.RestChannel;
import io.skylite.core.rest.RestHandler;
import io.skylite.core.rest.RestRequest;
import io.skylite.core.script.StoredScriptSource;
import io.skylite.core.xcontent.MediaType;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.action.RestToXContentListener;

public class RestPutStoredScriptAction
extends BaseRestHandler {
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(RestPutStoredScriptAction.class);

    public List<RestHandler.Route> routes() {
        return Collections.unmodifiableList(Arrays.asList(new RestHandler.Route(RestRequest.Method.POST, "/_scripts/{id}"), new RestHandler.Route(RestRequest.Method.PUT, "/_scripts/{id}"), new RestHandler.Route(RestRequest.Method.POST, "/_scripts/{id}/{context}"), new RestHandler.Route(RestRequest.Method.PUT, "/_scripts/{id}/{context}")));
    }

    @Override
    public String getName() {
        return "put_stored_script_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        String id = request.param("id");
        String context = request.param("context");
        BytesReference content = request.requiredContent();
        MediaType mediaType = request.getMediaType();
        StoredScriptSource source = StoredScriptSource.parse((BytesReference)content, (MediaType)mediaType);
        PutStoredScriptRequest putRequest = new PutStoredScriptRequest(id, context, content, request.getMediaType(), source);
        putRequest.clusterManagerNodeTimeout(request.paramAsTime("cluster_manager_timeout", putRequest.clusterManagerNodeTimeout()));
        RestPutStoredScriptAction.parseDeprecatedMasterTimeoutParameter((ClusterManagerNodeRequest)putRequest, request, deprecationLogger, this.getName());
        putRequest.timeout(request.paramAsTime("timeout", putRequest.timeout()));
        return channel -> client.admin().cluster().putStoredScript(putRequest, new RestToXContentListener((RestChannel)channel));
    }
}

