/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.rest.action.admin.cluster;

import io.skylite.core.action.admin.cluster.remotestore.stats.RemoteStoreStatsRequest;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.rest.RestChannel;
import io.skylite.core.rest.RestHandler;
import io.skylite.core.rest.RestRequest;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.action.RestToXContentListener;

public class RestRemoteStoreStatsAction
extends BaseRestHandler {
    public List<RestHandler.Route> routes() {
        return Collections.unmodifiableList(Arrays.asList(new RestHandler.Route(RestRequest.Method.GET, "/_remotestore/stats/{index}"), new RestHandler.Route(RestRequest.Method.GET, "/_remotestore/stats/{index}/{shard_id}")));
    }

    @Override
    public String getName() {
        return "remote_store_stats";
    }

    @Override
    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        String index = request.param("index");
        String shardId = request.param("shard_id");
        boolean local = Objects.equals(request.param("local"), "true");
        RemoteStoreStatsRequest remoteStoreStatsRequest = new RemoteStoreStatsRequest();
        if (index != null) {
            remoteStoreStatsRequest.indices(new String[]{index});
        }
        if (shardId != null) {
            remoteStoreStatsRequest.shards(new String[]{shardId});
        }
        remoteStoreStatsRequest.local(local);
        return channel -> client.admin().cluster().remoteStoreStats(remoteStoreStatsRequest, new RestToXContentListener((RestChannel)channel));
    }
}

