/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.rest.action.admin.cluster;

import io.skylite.core.action.admin.cluster.repositories.verify.VerifyRepositoryRequest;
import io.skylite.core.action.clustermanager.ClusterManagerNodeRequest;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.common.logging.DeprecationLogger;
import io.skylite.core.rest.RestChannel;
import io.skylite.core.rest.RestHandler;
import io.skylite.core.rest.RestRequest;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.action.RestToXContentListener;

public class RestVerifyRepositoryAction
extends BaseRestHandler {
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(RestVerifyRepositoryAction.class);

    public List<RestHandler.Route> routes() {
        return Collections.singletonList(new RestHandler.Route(RestRequest.Method.POST, "/_snapshot/{repository}/_verify"));
    }

    @Override
    public String getName() {
        return "verify_repository_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        VerifyRepositoryRequest verifyRepositoryRequest = new VerifyRepositoryRequest(request.param("repository"));
        verifyRepositoryRequest.clusterManagerNodeTimeout(request.paramAsTime("cluster_manager_timeout", verifyRepositoryRequest.clusterManagerNodeTimeout()));
        RestVerifyRepositoryAction.parseDeprecatedMasterTimeoutParameter((ClusterManagerNodeRequest)verifyRepositoryRequest, request, deprecationLogger, this.getName());
        verifyRepositoryRequest.timeout(request.paramAsTime("timeout", verifyRepositoryRequest.timeout()));
        return channel -> client.admin().cluster().verifyRepository(verifyRepositoryRequest, new RestToXContentListener((RestChannel)channel));
    }
}

