/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.rest.action.admin.indices;

import io.skylite.core.ParseField;
import io.skylite.core.action.admin.indices.analyze.AnalyzeAction;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.rest.RestChannel;
import io.skylite.core.rest.RestHandler;
import io.skylite.core.rest.RestRequest;
import io.skylite.core.xcontent.XContentParser;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.action.RestToXContentListener;

public class RestAnalyzeAction
extends BaseRestHandler {
    public List<RestHandler.Route> routes() {
        return Collections.unmodifiableList(Arrays.asList(new RestHandler.Route(RestRequest.Method.GET, "/_analyze"), new RestHandler.Route(RestRequest.Method.POST, "/_analyze"), new RestHandler.Route(RestRequest.Method.GET, "/{index}/_analyze"), new RestHandler.Route(RestRequest.Method.POST, "/{index}/_analyze")));
    }

    @Override
    public String getName() {
        return "analyze_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        try (XContentParser parser = request.contentOrSourceParamParser();){
            AnalyzeAction.Request analyzeRequest = AnalyzeAction.Request.fromXContent((XContentParser)parser, (String)request.param("index"));
            BaseRestHandler.RestChannelConsumer restChannelConsumer = channel -> client.admin().indices().analyze(analyzeRequest, new RestToXContentListener((RestChannel)channel));
            return restChannelConsumer;
        }
    }

    public static class Fields {
        public static final ParseField ANALYZER = new ParseField("analyzer", new String[0]);
        public static final ParseField TEXT = new ParseField("text", new String[0]);
        public static final ParseField FIELD = new ParseField("field", new String[0]);
        public static final ParseField TOKENIZER = new ParseField("tokenizer", new String[0]);
        public static final ParseField TOKEN_FILTERS = new ParseField("filter", new String[0]);
        public static final ParseField CHAR_FILTERS = new ParseField("char_filter", new String[0]);
        public static final ParseField EXPLAIN = new ParseField("explain", new String[0]);
        public static final ParseField ATTRIBUTES = new ParseField("attributes", new String[0]);
        public static final ParseField NORMALIZER = new ParseField("normalizer", new String[0]);
    }
}

