/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.rest.action.admin.indices;

import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionType;
import io.skylite.core.action.admin.indices.forcemerge.ForceMergeAction;
import io.skylite.core.action.admin.indices.forcemerge.ForceMergeRequest;
import io.skylite.core.action.support.IndicesOptions;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.common.Strings;
import io.skylite.core.common.logging.DeprecationLogger;
import io.skylite.core.rest.RestChannel;
import io.skylite.core.rest.RestHandler;
import io.skylite.core.rest.RestRequest;
import io.skylite.core.tasks.LoggingTaskListener;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.action.RestToXContentListener;

public class RestForceMergeAction
extends BaseRestHandler {
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(RestForceMergeAction.class);

    public List<RestHandler.Route> routes() {
        return Collections.unmodifiableList(Arrays.asList(new RestHandler.Route(RestRequest.Method.POST, "/_forcemerge"), new RestHandler.Route(RestRequest.Method.POST, "/{index}/_forcemerge")));
    }

    @Override
    public String getName() {
        return "force_merge_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        ForceMergeRequest mergeRequest = new ForceMergeRequest(Strings.splitStringByCommaToArray((String)request.param("index")));
        mergeRequest.indicesOptions(IndicesOptions.fromRequest((RestRequest)request, (IndicesOptions)mergeRequest.indicesOptions()));
        mergeRequest.maxNumSegments(request.paramAsInt("max_num_segments", mergeRequest.maxNumSegments()));
        mergeRequest.onlyExpungeDeletes(request.paramAsBoolean("only_expunge_deletes", mergeRequest.onlyExpungeDeletes()));
        mergeRequest.flush(request.paramAsBoolean("flush", mergeRequest.flush()));
        if (mergeRequest.onlyExpungeDeletes() && mergeRequest.maxNumSegments() != -1) {
            deprecationLogger.deprecate("force_merge_expunge_deletes_and_max_num_segments_deprecation", "setting only_expunge_deletes and max_num_segments at the same time is deprecated and will be rejected in a future version", new Object[0]);
        }
        if (request.paramAsBoolean("wait_for_completion", true)) {
            return channel -> client.admin().indices().forceMerge(mergeRequest, new RestToXContentListener((RestChannel)channel));
        }
        mergeRequest.setShouldStoreResult(true);
        return this.sendTask(client.getLocalNodeId(), client.executeLocally((ActionType)ForceMergeAction.INSTANCE, (ActionRequest)mergeRequest, LoggingTaskListener.instance()));
    }
}

