/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.rest.action.admin.indices;

import io.skylite.common.action.ActionListener;
import io.skylite.core.action.admin.indices.mapping.get.GetFieldMappingsRequest;
import io.skylite.core.action.admin.indices.mapping.get.GetFieldMappingsResponse;
import io.skylite.core.action.support.IndicesOptions;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.common.Strings;
import io.skylite.core.common.logging.DeprecationLogger;
import io.skylite.core.rest.RestHandler;
import io.skylite.core.rest.RestRequest;
import io.skylite.core.rest.RestResponse;
import io.skylite.core.rest.RestStatus;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.action.RestBuilderListener;

public class RestGetFieldMappingAction
extends BaseRestHandler {
    private static final Logger logger = LogManager.getLogger(RestGetFieldMappingAction.class);
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger((String)logger.getName());

    public List<RestHandler.Route> routes() {
        return Collections.unmodifiableList(Arrays.asList(new RestHandler.Route(RestRequest.Method.GET, "/_mapping/field/{fields}"), new RestHandler.Route(RestRequest.Method.GET, "/{index}/_mapping/field/{fields}")));
    }

    @Override
    public String getName() {
        return "get_field_mapping_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(final RestRequest request, NodeClient client) throws IOException {
        String[] indices = Strings.splitStringByCommaToArray((String)request.param("index"));
        final String[] fields = Strings.splitStringByCommaToArray((String)request.param("fields"));
        GetFieldMappingsRequest getMappingsRequest = new GetFieldMappingsRequest();
        getMappingsRequest.indices(indices).fields(fields).includeDefaults(request.paramAsBoolean("include_defaults", false));
        getMappingsRequest.indicesOptions(IndicesOptions.fromRequest((RestRequest)request, (IndicesOptions)getMappingsRequest.indicesOptions()));
        if (request.hasParam("local")) {
            deprecationLogger.deprecate("get_field_mapping_local", "Use [local] in get field mapping requests is deprecated. The parameter will be removed in the next major version", new Object[0]);
        }
        getMappingsRequest.local(request.paramAsBoolean("local", getMappingsRequest.local()));
        return channel -> client.admin().indices().getFieldMappings(getMappingsRequest, (ActionListener)new RestBuilderListener<GetFieldMappingsResponse>(this, channel){

            @Override
            public RestResponse buildResponse(GetFieldMappingsResponse response, XContentBuilder builder) throws Exception {
                Map mappingsByIndex = response.mappings();
                RestStatus status = RestStatus.OK;
                if (mappingsByIndex.isEmpty() && fields.length > 0) {
                    status = RestStatus.NOT_FOUND;
                }
                response.toXContent(builder, (ToXContent.Params)request);
                return new BytesRestResponse(status, builder);
            }
        });
    }
}

