/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.rest.action.admin.indices;

import io.skylite.common.action.ActionListener;
import io.skylite.core.action.admin.indices.template.get.GetIndexTemplatesRequest;
import io.skylite.core.action.admin.indices.template.get.GetIndexTemplatesResponse;
import io.skylite.core.action.clustermanager.ClusterManagerNodeRequest;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.common.Strings;
import io.skylite.core.common.logging.DeprecationLogger;
import io.skylite.core.rest.RestHandler;
import io.skylite.core.rest.RestRequest;
import io.skylite.core.rest.RestStatus;
import io.skylite.core.settings.Settings;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.action.RestToXContentListener;

public class RestGetIndexTemplateAction
extends BaseRestHandler {
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(RestGetIndexTemplateAction.class);

    public List<RestHandler.Route> routes() {
        return Collections.unmodifiableList(Arrays.asList(new RestHandler.Route(RestRequest.Method.GET, "/_template"), new RestHandler.Route(RestRequest.Method.GET, "/_template/{name}"), new RestHandler.Route(RestRequest.Method.HEAD, "/_template/{name}")));
    }

    @Override
    public String getName() {
        return "get_index_template_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        String[] names = Strings.splitStringByCommaToArray((String)request.param("name"));
        GetIndexTemplatesRequest getIndexTemplatesRequest = new GetIndexTemplatesRequest(names);
        getIndexTemplatesRequest.local(request.paramAsBoolean("local", getIndexTemplatesRequest.local()));
        getIndexTemplatesRequest.clusterManagerNodeTimeout(request.paramAsTime("cluster_manager_timeout", getIndexTemplatesRequest.clusterManagerNodeTimeout()));
        RestGetIndexTemplateAction.parseDeprecatedMasterTimeoutParameter((ClusterManagerNodeRequest)getIndexTemplatesRequest, request, deprecationLogger, this.getName());
        final boolean implicitAll = getIndexTemplatesRequest.names().length == 0;
        return channel -> client.admin().indices().getTemplates(getIndexTemplatesRequest, (ActionListener)new RestToXContentListener<GetIndexTemplatesResponse>(this, channel){

            @Override
            protected RestStatus getStatus(GetIndexTemplatesResponse response) {
                boolean templateExists = !response.getIndexTemplates().isEmpty();
                return templateExists || implicitAll ? RestStatus.OK : RestStatus.NOT_FOUND;
            }
        });
    }

    @Override
    protected Set<String> responseParams() {
        return Settings.FORMAT_PARAMS;
    }
}

