/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.rest.action.admin.indices;

import io.skylite.core.action.admin.indices.get.GetIndexRequest;
import io.skylite.core.action.clustermanager.ClusterManagerNodeRequest;
import io.skylite.core.action.support.IndicesOptions;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.common.Strings;
import io.skylite.core.common.logging.DeprecationLogger;
import io.skylite.core.rest.RestChannel;
import io.skylite.core.rest.RestHandler;
import io.skylite.core.rest.RestRequest;
import io.skylite.core.settings.Settings;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.action.RestToXContentListener;

public class RestGetIndicesAction
extends BaseRestHandler {
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(RestGetIndicesAction.class);

    public List<RestHandler.Route> routes() {
        return Collections.unmodifiableList(Arrays.asList(new RestHandler.Route(RestRequest.Method.GET, "/{index}"), new RestHandler.Route(RestRequest.Method.HEAD, "/{index}")));
    }

    @Override
    public String getName() {
        return "get_indices_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        String[] indices = Strings.splitStringByCommaToArray((String)request.param("index"));
        GetIndexRequest getIndexRequest = new GetIndexRequest();
        getIndexRequest.indices(indices);
        getIndexRequest.indicesOptions(IndicesOptions.fromRequest((RestRequest)request, (IndicesOptions)getIndexRequest.indicesOptions()));
        getIndexRequest.local(request.paramAsBoolean("local", getIndexRequest.local()));
        getIndexRequest.clusterManagerNodeTimeout(request.paramAsTime("cluster_manager_timeout", getIndexRequest.clusterManagerNodeTimeout()));
        RestGetIndicesAction.parseDeprecatedMasterTimeoutParameter((ClusterManagerNodeRequest)getIndexRequest, request, deprecationLogger, this.getName());
        getIndexRequest.humanReadable(request.paramAsBoolean("human", false));
        getIndexRequest.includeDefaults(request.paramAsBoolean("include_defaults", false));
        return channel -> client.admin().indices().getIndex(getIndexRequest, new RestToXContentListener((RestChannel)channel));
    }

    @Override
    protected Set<String> responseParams() {
        return Settings.FORMAT_PARAMS;
    }
}

