/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.rest.action.admin.indices;

import io.skylite.common.action.ActionRequestValidationException;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionType;
import io.skylite.core.action.admin.indices.open.OpenIndexAction;
import io.skylite.core.action.admin.indices.open.OpenIndexRequest;
import io.skylite.core.action.clustermanager.AcknowledgedRequest;
import io.skylite.core.action.clustermanager.ClusterManagerNodeRequest;
import io.skylite.core.action.support.ActiveShardCount;
import io.skylite.core.action.support.IndicesOptions;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.common.Strings;
import io.skylite.core.common.logging.DeprecationLogger;
import io.skylite.core.rest.RestChannel;
import io.skylite.core.rest.RestHandler;
import io.skylite.core.rest.RestRequest;
import io.skylite.core.tasks.LoggingTaskListener;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.action.RestToXContentListener;

public class RestOpenIndexAction
extends BaseRestHandler {
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(RestOpenIndexAction.class);

    public List<RestHandler.Route> routes() {
        return Collections.unmodifiableList(Arrays.asList(new RestHandler.Route(RestRequest.Method.POST, "/_open"), new RestHandler.Route(RestRequest.Method.POST, "/{index}/_open")));
    }

    @Override
    public String getName() {
        return "open_index_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        OpenIndexRequest openIndexRequest = new OpenIndexRequest(Strings.splitStringByCommaToArray((String)request.param("index")));
        openIndexRequest.timeout(request.paramAsTime("timeout", openIndexRequest.timeout()));
        openIndexRequest.clusterManagerNodeTimeout(request.paramAsTime("cluster_manager_timeout", openIndexRequest.clusterManagerNodeTimeout()));
        RestOpenIndexAction.parseDeprecatedMasterTimeoutParameter((ClusterManagerNodeRequest)openIndexRequest, request, deprecationLogger, this.getName());
        openIndexRequest.indicesOptions(IndicesOptions.fromRequest((RestRequest)request, (IndicesOptions)openIndexRequest.indicesOptions()));
        String waitForActiveShards = request.param("wait_for_active_shards");
        if (waitForActiveShards != null) {
            openIndexRequest.waitForActiveShards(ActiveShardCount.parseString((String)waitForActiveShards));
        }
        if (request.paramAsBoolean("wait_for_completion", true)) {
            return channel -> client.admin().indices().open(openIndexRequest, new RestToXContentListener((RestChannel)channel));
        }
        openIndexRequest.setShouldStoreResult(true);
        openIndexRequest.timeout(request.paramAsTime("task_execution_timeout", AcknowledgedRequest.DEFAULT_TASK_EXECUTION_TIMEOUT));
        ActionRequestValidationException validationException = openIndexRequest.validate();
        if (validationException != null) {
            throw validationException;
        }
        return this.sendTask(client.getLocalNodeId(), client.executeLocally((ActionType)OpenIndexAction.INSTANCE, (ActionRequest)openIndexRequest, LoggingTaskListener.instance()));
    }
}

