/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.rest.action.admin.indices;

import io.skylite.core.action.admin.indices.mapping.put.PutMappingRequest;
import io.skylite.core.action.clustermanager.ClusterManagerNodeRequest;
import io.skylite.core.action.support.IndicesOptions;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.common.Strings;
import io.skylite.core.common.bytes.BytesReference;
import io.skylite.core.common.logging.DeprecationLogger;
import io.skylite.core.mapper.MapperService;
import io.skylite.core.rest.RestChannel;
import io.skylite.core.rest.RestHandler;
import io.skylite.core.rest.RestRequest;
import io.skylite.core.xcontent.MediaType;
import io.skylite.core.xcontent.XContentHelper;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.action.RestToXContentListener;

public class RestPutMappingAction
extends BaseRestHandler {
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(RestPutMappingAction.class);

    public List<RestHandler.Route> routes() {
        return Collections.unmodifiableList(Arrays.asList(new RestHandler.Route(RestRequest.Method.POST, "/{index}/_mapping/"), new RestHandler.Route(RestRequest.Method.PUT, "/{index}/_mapping/"), new RestHandler.Route(RestRequest.Method.POST, "/{index}/_mappings/"), new RestHandler.Route(RestRequest.Method.PUT, "/{index}/_mappings/")));
    }

    @Override
    public String getName() {
        return "put_mapping_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        PutMappingRequest putMappingRequest = new PutMappingRequest(Strings.splitStringByCommaToArray((String)request.param("index")));
        Map sourceAsMap = (Map)XContentHelper.convertToMap((BytesReference)request.requiredContent(), (boolean)false, (MediaType)request.getMediaType()).v2();
        if (MapperService.isMappingSourceTyped((String)"_doc", (Map)sourceAsMap)) {
            throw new IllegalArgumentException("Types cannot be provided in put mapping requests");
        }
        putMappingRequest.source(sourceAsMap);
        putMappingRequest.timeout(request.paramAsTime("timeout", putMappingRequest.timeout()));
        putMappingRequest.clusterManagerNodeTimeout(request.paramAsTime("cluster_manager_timeout", putMappingRequest.clusterManagerNodeTimeout()));
        RestPutMappingAction.parseDeprecatedMasterTimeoutParameter((ClusterManagerNodeRequest)putMappingRequest, request, deprecationLogger, this.getName());
        putMappingRequest.indicesOptions(IndicesOptions.fromRequest((RestRequest)request, (IndicesOptions)putMappingRequest.indicesOptions()));
        putMappingRequest.writeIndexOnly(request.paramAsBoolean("write_index_only", false));
        return channel -> client.admin().indices().putMapping(putMappingRequest, new RestToXContentListener((RestChannel)channel));
    }
}

