/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.rest.action.admin.indices;

import io.skylite.core.action.admin.indices.rollover.RolloverRequest;
import io.skylite.core.action.clustermanager.ClusterManagerNodeRequest;
import io.skylite.core.action.support.ActiveShardCount;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.common.logging.DeprecationLogger;
import io.skylite.core.rest.RestChannel;
import io.skylite.core.rest.RestHandler;
import io.skylite.core.rest.RestRequest;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.action.RestToXContentListener;

public class RestRolloverIndexAction
extends BaseRestHandler {
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(RestRolloverIndexAction.class);
    public static final String TYPES_DEPRECATION_MESSAGE = "[types removal] Using include_type_name in rollover index requests is deprecated. The parameter will be removed in the next major version.";

    public List<RestHandler.Route> routes() {
        return Collections.unmodifiableList(Arrays.asList(new RestHandler.Route(RestRequest.Method.POST, "/{index}/_rollover"), new RestHandler.Route(RestRequest.Method.POST, "/{index}/_rollover/{new_index}")));
    }

    @Override
    public String getName() {
        return "rollover_index_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        if (request.hasParam("include_type_name")) {
            deprecationLogger.deprecate("index_rollover_with_types", TYPES_DEPRECATION_MESSAGE, new Object[0]);
        }
        RolloverRequest rolloverIndexRequest = new RolloverRequest(request.param("index"), request.param("new_index"));
        request.applyContentParser(parser -> rolloverIndexRequest.fromXContent(parser));
        rolloverIndexRequest.dryRun(request.paramAsBoolean("dry_run", false));
        rolloverIndexRequest.timeout(request.paramAsTime("timeout", rolloverIndexRequest.timeout()));
        rolloverIndexRequest.clusterManagerNodeTimeout(request.paramAsTime("cluster_manager_timeout", rolloverIndexRequest.clusterManagerNodeTimeout()));
        RestRolloverIndexAction.parseDeprecatedMasterTimeoutParameter((ClusterManagerNodeRequest)rolloverIndexRequest, request, deprecationLogger, this.getName());
        rolloverIndexRequest.getCreateIndexRequest().waitForActiveShards(ActiveShardCount.parseString((String)request.param("wait_for_active_shards")));
        return channel -> client.admin().indices().rolloverIndex(rolloverIndexRequest, new RestToXContentListener((RestChannel)channel));
    }
}

