/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.rest.action.cat;

import io.skylite.common.action.ActionListener;
import io.skylite.core.action.admin.indices.alias.get.GetAliasesRequest;
import io.skylite.core.action.admin.indices.alias.get.GetAliasesResponse;
import io.skylite.core.action.support.IndicesOptions;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.cluster.metadata.AliasMetadata;
import io.skylite.core.common.Strings;
import io.skylite.core.common.Table;
import io.skylite.core.rest.RestHandler;
import io.skylite.core.rest.RestRequest;
import io.skylite.core.rest.RestResponse;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.action.RestResponseListener;
import org.opensearch.rest.action.cat.AbstractCatAction;
import org.opensearch.rest.action.cat.RestTable;

public class RestAliasAction
extends AbstractCatAction {
    public List<RestHandler.Route> routes() {
        return Collections.unmodifiableList(Arrays.asList(new RestHandler.Route(RestRequest.Method.GET, "/_cat/aliases"), new RestHandler.Route(RestRequest.Method.GET, "/_cat/aliases/{alias}")));
    }

    @Override
    public String getName() {
        return "cat_alias_action";
    }

    public boolean allowSystemIndexAccessByDefault() {
        return true;
    }

    @Override
    protected BaseRestHandler.RestChannelConsumer doCatRequest(final RestRequest request, NodeClient client) {
        GetAliasesRequest getAliasesRequest = request.hasParam("alias") ? new GetAliasesRequest(Strings.commaDelimitedListToStringArray((String)request.param("alias"))) : new GetAliasesRequest();
        getAliasesRequest.indicesOptions(IndicesOptions.fromRequest((RestRequest)request, (IndicesOptions)getAliasesRequest.indicesOptions()));
        getAliasesRequest.local(request.paramAsBoolean("local", getAliasesRequest.local()));
        return channel -> client.admin().indices().getAliases(getAliasesRequest, (ActionListener)new RestResponseListener<GetAliasesResponse>(channel){

            @Override
            public RestResponse buildResponse(GetAliasesResponse response) throws Exception {
                Table tab = RestAliasAction.this.buildTable(request, response);
                return RestTable.buildResponse(tab, this.channel);
            }
        });
    }

    @Override
    protected void documentation(StringBuilder sb) {
        sb.append("/_cat/aliases\n");
        sb.append("/_cat/aliases/{alias}\n");
    }

    @Override
    protected Table getTableWithHeader(RestRequest request) {
        Table table = new Table();
        table.startHeaders();
        table.addCell((Object)"alias", "alias:a;desc:alias name");
        table.addCell((Object)"index", "alias:i,idx;desc:index alias points to");
        table.addCell((Object)"filter", "alias:f,fi;desc:filter");
        table.addCell((Object)"routing.index", "alias:ri,routingIndex;desc:index routing");
        table.addCell((Object)"routing.search", "alias:rs,routingSearch;desc:search routing");
        table.addCell((Object)"is_write_index", "alias:w,isWriteIndex;desc:write index");
        table.endHeaders();
        return table;
    }

    private Table buildTable(RestRequest request, GetAliasesResponse response) {
        Table table = this.getTableWithHeader(request);
        for (Map.Entry cursor : response.getAliases().entrySet()) {
            String indexName = (String)cursor.getKey();
            for (AliasMetadata aliasMetadata : (List)cursor.getValue()) {
                table.startRow();
                table.addCell((Object)aliasMetadata.alias());
                table.addCell((Object)indexName);
                table.addCell((Object)(aliasMetadata.filteringRequired() ? "*" : "-"));
                String indexRouting = Strings.hasLength((String)aliasMetadata.indexRouting()) ? aliasMetadata.indexRouting() : "-";
                table.addCell((Object)indexRouting);
                String searchRouting = Strings.hasLength((String)aliasMetadata.searchRouting()) ? aliasMetadata.searchRouting() : "-";
                table.addCell((Object)searchRouting);
                String isWriteIndex = aliasMetadata.writeIndex() == null ? "-" : aliasMetadata.writeIndex().toString();
                table.addCell((Object)isWriteIndex);
                table.endRow();
            }
        }
        return table;
    }
}

