/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.rest.action.cat;

import io.skylite.common.action.ActionListener;
import io.skylite.core.action.admin.cluster.node.stats.NodeStats;
import io.skylite.core.action.admin.cluster.node.stats.NodesStatsRequest;
import io.skylite.core.action.admin.cluster.node.stats.NodesStatsResponse;
import io.skylite.core.action.admin.indices.stats.CommonStatsFlags;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.common.Table;
import io.skylite.core.common.unit.ByteSizeValue;
import io.skylite.core.rest.RestHandler;
import io.skylite.core.rest.RestRequest;
import io.skylite.core.rest.RestResponse;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.action.RestResponseListener;
import org.opensearch.rest.action.cat.AbstractCatAction;
import org.opensearch.rest.action.cat.RestTable;

public class RestFielddataAction
extends AbstractCatAction {
    public List<RestHandler.Route> routes() {
        return Collections.unmodifiableList(Arrays.asList(new RestHandler.Route(RestRequest.Method.GET, "/_cat/fielddata"), new RestHandler.Route(RestRequest.Method.GET, "/_cat/fielddata/{fields}")));
    }

    @Override
    public String getName() {
        return "cat_fielddata_action";
    }

    @Override
    protected BaseRestHandler.RestChannelConsumer doCatRequest(final RestRequest request, NodeClient client) {
        String[] stringArray;
        NodesStatsRequest nodesStatsRequest = new NodesStatsRequest(new String[]{"data:true"});
        nodesStatsRequest.clear();
        nodesStatsRequest.indices(true);
        String[] fields = request.paramAsStringArray("fields", null);
        CommonStatsFlags commonStatsFlags = nodesStatsRequest.indices();
        if (fields == null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "*";
        } else {
            stringArray = fields;
        }
        commonStatsFlags.fieldDataFields(stringArray);
        return channel -> client.admin().cluster().nodesStats(nodesStatsRequest, (ActionListener)new RestResponseListener<NodesStatsResponse>(channel){

            @Override
            public RestResponse buildResponse(NodesStatsResponse nodeStatses) throws Exception {
                return RestTable.buildResponse(RestFielddataAction.this.buildTable(request, nodeStatses), this.channel);
            }
        });
    }

    @Override
    protected void documentation(StringBuilder sb) {
        sb.append("/_cat/fielddata\n");
        sb.append("/_cat/fielddata/{fields}\n");
    }

    @Override
    protected Table getTableWithHeader(RestRequest request) {
        Table table = new Table();
        table.startHeaders().addCell((Object)"id", "desc:node id").addCell((Object)"host", "alias:h;desc:host name").addCell((Object)"ip", "desc:ip address").addCell((Object)"node", "alias:n;desc:node name").addCell((Object)"field", "alias:f;desc:field name").addCell((Object)"size", "text-align:right;alias:s;desc:field data usage").endHeaders();
        return table;
    }

    private Table buildTable(RestRequest request, NodesStatsResponse nodeStatses) {
        Table table = this.getTableWithHeader(request);
        for (NodeStats nodeStats : nodeStatses.getNodes()) {
            if (nodeStats.getIndices().getFieldData().getFields() == null) continue;
            for (Map.Entry cursor : nodeStats.getIndices().getFieldData().getFields()) {
                table.startRow();
                table.addCell((Object)nodeStats.getNode().getId());
                table.addCell((Object)nodeStats.getNode().getHostName());
                table.addCell((Object)nodeStats.getNode().getHostAddress());
                table.addCell((Object)nodeStats.getNode().getName());
                table.addCell(cursor.getKey());
                table.addCell((Object)new ByteSizeValue(((Long)cursor.getValue()).longValue()));
                table.endRow();
            }
        }
        return table;
    }
}

