/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.rest.action.cat;

import io.skylite.common.action.ActionListener;
import io.skylite.core.action.admin.cluster.node.info.NodeInfo;
import io.skylite.core.action.admin.cluster.node.info.NodesInfoRequest;
import io.skylite.core.action.admin.cluster.node.info.NodesInfoResponse;
import io.skylite.core.action.admin.cluster.state.ClusterStateRequest;
import io.skylite.core.action.admin.cluster.state.ClusterStateResponse;
import io.skylite.core.action.clustermanager.ClusterManagerNodeRequest;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.cluster.node.DiscoveryNode;
import io.skylite.core.cluster.node.DiscoveryNodes;
import io.skylite.core.common.Strings;
import io.skylite.core.common.Table;
import io.skylite.core.common.logging.DeprecationLogger;
import io.skylite.core.monitor.process.ProcessInfo;
import io.skylite.core.rest.RestHandler;
import io.skylite.core.rest.RestRequest;
import io.skylite.core.rest.RestResponse;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.action.RestActionListener;
import org.opensearch.rest.action.RestResponseListener;
import org.opensearch.rest.action.cat.AbstractCatAction;
import org.opensearch.rest.action.cat.RestTable;

public class RestNodeAttrsAction
extends AbstractCatAction {
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(RestNodeAttrsAction.class);

    public List<RestHandler.Route> routes() {
        return Collections.singletonList(new RestHandler.Route(RestRequest.Method.GET, "/_cat/nodeattrs"));
    }

    @Override
    public String getName() {
        return "cat_node_attrs_action";
    }

    @Override
    protected void documentation(StringBuilder sb) {
        sb.append("/_cat/nodeattrs\n");
    }

    @Override
    public BaseRestHandler.RestChannelConsumer doCatRequest(final RestRequest request, final NodeClient client) {
        ClusterStateRequest clusterStateRequest = new ClusterStateRequest();
        clusterStateRequest.clear().nodes(true);
        clusterStateRequest.local(request.paramAsBoolean("local", clusterStateRequest.local()));
        clusterStateRequest.clusterManagerNodeTimeout(request.paramAsTime("cluster_manager_timeout", clusterStateRequest.clusterManagerNodeTimeout()));
        RestNodeAttrsAction.parseDeprecatedMasterTimeoutParameter((ClusterManagerNodeRequest)clusterStateRequest, request, deprecationLogger, this.getName());
        return channel -> client.admin().cluster().state(clusterStateRequest, (ActionListener)new RestActionListener<ClusterStateResponse>(channel){

            @Override
            public void processResponse(final ClusterStateResponse clusterStateResponse) {
                NodesInfoRequest nodesInfoRequest = new NodesInfoRequest(new String[0]);
                nodesInfoRequest.timeout(request.param("timeout"));
                nodesInfoRequest.clear().addMetric(NodesInfoRequest.Metric.PROCESS.metricName());
                client.admin().cluster().nodesInfo(nodesInfoRequest, (ActionListener)new RestResponseListener<NodesInfoResponse>(this.channel){

                    @Override
                    public RestResponse buildResponse(NodesInfoResponse nodesInfoResponse) throws Exception {
                        return RestTable.buildResponse(RestNodeAttrsAction.this.buildTable(request, clusterStateResponse, nodesInfoResponse), this.channel);
                    }
                });
            }
        });
    }

    @Override
    protected Table getTableWithHeader(RestRequest request) {
        Table table = new Table();
        table.startHeaders();
        table.addCell((Object)"node", "default:true;alias:name;desc:node name");
        table.addCell((Object)"id", "default:false;alias:id,nodeId;desc:unique node id");
        table.addCell((Object)"pid", "default:false;alias:p;desc:process id");
        table.addCell((Object)"host", "alias:h;desc:host name");
        table.addCell((Object)"ip", "alias:i;desc:ip address");
        table.addCell((Object)"port", "default:false;alias:po;desc:bound transport port");
        table.addCell((Object)"attr", "default:true;alias:attr.name;desc:attribute description");
        table.addCell((Object)"value", "default:true;alias:attr.value;desc:attribute value");
        table.endHeaders();
        return table;
    }

    private Table buildTable(RestRequest req, ClusterStateResponse state, NodesInfoResponse nodesInfo) {
        boolean fullId = req.paramAsBoolean("full_id", false);
        DiscoveryNodes nodes = state.getState().nodes();
        Table table = this.getTableWithHeader(req);
        for (DiscoveryNode node : nodes) {
            NodeInfo info = (NodeInfo)nodesInfo.getNodesMap().get(node.getId());
            for (Map.Entry attrEntry : node.getAttributes().entrySet()) {
                table.startRow();
                table.addCell((Object)node.getName());
                table.addCell((Object)(fullId ? node.getId() : Strings.substring((String)node.getId(), (int)0, (int)4)));
                table.addCell(info == null ? null : Long.valueOf(((ProcessInfo)info.getInfo(ProcessInfo.class)).getId()));
                table.addCell((Object)node.getHostName());
                table.addCell((Object)node.getHostAddress());
                table.addCell((Object)node.getAddress().address().getPort());
                table.addCell(attrEntry.getKey());
                table.addCell(attrEntry.getValue());
                table.endRow();
            }
        }
        return table;
    }
}

