/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.rest.action.cat;

import io.skylite.common.action.ActionListener;
import io.skylite.common.network.NetworkAddress;
import io.skylite.core.FeatureFlags;
import io.skylite.core.action.admin.cluster.node.info.NodeInfo;
import io.skylite.core.action.admin.cluster.node.info.NodesInfoRequest;
import io.skylite.core.action.admin.cluster.node.info.NodesInfoResponse;
import io.skylite.core.action.admin.cluster.node.stats.NodeStats;
import io.skylite.core.action.admin.cluster.node.stats.NodesStatsRequest;
import io.skylite.core.action.admin.cluster.node.stats.NodesStatsResponse;
import io.skylite.core.action.admin.cluster.state.ClusterStateRequest;
import io.skylite.core.action.admin.cluster.state.ClusterStateResponse;
import io.skylite.core.action.admin.indices.refresh.RefreshStats;
import io.skylite.core.action.clustermanager.ClusterManagerNodeRequest;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.cluster.node.DiscoveryNode;
import io.skylite.core.cluster.node.DiscoveryNodes;
import io.skylite.core.cluster.node.NodeRole;
import io.skylite.core.common.Strings;
import io.skylite.core.common.Table;
import io.skylite.core.common.logging.DeprecationLogger;
import io.skylite.core.common.transport.TransportAddress;
import io.skylite.core.common.unit.ByteSizeValue;
import io.skylite.core.http.HttpInfo;
import io.skylite.core.index.cache.query.QueryCacheStats;
import io.skylite.core.index.cache.request.RequestCacheStats;
import io.skylite.core.index.engine.SegmentsStats;
import io.skylite.core.index.fielddata.FieldDataStats;
import io.skylite.core.index.flush.FlushStats;
import io.skylite.core.index.get.GetStats;
import io.skylite.core.index.merge.MergeStats;
import io.skylite.core.index.shard.IndexingStats;
import io.skylite.core.indices.NodeIndicesStats;
import io.skylite.core.monitor.FsInfo;
import io.skylite.core.monitor.JvmInfo;
import io.skylite.core.monitor.jvm.JvmStats;
import io.skylite.core.monitor.os.OsStats;
import io.skylite.core.monitor.process.ProcessInfo;
import io.skylite.core.monitor.process.ProcessStats;
import io.skylite.core.rest.RestHandler;
import io.skylite.core.rest.RestRequest;
import io.skylite.core.rest.RestResponse;
import io.skylite.core.script.ScriptStats;
import io.skylite.core.search.stats.SearchStats;
import io.skylite.core.search.suggest.completion.CompletionStats;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.action.RestActionListener;
import org.opensearch.rest.action.RestResponseListener;
import org.opensearch.rest.action.cat.AbstractCatAction;
import org.opensearch.rest.action.cat.RestTable;

public class RestNodesAction
extends AbstractCatAction {
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(RestNodesAction.class);
    static final String LOCAL_DEPRECATED_MESSAGE = "Deprecated parameter [local] used. This parameter does not cause this API to act locally, and should not be used. It will be unsupported in version 8.0.";

    public List<RestHandler.Route> routes() {
        return Collections.singletonList(new RestHandler.Route(RestRequest.Method.GET, "/_cat/nodes"));
    }

    @Override
    public String getName() {
        return "cat_nodes_action";
    }

    @Override
    protected void documentation(StringBuilder sb) {
        sb.append("/_cat/nodes\n");
    }

    @Override
    public BaseRestHandler.RestChannelConsumer doCatRequest(final RestRequest request, final NodeClient client) {
        ClusterStateRequest clusterStateRequest = new ClusterStateRequest();
        clusterStateRequest.clear().nodes(true);
        if (request.hasParam("local")) {
            deprecationLogger.deprecate("cat_nodes_local_parameter", LOCAL_DEPRECATED_MESSAGE, new Object[0]);
        }
        clusterStateRequest.local(request.paramAsBoolean("local", clusterStateRequest.local()));
        clusterStateRequest.clusterManagerNodeTimeout(request.paramAsTime("cluster_manager_timeout", clusterStateRequest.clusterManagerNodeTimeout()));
        RestNodesAction.parseDeprecatedMasterTimeoutParameter((ClusterManagerNodeRequest)clusterStateRequest, request, deprecationLogger, this.getName());
        final boolean fullId = request.paramAsBoolean("full_id", false);
        return channel -> client.admin().cluster().state(clusterStateRequest, (ActionListener)new RestActionListener<ClusterStateResponse>(channel){

            @Override
            public void processResponse(final ClusterStateResponse clusterStateResponse) {
                NodesInfoRequest nodesInfoRequest = new NodesInfoRequest(new String[0]);
                nodesInfoRequest.timeout(request.param("timeout"));
                nodesInfoRequest.clear().addMetrics(new String[]{NodesInfoRequest.Metric.JVM.metricName(), NodesInfoRequest.Metric.OS.metricName(), NodesInfoRequest.Metric.PROCESS.metricName(), NodesInfoRequest.Metric.HTTP.metricName()});
                client.admin().cluster().nodesInfo(nodesInfoRequest, (ActionListener)new RestActionListener<NodesInfoResponse>(this.channel){

                    @Override
                    public void processResponse(final NodesInfoResponse nodesInfoResponse) {
                        NodesStatsRequest nodesStatsRequest = new NodesStatsRequest();
                        nodesStatsRequest.timeout(request.param("timeout"));
                        nodesStatsRequest.clear().indices(true).addMetrics(new String[]{NodesStatsRequest.Metric.JVM.metricName(), NodesStatsRequest.Metric.OS.metricName(), NodesStatsRequest.Metric.FS.metricName(), NodesStatsRequest.Metric.PROCESS.metricName(), NodesStatsRequest.Metric.SCRIPT.metricName()});
                        client.admin().cluster().nodesStats(nodesStatsRequest, (ActionListener)new RestResponseListener<NodesStatsResponse>(this.channel){

                            @Override
                            public RestResponse buildResponse(NodesStatsResponse nodesStatsResponse) throws Exception {
                                return RestTable.buildResponse(RestNodesAction.this.buildTable(fullId, request, clusterStateResponse, nodesInfoResponse, nodesStatsResponse), this.channel);
                            }
                        });
                    }
                });
            }
        });
    }

    @Override
    protected Table getTableWithHeader(RestRequest request) {
        Table table = new Table();
        table.startHeaders();
        table.addCell((Object)"id", "default:false;alias:id,nodeId;desc:unique node id");
        table.addCell((Object)"pid", "default:false;alias:p;desc:process id");
        table.addCell((Object)"ip", "alias:i;desc:ip address");
        table.addCell((Object)"port", "default:false;alias:po;desc:bound transport port");
        table.addCell((Object)"http_address", "default:false;alias:http;desc:bound http address");
        table.addCell((Object)"version", "default:false;alias:v;desc:es version");
        table.addCell((Object)"type", "default:false;alias:t;desc:es distribution type");
        table.addCell((Object)"build", "default:false;alias:b;desc:es build hash");
        table.addCell((Object)"jdk", "default:false;alias:j;desc:jdk version");
        table.addCell((Object)"disk.total", "default:false;alias:dt,diskTotal;text-align:right;desc:total disk space");
        table.addCell((Object)"disk.used", "default:false;alias:du,diskUsed;text-align:right;desc:used disk space");
        table.addCell((Object)"disk.avail", "default:false;alias:d,da,disk,diskAvail;text-align:right;desc:available disk space");
        table.addCell((Object)"disk.used_percent", "default:false;alias:dup,diskUsedPercent;text-align:right;desc:used disk space percentage");
        table.addCell((Object)"heap.current", "default:false;alias:hc,heapCurrent;text-align:right;desc:used heap");
        table.addCell((Object)"heap.percent", "alias:hp,heapPercent;text-align:right;desc:used heap ratio");
        table.addCell((Object)"heap.max", "default:false;alias:hm,heapMax;text-align:right;desc:max configured heap");
        table.addCell((Object)"ram.current", "default:false;alias:rc,ramCurrent;text-align:right;desc:used machine memory");
        table.addCell((Object)"ram.percent", "alias:rp,ramPercent;text-align:right;desc:used machine memory ratio");
        table.addCell((Object)"ram.max", "default:false;alias:rm,ramMax;text-align:right;desc:total machine memory");
        table.addCell((Object)"file_desc.current", "default:false;alias:fdc,fileDescriptorCurrent;text-align:right;desc:used file descriptors");
        table.addCell((Object)"file_desc.percent", "default:false;alias:fdp,fileDescriptorPercent;text-align:right;desc:used file descriptor ratio");
        table.addCell((Object)"file_desc.max", "default:false;alias:fdm,fileDescriptorMax;text-align:right;desc:max file descriptors");
        table.addCell((Object)"cpu", "alias:cpu;text-align:right;desc:recent cpu usage");
        table.addCell((Object)"load_1m", "alias:l;text-align:right;desc:1m load avg");
        table.addCell((Object)"load_5m", "alias:l;text-align:right;desc:5m load avg");
        table.addCell((Object)"load_15m", "alias:l;text-align:right;desc:15m load avg");
        table.addCell((Object)"uptime", "default:false;alias:u;text-align:right;desc:node uptime");
        table.addCell((Object)"node.role", "alias:r,role,nodeRole;desc:m:master eligible node, d:data node, i:ingest node, -:coordinating node only");
        table.addCell((Object)"node.roles", "alias:rs,all roles;desc: -:coordinating node only");
        table.addCell((Object)"cluster_manager", "alias:cm,m,master;desc:*:current cluster manager");
        table.addCell((Object)"name", "alias:n;desc:node name");
        table.addCell((Object)"completion.size", "alias:cs,completionSize;default:false;text-align:right;desc:size of completion");
        table.addCell((Object)"fielddata.memory_size", "alias:fm,fielddataMemory;default:false;text-align:right;desc:used fielddata cache");
        table.addCell((Object)"fielddata.evictions", "alias:fe,fielddataEvictions;default:false;text-align:right;desc:fielddata evictions");
        table.addCell((Object)"query_cache.memory_size", "alias:qcm,queryCacheMemory;default:false;text-align:right;desc:used query cache");
        table.addCell((Object)"query_cache.evictions", "alias:qce,queryCacheEvictions;default:false;text-align:right;desc:query cache evictions");
        table.addCell((Object)"query_cache.hit_count", "alias:qchc,queryCacheHitCount;default:false;text-align:right;desc:query cache hit counts");
        table.addCell((Object)"query_cache.miss_count", "alias:qcmc,queryCacheMissCount;default:false;text-align:right;desc:query cache miss counts");
        table.addCell((Object)"request_cache.memory_size", "alias:rcm,requestCacheMemory;default:false;text-align:right;desc:used request cache");
        table.addCell((Object)"request_cache.evictions", "alias:rce,requestCacheEvictions;default:false;text-align:right;desc:request cache evictions");
        table.addCell((Object)"request_cache.hit_count", "alias:rchc,requestCacheHitCount;default:false;text-align:right;desc:request cache hit counts");
        table.addCell((Object)"request_cache.miss_count", "alias:rcmc,requestCacheMissCount;default:false;text-align:right;desc:request cache miss counts");
        table.addCell((Object)"flush.total", "alias:ft,flushTotal;default:false;text-align:right;desc:number of flushes");
        table.addCell((Object)"flush.total_time", "alias:ftt,flushTotalTime;default:false;text-align:right;desc:time spent in flush");
        table.addCell((Object)"get.current", "alias:gc,getCurrent;default:false;text-align:right;desc:number of current get ops");
        table.addCell((Object)"get.time", "alias:gti,getTime;default:false;text-align:right;desc:time spent in get");
        table.addCell((Object)"get.total", "alias:gto,getTotal;default:false;text-align:right;desc:number of get ops");
        table.addCell((Object)"get.exists_time", "alias:geti,getExistsTime;default:false;text-align:right;desc:time spent in successful gets");
        table.addCell((Object)"get.exists_total", "alias:geto,getExistsTotal;default:false;text-align:right;desc:number of successful gets");
        table.addCell((Object)"get.missing_time", "alias:gmti,getMissingTime;default:false;text-align:right;desc:time spent in failed gets");
        table.addCell((Object)"get.missing_total", "alias:gmto,getMissingTotal;default:false;text-align:right;desc:number of failed gets");
        table.addCell((Object)"indexing.delete_current", "alias:idc,indexingDeleteCurrent;default:false;text-align:right;desc:number of current deletions");
        table.addCell((Object)"indexing.delete_time", "alias:idti,indexingDeleteTime;default:false;text-align:right;desc:time spent in deletions");
        table.addCell((Object)"indexing.delete_total", "alias:idto,indexingDeleteTotal;default:false;text-align:right;desc:number of delete ops");
        table.addCell((Object)"indexing.index_current", "alias:iic,indexingIndexCurrent;default:false;text-align:right;desc:number of current indexing ops");
        table.addCell((Object)"indexing.index_time", "alias:iiti,indexingIndexTime;default:false;text-align:right;desc:time spent in indexing");
        table.addCell((Object)"indexing.index_total", "alias:iito,indexingIndexTotal;default:false;text-align:right;desc:number of indexing ops");
        table.addCell((Object)"indexing.index_failed", "alias:iif,indexingIndexFailed;default:false;text-align:right;desc:number of failed indexing ops");
        table.addCell((Object)"merges.current", "alias:mc,mergesCurrent;default:false;text-align:right;desc:number of current merges");
        table.addCell((Object)"merges.current_docs", "alias:mcd,mergesCurrentDocs;default:false;text-align:right;desc:number of current merging docs");
        table.addCell((Object)"merges.current_size", "alias:mcs,mergesCurrentSize;default:false;text-align:right;desc:size of current merges");
        table.addCell((Object)"merges.total", "alias:mt,mergesTotal;default:false;text-align:right;desc:number of completed merge ops");
        table.addCell((Object)"merges.total_docs", "alias:mtd,mergesTotalDocs;default:false;text-align:right;desc:docs merged");
        table.addCell((Object)"merges.total_size", "alias:mts,mergesTotalSize;default:false;text-align:right;desc:size merged");
        table.addCell((Object)"merges.total_time", "alias:mtt,mergesTotalTime;default:false;text-align:right;desc:time spent in merges");
        table.addCell((Object)"refresh.total", "alias:rto,refreshTotal;default:false;text-align:right;desc:total refreshes");
        table.addCell((Object)"refresh.time", "alias:rti,refreshTime;default:false;text-align:right;desc:time spent in refreshes");
        table.addCell((Object)"refresh.external_total", "alias:rto,refreshTotal;default:false;text-align:right;desc:total external refreshes");
        table.addCell((Object)"refresh.external_time", "alias:rti,refreshTime;default:false;text-align:right;desc:time spent in external refreshes");
        table.addCell((Object)"refresh.listeners", "alias:rli,refreshListeners;default:false;text-align:right;desc:number of pending refresh listeners");
        table.addCell((Object)"script.compilations", "alias:scrcc,scriptCompilations;default:false;text-align:right;desc:script compilations");
        table.addCell((Object)"script.cache_evictions", "alias:scrce,scriptCacheEvictions;default:false;text-align:right;desc:script cache evictions");
        table.addCell((Object)"script.compilation_limit_triggered", "alias:scrclt,scriptCacheCompilationLimitTriggered;default:false;text-align:right;desc:script cache compilation limit triggered");
        table.addCell((Object)"search.fetch_current", "alias:sfc,searchFetchCurrent;default:false;text-align:right;desc:current fetch phase ops");
        table.addCell((Object)"search.fetch_time", "alias:sfti,searchFetchTime;default:false;text-align:right;desc:time spent in fetch phase");
        table.addCell((Object)"search.fetch_total", "alias:sfto,searchFetchTotal;default:false;text-align:right;desc:total fetch ops");
        table.addCell((Object)"search.open_contexts", "alias:so,searchOpenContexts;default:false;text-align:right;desc:open search contexts");
        table.addCell((Object)"search.query_current", "alias:sqc,searchQueryCurrent;default:false;text-align:right;desc:current query phase ops");
        table.addCell((Object)"search.query_time", "alias:sqti,searchQueryTime;default:false;text-align:right;desc:time spent in query phase");
        table.addCell((Object)"search.query_total", "alias:sqto,searchQueryTotal;default:false;text-align:right;desc:total query phase ops");
        if (FeatureFlags.isEnabled((String)"lucenia.experimental.feature.concurrent_segment_search.enabled")) {
            table.addCell((Object)"search.concurrent_query_current", "alias:scqc,searchConcurrentQueryCurrent;default:false;text-align:right;desc:current concurrent query phase ops");
            table.addCell((Object)"search.concurrent_query_time", "alias:scqti,searchConcurrentQueryTime;default:false;text-align:right;desc:time spent in concurrent query phase");
            table.addCell((Object)"search.concurrent_query_total", "alias:scqto,searchConcurrentQueryTotal;default:false;text-align:right;desc:total concurrent query phase ops");
            table.addCell((Object)"search.concurrent_avg_slice_count", "alias:casc,searchConcurrentAvgSliceCount;default:false;text-align:right;desc:average query concurrency");
        }
        table.addCell((Object)"search.scroll_current", "alias:scc,searchScrollCurrent;default:false;text-align:right;desc:open scroll contexts");
        table.addCell((Object)"search.scroll_time", "alias:scti,searchScrollTime;default:false;text-align:right;desc:time scroll contexts held open");
        table.addCell((Object)"search.scroll_total", "alias:scto,searchScrollTotal;default:false;text-align:right;desc:completed scroll contexts");
        table.addCell((Object)"search.point_in_time_current", "alias:scc,searchPointInTimeCurrent;default:false;text-align:right;desc:open point in time contexts");
        table.addCell((Object)"search.point_in_time_time", "alias:scti,searchPointInTimeTime;default:false;text-align:right;desc:time point in time contexts held open");
        table.addCell((Object)"search.point_in_time_total", "alias:scto,searchPointInTimeTotal;default:false;text-align:right;desc:completed point in time contexts");
        table.addCell((Object)"segments.count", "alias:sc,segmentsCount;default:false;text-align:right;desc:number of segments");
        table.addCell((Object)"segments.memory", "alias:sm,segmentsMemory;default:false;text-align:right;desc:memory used by segments");
        table.addCell((Object)"segments.index_writer_memory", "alias:siwm,segmentsIndexWriterMemory;default:false;text-align:right;desc:memory used by index writer");
        table.addCell((Object)"segments.version_map_memory", "alias:svmm,segmentsVersionMapMemory;default:false;text-align:right;desc:memory used by version map");
        table.addCell((Object)"segments.fixed_bitset_memory", "alias:sfbm,fixedBitsetMemory;default:false;text-align:right;desc:memory used by fixed bit sets for nested object field types and type filters for types referred in _parent fields");
        table.addCell((Object)"suggest.current", "alias:suc,suggestCurrent;default:false;text-align:right;desc:number of current suggest ops");
        table.addCell((Object)"suggest.time", "alias:suti,suggestTime;default:false;text-align:right;desc:time spend in suggest");
        table.addCell((Object)"suggest.total", "alias:suto,suggestTotal;default:false;text-align:right;desc:number of suggest ops");
        table.endHeaders();
        return table;
    }

    Table buildTable(boolean fullId, RestRequest req, ClusterStateResponse state, NodesInfoResponse nodesInfo, NodesStatsResponse nodesStats) {
        DiscoveryNodes nodes = state.getState().nodes();
        String clusterManagerId = nodes.getClusterManagerNodeId();
        Table table = this.getTableWithHeader(req);
        for (DiscoveryNode node : nodes) {
            String allRoles;
            String roles;
            HttpInfo httpInfo;
            NodeInfo info = (NodeInfo)nodesInfo.getNodesMap().get(node.getId());
            NodeStats stats = (NodeStats)nodesStats.getNodesMap().get(node.getId());
            JvmInfo jvmInfo = info == null ? null : (JvmInfo)info.getInfo(JvmInfo.class);
            JvmStats jvmStats = stats == null ? null : stats.getJvm();
            FsInfo fsInfo = stats == null ? null : stats.getFs();
            OsStats osStats = stats == null ? null : stats.getOs();
            ProcessStats processStats = stats == null ? null : stats.getProcess();
            NodeIndicesStats indicesStats = stats == null ? null : stats.getIndices();
            table.startRow();
            table.addCell((Object)(fullId ? node.getId() : Strings.substring((String)node.getId(), (int)0, (int)4)));
            table.addCell(info == null ? null : Long.valueOf(((ProcessInfo)info.getInfo(ProcessInfo.class)).getId()));
            table.addCell((Object)node.getHostAddress());
            table.addCell((Object)node.getAddress().address().getPort());
            HttpInfo httpInfo2 = httpInfo = info == null ? null : (HttpInfo)info.getInfo(HttpInfo.class);
            if (httpInfo != null) {
                TransportAddress transportAddress = httpInfo.getAddress().publishAddress();
                table.addCell((Object)NetworkAddress.format((InetSocketAddress)transportAddress.address()));
            } else {
                table.addCell((Object)"-");
            }
            table.addCell((Object)node.getVersion().toString());
            table.addCell(info == null ? null : info.getBuild().type().displayName());
            table.addCell(info == null ? null : info.getBuild().hash());
            table.addCell((Object)(jvmInfo == null ? null : jvmInfo.version()));
            ByteSizeValue diskTotal = null;
            ByteSizeValue diskUsed = null;
            ByteSizeValue diskAvailable = null;
            String diskUsedPercent = null;
            if (fsInfo != null) {
                diskTotal = fsInfo.getTotal().getTotal();
                diskAvailable = fsInfo.getTotal().getAvailable();
                diskUsed = new ByteSizeValue(diskTotal.getBytes() - diskAvailable.getBytes());
                double diskUsedRatio = diskTotal.getBytes() == 0L ? 1.0 : (double)diskUsed.getBytes() / (double)diskTotal.getBytes();
                diskUsedPercent = String.format(Locale.ROOT, "%.2f", 100.0 * diskUsedRatio);
            }
            table.addCell(diskTotal);
            table.addCell(diskUsed);
            table.addCell((Object)diskAvailable);
            table.addCell(diskUsedPercent);
            table.addCell(jvmStats == null ? null : jvmStats.getMem().getHeapUsed());
            table.addCell(jvmStats == null ? null : Short.valueOf(jvmStats.getMem().getHeapUsedPercent()));
            table.addCell(jvmInfo == null ? null : jvmInfo.getMem().getHeapMax());
            table.addCell(osStats == null ? null : (osStats.getMem() == null ? null : osStats.getMem().getUsed()));
            table.addCell(osStats == null ? null : (osStats.getMem() == null ? null : Short.valueOf(osStats.getMem().getUsedPercent())));
            table.addCell(osStats == null ? null : (osStats.getMem() == null ? null : osStats.getMem().getTotal()));
            table.addCell(processStats == null ? null : Long.valueOf(processStats.getOpenFileDescriptors()));
            table.addCell(processStats == null ? null : Short.valueOf(this.calculatePercentage(processStats.getOpenFileDescriptors(), processStats.getMaxFileDescriptors())));
            table.addCell(processStats == null ? null : Long.valueOf(processStats.getMaxFileDescriptors()));
            table.addCell(osStats == null ? null : Short.toString(osStats.getCpu().getPercent()));
            boolean hasLoadAverage = osStats != null && osStats.getCpu().getLoadAverage() != null;
            table.addCell(!hasLoadAverage || osStats.getCpu().getLoadAverage()[0] == -1.0 ? null : String.format(Locale.ROOT, "%.2f", osStats.getCpu().getLoadAverage()[0]));
            table.addCell(!hasLoadAverage || osStats.getCpu().getLoadAverage()[1] == -1.0 ? null : String.format(Locale.ROOT, "%.2f", osStats.getCpu().getLoadAverage()[1]));
            table.addCell(!hasLoadAverage || osStats.getCpu().getLoadAverage()[2] == -1.0 ? null : String.format(Locale.ROOT, "%.2f", osStats.getCpu().getLoadAverage()[2]));
            table.addCell((Object)(jvmStats == null ? null : jvmStats.getUptime()));
            if (node.getRoles().isEmpty()) {
                roles = "-";
                allRoles = "-";
            } else {
                List knownNodeRoles = node.getRoles().stream().filter(NodeRole::isKnownRole).collect(Collectors.toList());
                roles = knownNodeRoles.size() > 0 ? knownNodeRoles.stream().map(NodeRole::roleNameAbbreviation).sorted().collect(Collectors.joining()) : "-";
                allRoles = node.getRoles().stream().map(NodeRole::roleName).sorted().collect(Collectors.joining(","));
            }
            table.addCell((Object)roles);
            table.addCell((Object)allRoles);
            table.addCell((Object)(clusterManagerId == null ? "x" : (clusterManagerId.equals(node.getId()) ? "*" : "-")));
            table.addCell((Object)node.getName());
            CompletionStats completionStats = indicesStats == null ? null : stats.getIndices().getCompletion();
            table.addCell((Object)(completionStats == null ? null : completionStats.getSize()));
            FieldDataStats fdStats = indicesStats == null ? null : stats.getIndices().getFieldData();
            table.addCell((Object)(fdStats == null ? null : fdStats.getMemorySize()));
            table.addCell(fdStats == null ? null : Long.valueOf(fdStats.getEvictions()));
            QueryCacheStats fcStats = indicesStats == null ? null : indicesStats.getQueryCache();
            table.addCell((Object)(fcStats == null ? null : fcStats.getMemorySize()));
            table.addCell(fcStats == null ? null : Long.valueOf(fcStats.getEvictions()));
            table.addCell(fcStats == null ? null : Long.valueOf(fcStats.getHitCount()));
            table.addCell(fcStats == null ? null : Long.valueOf(fcStats.getMissCount()));
            RequestCacheStats qcStats = indicesStats == null ? null : indicesStats.getRequestCache();
            table.addCell((Object)(qcStats == null ? null : qcStats.getMemorySize()));
            table.addCell(qcStats == null ? null : Long.valueOf(qcStats.getEvictions()));
            table.addCell(qcStats == null ? null : Long.valueOf(qcStats.getHitCount()));
            table.addCell(qcStats == null ? null : Long.valueOf(qcStats.getMissCount()));
            FlushStats flushStats = indicesStats == null ? null : indicesStats.getFlush();
            table.addCell(flushStats == null ? null : Long.valueOf(flushStats.getTotal()));
            table.addCell((Object)(flushStats == null ? null : flushStats.getTotalTime()));
            GetStats getStats = indicesStats == null ? null : indicesStats.getGet();
            table.addCell(getStats == null ? null : Long.valueOf(getStats.current()));
            table.addCell((Object)(getStats == null ? null : getStats.getTime()));
            table.addCell(getStats == null ? null : Long.valueOf(getStats.getCount()));
            table.addCell((Object)(getStats == null ? null : getStats.getExistsTime()));
            table.addCell(getStats == null ? null : Long.valueOf(getStats.getExistsCount()));
            table.addCell((Object)(getStats == null ? null : getStats.getMissingTime()));
            table.addCell(getStats == null ? null : Long.valueOf(getStats.getMissingCount()));
            IndexingStats indexingStats = indicesStats == null ? null : indicesStats.getIndexing();
            table.addCell(indexingStats == null ? null : Long.valueOf(indexingStats.getTotal().getDeleteCurrent()));
            table.addCell(indexingStats == null ? null : indexingStats.getTotal().getDeleteTime());
            table.addCell(indexingStats == null ? null : Long.valueOf(indexingStats.getTotal().getDeleteCount()));
            table.addCell(indexingStats == null ? null : Long.valueOf(indexingStats.getTotal().getIndexCurrent()));
            table.addCell(indexingStats == null ? null : indexingStats.getTotal().getIndexTime());
            table.addCell(indexingStats == null ? null : Long.valueOf(indexingStats.getTotal().getIndexCount()));
            table.addCell(indexingStats == null ? null : Long.valueOf(indexingStats.getTotal().getIndexFailedCount()));
            MergeStats mergeStats = indicesStats == null ? null : indicesStats.getMerge();
            table.addCell(mergeStats == null ? null : Long.valueOf(mergeStats.getCurrent()));
            table.addCell(mergeStats == null ? null : Long.valueOf(mergeStats.getCurrentNumDocs()));
            table.addCell((Object)(mergeStats == null ? null : mergeStats.getCurrentSize()));
            table.addCell(mergeStats == null ? null : Long.valueOf(mergeStats.getTotal()));
            table.addCell(mergeStats == null ? null : Long.valueOf(mergeStats.getTotalNumDocs()));
            table.addCell((Object)(mergeStats == null ? null : mergeStats.getTotalSize()));
            table.addCell((Object)(mergeStats == null ? null : mergeStats.getTotalTime()));
            RefreshStats refreshStats = indicesStats == null ? null : indicesStats.getRefresh();
            table.addCell(refreshStats == null ? null : Long.valueOf(refreshStats.getTotal()));
            table.addCell((Object)(refreshStats == null ? null : refreshStats.getTotalTime()));
            table.addCell(refreshStats == null ? null : Long.valueOf(refreshStats.getExternalTotal()));
            table.addCell((Object)(refreshStats == null ? null : refreshStats.getExternalTotalTime()));
            table.addCell(refreshStats == null ? null : Integer.valueOf(refreshStats.getListeners()));
            ScriptStats scriptStats = stats == null ? null : stats.getScriptStats();
            table.addCell(scriptStats == null ? null : Long.valueOf(scriptStats.getCompilations()));
            table.addCell(scriptStats == null ? null : Long.valueOf(scriptStats.getCacheEvictions()));
            table.addCell(scriptStats == null ? null : Long.valueOf(scriptStats.getCompilationLimitTriggered()));
            SearchStats searchStats = indicesStats == null ? null : indicesStats.getSearch();
            table.addCell(searchStats == null ? null : Long.valueOf(searchStats.getTotal().getFetchCurrent()));
            table.addCell(searchStats == null ? null : searchStats.getTotal().getFetchTime());
            table.addCell(searchStats == null ? null : Long.valueOf(searchStats.getTotal().getFetchCount()));
            table.addCell(searchStats == null ? null : Long.valueOf(searchStats.getOpenContexts()));
            table.addCell(searchStats == null ? null : Long.valueOf(searchStats.getTotal().getQueryCurrent()));
            table.addCell(searchStats == null ? null : searchStats.getTotal().getQueryTime());
            table.addCell(searchStats == null ? null : Long.valueOf(searchStats.getTotal().getQueryCount()));
            if (FeatureFlags.isEnabled((String)"lucenia.experimental.feature.concurrent_segment_search.enabled")) {
                table.addCell(searchStats == null ? null : Long.valueOf(searchStats.getTotal().getConcurrentQueryCurrent()));
                table.addCell(searchStats == null ? null : searchStats.getTotal().getConcurrentQueryTime());
                table.addCell(searchStats == null ? null : Long.valueOf(searchStats.getTotal().getConcurrentQueryCount()));
                table.addCell(searchStats == null ? null : Double.valueOf(searchStats.getTotal().getConcurrentAvgSliceCount()));
            }
            table.addCell(searchStats == null ? null : Long.valueOf(searchStats.getTotal().getScrollCurrent()));
            table.addCell(searchStats == null ? null : searchStats.getTotal().getScrollTime());
            table.addCell(searchStats == null ? null : Long.valueOf(searchStats.getTotal().getScrollCount()));
            table.addCell(searchStats == null ? null : Long.valueOf(searchStats.getTotal().getPitCurrent()));
            table.addCell(searchStats == null ? null : searchStats.getTotal().getPitTime());
            table.addCell(searchStats == null ? null : Long.valueOf(searchStats.getTotal().getPitCount()));
            SegmentsStats segmentsStats = indicesStats == null ? null : indicesStats.getSegments();
            table.addCell(segmentsStats == null ? null : Long.valueOf(segmentsStats.getCount()));
            table.addCell((Object)(segmentsStats == null ? null : segmentsStats.getZeroMemory()));
            table.addCell((Object)(segmentsStats == null ? null : segmentsStats.getIndexWriterMemory()));
            table.addCell((Object)(segmentsStats == null ? null : segmentsStats.getVersionMapMemory()));
            table.addCell((Object)(segmentsStats == null ? null : segmentsStats.getBitsetMemory()));
            table.addCell(searchStats == null ? null : Long.valueOf(searchStats.getTotal().getSuggestCurrent()));
            table.addCell(searchStats == null ? null : searchStats.getTotal().getSuggestTime());
            table.addCell(searchStats == null ? null : Long.valueOf(searchStats.getTotal().getSuggestCount()));
            table.endRow();
        }
        return table;
    }

    private short calculatePercentage(long used, long max) {
        return max <= 0L ? (short)0 : (short)(100.0 * (double)used / (double)max);
    }
}

