/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.rest.action.cat;

import io.skylite.common.action.ActionListener;
import io.skylite.core.action.admin.cluster.repositories.get.GetRepositoriesRequest;
import io.skylite.core.action.admin.cluster.repositories.get.GetRepositoriesResponse;
import io.skylite.core.action.clustermanager.ClusterManagerNodeRequest;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.cluster.metadata.RepositoryMetadata;
import io.skylite.core.common.Table;
import io.skylite.core.common.logging.DeprecationLogger;
import io.skylite.core.rest.RestHandler;
import io.skylite.core.rest.RestRequest;
import io.skylite.core.rest.RestResponse;
import java.util.Collections;
import java.util.List;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.action.RestResponseListener;
import org.opensearch.rest.action.cat.AbstractCatAction;
import org.opensearch.rest.action.cat.RestTable;

public class RestRepositoriesAction
extends AbstractCatAction {
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(RestRepositoriesAction.class);

    public List<RestHandler.Route> routes() {
        return Collections.singletonList(new RestHandler.Route(RestRequest.Method.GET, "/_cat/repositories"));
    }

    @Override
    public BaseRestHandler.RestChannelConsumer doCatRequest(final RestRequest request, NodeClient client) {
        GetRepositoriesRequest getRepositoriesRequest = new GetRepositoriesRequest();
        getRepositoriesRequest.local(request.paramAsBoolean("local", getRepositoriesRequest.local()));
        getRepositoriesRequest.clusterManagerNodeTimeout(request.paramAsTime("cluster_manager_timeout", getRepositoriesRequest.clusterManagerNodeTimeout()));
        RestRepositoriesAction.parseDeprecatedMasterTimeoutParameter((ClusterManagerNodeRequest)getRepositoriesRequest, request, deprecationLogger, this.getName());
        return channel -> client.admin().cluster().getRepositories(getRepositoriesRequest, (ActionListener)new RestResponseListener<GetRepositoriesResponse>(channel){

            @Override
            public RestResponse buildResponse(GetRepositoriesResponse getRepositoriesResponse) throws Exception {
                return RestTable.buildResponse(RestRepositoriesAction.this.buildTable(request, getRepositoriesResponse), this.channel);
            }
        });
    }

    @Override
    public String getName() {
        return "cat_repositories_action";
    }

    @Override
    protected void documentation(StringBuilder sb) {
        sb.append("/_cat/repositories\n");
    }

    @Override
    protected Table getTableWithHeader(RestRequest request) {
        return new Table().startHeaders().addCell((Object)"id", "alias:id,repoId;desc:unique repository id").addCell((Object)"type", "alias:t,type;text-align:right;desc:repository type").endHeaders();
    }

    private Table buildTable(RestRequest req, GetRepositoriesResponse getRepositoriesResponse) {
        Table table = this.getTableWithHeader(req);
        for (RepositoryMetadata repositoryMetadata : getRepositoriesResponse.repositories()) {
            table.startRow();
            table.addCell((Object)repositoryMetadata.name());
            table.addCell((Object)repositoryMetadata.type());
            table.endRow();
        }
        return table;
    }
}

