/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.rest.action.cat;

import io.skylite.common.action.ActionListener;
import io.skylite.common.unit.TimeValue;
import io.skylite.core.action.admin.cluster.snapshots.get.GetSnapshotsRequest;
import io.skylite.core.action.admin.cluster.snapshots.get.GetSnapshotsResponse;
import io.skylite.core.action.clustermanager.ClusterManagerNodeRequest;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.common.Table;
import io.skylite.core.common.logging.DeprecationLogger;
import io.skylite.core.common.time.DateFormatter;
import io.skylite.core.rest.RestHandler;
import io.skylite.core.rest.RestRequest;
import io.skylite.core.rest.RestResponse;
import io.skylite.core.snapshots.SnapshotInfo;
import io.skylite.core.snapshots.SnapshotState;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.temporal.TemporalAccessor;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.action.RestResponseListener;
import org.opensearch.rest.action.cat.AbstractCatAction;
import org.opensearch.rest.action.cat.RestTable;

public class RestSnapshotAction
extends AbstractCatAction {
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(RestSnapshotAction.class);
    private static final DateFormatter FORMATTER = DateFormatter.forPattern((String)"HH:mm:ss").withZone((ZoneId)ZoneOffset.UTC);

    public List<RestHandler.Route> routes() {
        return Collections.unmodifiableList(Arrays.asList(new RestHandler.Route(RestRequest.Method.GET, "/_cat/snapshots"), new RestHandler.Route(RestRequest.Method.GET, "/_cat/snapshots/{repository}")));
    }

    @Override
    public String getName() {
        return "cat_snapshot_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer doCatRequest(final RestRequest request, NodeClient client) {
        GetSnapshotsRequest getSnapshotsRequest = new GetSnapshotsRequest().repository(request.param("repository")).snapshots(new String[]{"_all"});
        getSnapshotsRequest.ignoreUnavailable(request.paramAsBoolean("ignore_unavailable", getSnapshotsRequest.ignoreUnavailable()));
        getSnapshotsRequest.clusterManagerNodeTimeout(request.paramAsTime("cluster_manager_timeout", getSnapshotsRequest.clusterManagerNodeTimeout()));
        RestSnapshotAction.parseDeprecatedMasterTimeoutParameter((ClusterManagerNodeRequest)getSnapshotsRequest, request, deprecationLogger, this.getName());
        return channel -> client.admin().cluster().getSnapshots(getSnapshotsRequest, (ActionListener)new RestResponseListener<GetSnapshotsResponse>(channel){

            @Override
            public RestResponse buildResponse(GetSnapshotsResponse getSnapshotsResponse) throws Exception {
                return RestTable.buildResponse(RestSnapshotAction.this.buildTable(request, getSnapshotsResponse), this.channel);
            }
        });
    }

    @Override
    protected void documentation(StringBuilder sb) {
        sb.append("/_cat/snapshots/{repository}\n");
    }

    @Override
    protected Table getTableWithHeader(RestRequest request) {
        return new Table().startHeaders().addCell((Object)"id", "alias:id,snapshot;desc:unique snapshot").addCell((Object)"status", "alias:s,status;text-align:right;desc:snapshot name").addCell((Object)"start_epoch", "alias:ste,startEpoch;desc:start time in seconds since 1970-01-01 00:00:00").addCell((Object)"start_time", "alias:sti,startTime;desc:start time in HH:MM:SS").addCell((Object)"end_epoch", "alias:ete,endEpoch;desc:end time in seconds since 1970-01-01 00:00:00").addCell((Object)"end_time", "alias:eti,endTime;desc:end time in HH:MM:SS").addCell((Object)"duration", "alias:dur,duration;text-align:right;desc:duration").addCell((Object)"indices", "alias:i,indices;text-align:right;desc:number of indices").addCell((Object)"successful_shards", "alias:ss,successful_shards;text-align:right;desc:number of successful shards").addCell((Object)"failed_shards", "alias:fs,failed_shards;text-align:right;desc:number of failed shards").addCell((Object)"total_shards", "alias:ts,total_shards;text-align:right;desc:number of total shards").addCell((Object)"reason", "default:false;alias:r,reason;desc:reason for failures").endHeaders();
    }

    private Table buildTable(RestRequest req, GetSnapshotsResponse getSnapshotsResponse) {
        Table table = this.getTableWithHeader(req);
        for (SnapshotInfo snapshotStatus : getSnapshotsResponse.getSnapshots()) {
            table.startRow();
            table.addCell((Object)snapshotStatus.snapshotId().getName());
            table.addCell((Object)snapshotStatus.state());
            table.addCell((Object)TimeUnit.SECONDS.convert(snapshotStatus.startTime(), TimeUnit.MILLISECONDS));
            table.addCell((Object)FORMATTER.format((TemporalAccessor)Instant.ofEpochMilli(snapshotStatus.startTime())));
            table.addCell((Object)TimeUnit.SECONDS.convert(snapshotStatus.endTime(), TimeUnit.MILLISECONDS));
            table.addCell((Object)FORMATTER.format((TemporalAccessor)Instant.ofEpochMilli(snapshotStatus.endTime())));
            long durationMillis = snapshotStatus.state() == SnapshotState.IN_PROGRESS ? System.currentTimeMillis() - snapshotStatus.startTime() : snapshotStatus.endTime() - snapshotStatus.startTime();
            table.addCell((Object)TimeValue.timeValueMillis((long)durationMillis));
            table.addCell((Object)snapshotStatus.indices().size());
            table.addCell((Object)snapshotStatus.successfulShards());
            table.addCell((Object)snapshotStatus.failedShards());
            table.addCell((Object)snapshotStatus.totalShards());
            table.addCell((Object)snapshotStatus.reason());
            table.endRow();
        }
        return table;
    }
}

