/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.rest.action.cat;

import io.skylite.common.action.ActionListener;
import io.skylite.common.unit.TimeValue;
import io.skylite.core.action.admin.cluster.node.tasks.list.ListTasksRequest;
import io.skylite.core.action.admin.cluster.node.tasks.list.ListTasksResponse;
import io.skylite.core.action.admin.cluster.node.tasks.list.TaskGroup;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.cluster.node.DiscoveryNode;
import io.skylite.core.cluster.node.DiscoveryNodes;
import io.skylite.core.common.Strings;
import io.skylite.core.common.Table;
import io.skylite.core.common.time.DateFormatter;
import io.skylite.core.rest.RestHandler;
import io.skylite.core.rest.RestRequest;
import io.skylite.core.rest.RestResponse;
import io.skylite.core.tasks.TaskInfo;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.action.RestResponseListener;
import org.opensearch.rest.action.admin.cluster.RestListTasksAction;
import org.opensearch.rest.action.cat.AbstractCatAction;
import org.opensearch.rest.action.cat.RestTable;

public class RestTasksAction
extends AbstractCatAction {
    private final Supplier<DiscoveryNodes> nodesInCluster;
    private static final Set<String> RESPONSE_PARAMS;
    private static final DateFormatter FORMATTER;

    public RestTasksAction(Supplier<DiscoveryNodes> nodesInCluster) {
        this.nodesInCluster = nodesInCluster;
    }

    public List<RestHandler.Route> routes() {
        return Collections.singletonList(new RestHandler.Route(RestRequest.Method.GET, "/_cat/tasks"));
    }

    @Override
    public String getName() {
        return "cat_tasks_action";
    }

    @Override
    protected void documentation(StringBuilder sb) {
        sb.append("/_cat/tasks\n");
    }

    @Override
    public BaseRestHandler.RestChannelConsumer doCatRequest(final RestRequest request, NodeClient client) {
        ListTasksRequest listTasksRequest = RestListTasksAction.generateListTasksRequest(request);
        return channel -> client.admin().cluster().listTasks(listTasksRequest, (ActionListener)new RestResponseListener<ListTasksResponse>(channel){

            @Override
            public RestResponse buildResponse(ListTasksResponse listTasksResponse) throws Exception {
                return RestTable.buildResponse(RestTasksAction.this.buildTable(request, listTasksResponse), this.channel);
            }
        });
    }

    @Override
    protected Set<String> responseParams() {
        return RESPONSE_PARAMS;
    }

    @Override
    protected Table getTableWithHeader(RestRequest request) {
        boolean detailed = request.paramAsBoolean("detailed", false);
        Table table = new Table();
        table.startHeaders();
        table.addCell((Object)"id", "default:false;desc:id of the task with the node");
        table.addCell((Object)"action", "alias:ac;desc:task action");
        table.addCell((Object)"task_id", "alias:ti;desc:unique task id");
        table.addCell((Object)"parent_task_id", "alias:pti;desc:parent task id");
        table.addCell((Object)"type", "alias:ty;desc:task type");
        table.addCell((Object)"start_time", "alias:start;desc:start time in ms");
        table.addCell((Object)"timestamp", "alias:ts,hms,hhmmss;desc:start time in HH:MM:SS");
        table.addCell((Object)"running_time_ns", "default:false;alias:time;desc:running time ns");
        table.addCell((Object)"running_time", "default:true;alias:time;desc:running time");
        table.addCell((Object)"node_id", "default:false;alias:ni;desc:unique node id");
        table.addCell((Object)"ip", "default:true;alias:i;desc:ip address");
        table.addCell((Object)"port", "default:false;alias:po;desc:bound transport port");
        table.addCell((Object)"node", "default:true;alias:n;desc:node name");
        table.addCell((Object)"version", "default:false;alias:v;desc:es version");
        table.addCell((Object)"x_opaque_id", "default:false;alias:x;desc:X-Opaque-ID header");
        if (detailed) {
            table.addCell((Object)"description", "default:true;alias:desc;desc:task action");
            table.addCell((Object)"resource_stats", "default:false;desc:resource consumption info of the task");
        }
        table.endHeaders();
        return table;
    }

    private void buildRow(Table table, boolean fullId, boolean detailed, DiscoveryNodes discoveryNodes, TaskInfo taskInfo) {
        table.startRow();
        String nodeId = taskInfo.getTaskId().getNodeId();
        DiscoveryNode node = discoveryNodes.get(nodeId);
        table.addCell((Object)taskInfo.getId());
        table.addCell((Object)taskInfo.getAction());
        table.addCell((Object)taskInfo.getTaskId().toString());
        if (taskInfo.getParentTaskId().isSet()) {
            table.addCell((Object)taskInfo.getParentTaskId().toString());
        } else {
            table.addCell((Object)"-");
        }
        table.addCell((Object)taskInfo.getType());
        table.addCell((Object)taskInfo.getStartTime());
        table.addCell((Object)FORMATTER.format((TemporalAccessor)Instant.ofEpochMilli(taskInfo.getStartTime())));
        table.addCell((Object)taskInfo.getRunningTimeNanos());
        table.addCell((Object)TimeValue.timeValueNanos((long)taskInfo.getRunningTimeNanos()));
        table.addCell((Object)(fullId ? nodeId : Strings.substring((String)nodeId, (int)0, (int)4)));
        table.addCell((Object)(node == null ? "-" : node.getHostAddress()));
        table.addCell((Object)node.getAddress().address().getPort());
        table.addCell((Object)(node == null ? "-" : node.getName()));
        table.addCell((Object)(node == null ? "-" : node.getVersion().toString()));
        table.addCell((Object)taskInfo.getHeaders().getOrDefault("X-Opaque-Id", "-"));
        if (detailed) {
            table.addCell((Object)taskInfo.getDescription());
            table.addCell((Object)taskInfo.getResourceStats());
        }
        table.endRow();
    }

    private void buildGroups(Table table, boolean fullId, boolean detailed, List<TaskGroup> taskGroups) {
        DiscoveryNodes discoveryNodes = this.nodesInCluster.get();
        ArrayList<TaskGroup> sortedGroups = new ArrayList<TaskGroup>(taskGroups);
        sortedGroups.sort(Comparator.comparingLong(o -> o.getTaskInfo().getStartTime()));
        for (TaskGroup taskGroup : sortedGroups) {
            this.buildRow(table, fullId, detailed, discoveryNodes, taskGroup.getTaskInfo());
            this.buildGroups(table, fullId, detailed, taskGroup.getChildTasks());
        }
    }

    private Table buildTable(RestRequest request, ListTasksResponse listTasksResponse) {
        boolean fullId = request.paramAsBoolean("full_id", false);
        boolean detailed = request.paramAsBoolean("detailed", false);
        Table table = this.getTableWithHeader(request);
        this.buildGroups(table, fullId, detailed, listTasksResponse.getTaskGroups());
        return table;
    }

    static {
        HashSet<String> responseParams = new HashSet<String>();
        responseParams.add("detailed");
        responseParams.addAll(AbstractCatAction.RESPONSE_PARAMS);
        RESPONSE_PARAMS = Collections.unmodifiableSet(responseParams);
        FORMATTER = DateFormatter.forPattern((String)"HH:mm:ss").withZone((ZoneId)ZoneOffset.UTC);
    }
}

