/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.rest.action.cat;

import io.skylite.common.action.ActionListener;
import io.skylite.core.action.admin.cluster.node.info.NodeInfo;
import io.skylite.core.action.admin.cluster.node.info.NodesInfoRequest;
import io.skylite.core.action.admin.cluster.node.info.NodesInfoResponse;
import io.skylite.core.action.admin.cluster.node.stats.NodeStats;
import io.skylite.core.action.admin.cluster.node.stats.NodesStatsRequest;
import io.skylite.core.action.admin.cluster.node.stats.NodesStatsResponse;
import io.skylite.core.action.admin.cluster.state.ClusterStateRequest;
import io.skylite.core.action.admin.cluster.state.ClusterStateResponse;
import io.skylite.core.action.clustermanager.ClusterManagerNodeRequest;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.cluster.node.DiscoveryNode;
import io.skylite.core.cluster.node.DiscoveryNodes;
import io.skylite.core.common.Table;
import io.skylite.core.common.logging.DeprecationLogger;
import io.skylite.core.common.regex.Regex;
import io.skylite.core.monitor.process.ProcessInfo;
import io.skylite.core.rest.RestHandler;
import io.skylite.core.rest.RestRequest;
import io.skylite.core.rest.RestResponse;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.threadpool.ThreadPoolInfo;
import io.skylite.core.threadpool.ThreadPoolStats;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.action.RestActionListener;
import org.opensearch.rest.action.RestResponseListener;
import org.opensearch.rest.action.cat.AbstractCatAction;
import org.opensearch.rest.action.cat.RestTable;

public class RestThreadPoolAction
extends AbstractCatAction {
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(RestThreadPoolAction.class);
    private static final Set<String> RESPONSE_PARAMS;

    public List<RestHandler.Route> routes() {
        return Collections.unmodifiableList(Arrays.asList(new RestHandler.Route(RestRequest.Method.GET, "/_cat/thread_pool"), new RestHandler.Route(RestRequest.Method.GET, "/_cat/thread_pool/{thread_pool_patterns}")));
    }

    @Override
    public String getName() {
        return "cat_threadpool_action";
    }

    @Override
    protected void documentation(StringBuilder sb) {
        sb.append("/_cat/thread_pool\n");
        sb.append("/_cat/thread_pool/{thread_pools}\n");
    }

    @Override
    public BaseRestHandler.RestChannelConsumer doCatRequest(final RestRequest request, final NodeClient client) {
        ClusterStateRequest clusterStateRequest = new ClusterStateRequest();
        clusterStateRequest.clear().nodes(true);
        clusterStateRequest.local(request.paramAsBoolean("local", clusterStateRequest.local()));
        clusterStateRequest.clusterManagerNodeTimeout(request.paramAsTime("cluster_manager_timeout", clusterStateRequest.clusterManagerNodeTimeout()));
        RestThreadPoolAction.parseDeprecatedMasterTimeoutParameter((ClusterManagerNodeRequest)clusterStateRequest, request, deprecationLogger, this.getName());
        return channel -> client.admin().cluster().state(clusterStateRequest, (ActionListener)new RestActionListener<ClusterStateResponse>(channel){

            @Override
            public void processResponse(final ClusterStateResponse clusterStateResponse) {
                NodesInfoRequest nodesInfoRequest = new NodesInfoRequest(new String[0]);
                nodesInfoRequest.timeout(request.param("timeout"));
                nodesInfoRequest.clear().addMetrics(new String[]{NodesInfoRequest.Metric.PROCESS.metricName(), NodesInfoRequest.Metric.THREAD_POOL.metricName()});
                client.admin().cluster().nodesInfo(nodesInfoRequest, (ActionListener)new RestActionListener<NodesInfoResponse>(this.channel){

                    @Override
                    public void processResponse(final NodesInfoResponse nodesInfoResponse) {
                        NodesStatsRequest nodesStatsRequest = new NodesStatsRequest();
                        nodesStatsRequest.timeout(request.param("timeout"));
                        nodesStatsRequest.clear().addMetric(NodesStatsRequest.Metric.THREAD_POOL.metricName());
                        client.admin().cluster().nodesStats(nodesStatsRequest, (ActionListener)new RestResponseListener<NodesStatsResponse>(this.channel){

                            @Override
                            public RestResponse buildResponse(NodesStatsResponse nodesStatsResponse) throws Exception {
                                return RestTable.buildResponse(RestThreadPoolAction.this.buildTable(request, clusterStateResponse, nodesInfoResponse, nodesStatsResponse), this.channel);
                            }
                        });
                    }
                });
            }
        });
    }

    @Override
    protected Set<String> responseParams() {
        return RESPONSE_PARAMS;
    }

    @Override
    protected Table getTableWithHeader(RestRequest request) {
        Table table = new Table();
        table.startHeaders();
        table.addCell((Object)"node_name", "default:true;alias:nn;desc:node name");
        table.addCell((Object)"node_id", "default:false;alias:id;desc:persistent node id");
        table.addCell((Object)"ephemeral_node_id", "default:false;alias:eid;desc:ephemeral node id");
        table.addCell((Object)"pid", "default:false;alias:p;desc:process id");
        table.addCell((Object)"host", "default:false;alias:h;desc:host name");
        table.addCell((Object)"ip", "default:false;alias:i;desc:ip address");
        table.addCell((Object)"port", "default:false;alias:po;desc:bound transport port");
        table.addCell((Object)"name", "default:true;alias:n;desc:thread pool name");
        table.addCell((Object)"type", "alias:t;default:false;desc:thread pool type");
        table.addCell((Object)"active", "alias:a;default:true;text-align:right;desc:number of active threads");
        table.addCell((Object)"pool_size", "alias:psz;default:false;text-align:right;desc:number of threads");
        table.addCell((Object)"queue", "alias:q;default:true;text-align:right;desc:number of tasks currently in queue");
        table.addCell((Object)"queue_size", "alias:qs;default:false;text-align:right;desc:maximum number of tasks permitted in queue");
        table.addCell((Object)"rejected", "alias:r;default:true;text-align:right;desc:number of rejected tasks");
        table.addCell((Object)"largest", "alias:l;default:false;text-align:right;desc:highest number of seen active threads");
        table.addCell((Object)"completed", "alias:c;default:false;text-align:right;desc:number of completed tasks");
        table.addCell((Object)"total_wait_time", "alias:twt;default:false;text-align:right;desc:total time tasks spent waiting in thread_pool queue");
        table.addCell((Object)"core", "alias:cr;default:false;text-align:right;desc:core number of threads in a scaling thread pool");
        table.addCell((Object)"max", "alias:mx;default:false;text-align:right;desc:maximum number of threads in a scaling thread pool");
        table.addCell((Object)"size", "alias:sz;default:false;text-align:right;desc:number of threads in a fixed thread pool");
        table.addCell((Object)"keep_alive", "alias:ka;default:false;text-align:right;desc:thread keep alive time");
        table.endHeaders();
        return table;
    }

    private Table buildTable(RestRequest req, ClusterStateResponse state, NodesInfoResponse nodesInfo, NodesStatsResponse nodesStats) {
        String[] threadPools = req.paramAsStringArray("thread_pool_patterns", new String[]{"*"});
        DiscoveryNodes nodes = state.getState().nodes();
        Table table = this.getTableWithHeader(req);
        HashSet<String> candidates = new HashSet<String>();
        for (NodeStats nodeStats : nodesStats.getNodes()) {
            for (ThreadPoolStats.Stats threadPoolStats : nodeStats.getThreadPool()) {
                candidates.add(threadPoolStats.getName());
            }
        }
        HashSet<String> included = new HashSet<String>();
        for (String candidate : candidates) {
            if (!Regex.simpleMatch((String[])threadPools, (String)candidate)) continue;
            included.add(candidate);
        }
        for (DiscoveryNode node : nodes) {
            Map<String, ThreadPool.Info> poolThreadInfo;
            Map<String, ThreadPoolStats.Stats> poolThreadStats;
            NodeInfo info = (NodeInfo)nodesInfo.getNodesMap().get(node.getId());
            NodeStats stats = (NodeStats)nodesStats.getNodesMap().get(node.getId());
            if (stats == null) {
                poolThreadStats = Collections.emptyMap();
                poolThreadInfo = Collections.emptyMap();
            } else {
                poolThreadStats = new TreeMap();
                poolThreadInfo = new HashMap();
                ThreadPoolStats threadPoolStats = stats.getThreadPool();
                for (ThreadPoolStats.Stats threadPoolStat : threadPoolStats) {
                    poolThreadStats.put(threadPoolStat.getName(), threadPoolStat);
                }
                if (info != null) {
                    for (ThreadPool.Info threadPoolInfo : (ThreadPoolInfo)info.getInfo(ThreadPoolInfo.class)) {
                        poolThreadInfo.put(threadPoolInfo.getName(), threadPoolInfo);
                    }
                }
            }
            for (Map.Entry entry : poolThreadStats.entrySet()) {
                if (!included.contains(entry.getKey())) continue;
                table.startRow();
                table.addCell((Object)node.getName());
                table.addCell((Object)node.getId());
                table.addCell((Object)node.getEphemeralId());
                table.addCell(info == null ? null : Long.valueOf(((ProcessInfo)info.getInfo(ProcessInfo.class)).getId()));
                table.addCell((Object)node.getHostName());
                table.addCell((Object)node.getHostAddress());
                table.addCell((Object)node.getAddress().address().getPort());
                ThreadPoolStats.Stats poolStats = (ThreadPoolStats.Stats)entry.getValue();
                ThreadPool.Info poolInfo = (ThreadPool.Info)poolThreadInfo.get(entry.getKey());
                Long maxQueueSize = null;
                String keepAlive = null;
                Integer core = null;
                Integer max = null;
                Integer size = null;
                if (poolInfo != null) {
                    if (poolInfo.getQueueSize() != null) {
                        maxQueueSize = poolInfo.getQueueSize().singles();
                    }
                    if (poolInfo.getKeepAlive() != null) {
                        keepAlive = poolInfo.getKeepAlive().toString();
                    }
                    if (poolInfo.getThreadPoolType() == ThreadPool.ThreadPoolType.SCALING) {
                        assert (poolInfo.getMin() >= 0);
                        core = poolInfo.getMin();
                        assert (poolInfo.getMax() > 0);
                        max = poolInfo.getMax();
                    } else {
                        assert (poolInfo.getMin() == poolInfo.getMax() && poolInfo.getMax() > 0);
                        size = poolInfo.getMax();
                    }
                }
                table.addCell(entry.getKey());
                table.addCell(poolInfo == null ? null : poolInfo.getThreadPoolType().getType());
                table.addCell(poolStats == null ? null : Integer.valueOf(poolStats.getActive()));
                table.addCell(poolStats == null ? null : Integer.valueOf(poolStats.getThreads()));
                table.addCell(poolStats == null ? null : Integer.valueOf(poolStats.getQueue()));
                table.addCell((Object)(maxQueueSize == null ? -1L : maxQueueSize));
                table.addCell(poolStats == null ? null : Long.valueOf(poolStats.getRejected()));
                table.addCell(poolStats == null ? null : Integer.valueOf(poolStats.getLargest()));
                table.addCell(poolStats == null ? null : Long.valueOf(poolStats.getCompleted()));
                table.addCell((Object)(poolStats == null ? null : poolStats.getWaitTime()));
                table.addCell((Object)core);
                table.addCell((Object)max);
                table.addCell((Object)size);
                table.addCell((Object)keepAlive);
                table.endRow();
            }
        }
        return table;
    }

    static {
        HashSet<String> responseParams = new HashSet<String>(AbstractCatAction.RESPONSE_PARAMS);
        responseParams.add("thread_pool_patterns");
        RESPONSE_PARAMS = Collections.unmodifiableSet(responseParams);
    }
}

