/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.rest.action.ingest;

import io.skylite.common.collect.Tuple;
import io.skylite.core.action.ingest.SimulatePipelineRequest;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.common.bytes.BytesReference;
import io.skylite.core.rest.RestChannel;
import io.skylite.core.rest.RestHandler;
import io.skylite.core.rest.RestRequest;
import io.skylite.core.xcontent.MediaType;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.action.RestToXContentListener;

public class RestSimulatePipelineAction
extends BaseRestHandler {
    public List<RestHandler.Route> routes() {
        return Collections.unmodifiableList(Arrays.asList(new RestHandler.Route(RestRequest.Method.GET, "/_ingest/pipeline/{id}/_simulate"), new RestHandler.Route(RestRequest.Method.POST, "/_ingest/pipeline/{id}/_simulate"), new RestHandler.Route(RestRequest.Method.GET, "/_ingest/pipeline/_simulate"), new RestHandler.Route(RestRequest.Method.POST, "/_ingest/pipeline/_simulate")));
    }

    @Override
    public String getName() {
        return "ingest_simulate_pipeline_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest restRequest, NodeClient client) throws IOException {
        Tuple sourceTuple = restRequest.contentOrSourceParam();
        SimulatePipelineRequest request = new SimulatePipelineRequest((BytesReference)sourceTuple.v2(), (MediaType)sourceTuple.v1());
        request.setId(restRequest.param("id"));
        request.setVerbose(restRequest.paramAsBoolean("verbose", false));
        return channel -> client.admin().cluster().simulatePipeline(request, new RestToXContentListener((RestChannel)channel));
    }
}

