/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.rest.action.search;

import io.skylite.common.unit.TimeValue;
import io.skylite.core.action.search.CreatePitRequest;
import io.skylite.core.action.support.IndicesOptions;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.common.Strings;
import io.skylite.core.rest.RestChannel;
import io.skylite.core.rest.RestHandler;
import io.skylite.core.rest.RestRequest;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.action.RestStatusToXContentListener;

public class RestCreatePitAction
extends BaseRestHandler {
    public static String ALLOW_PARTIAL_PIT_CREATION = "allow_partial_pit_creation";
    public static String KEEP_ALIVE = "keep_alive";

    @Override
    public String getName() {
        return "create_pit_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        boolean allowPartialPitCreation = request.paramAsBoolean(ALLOW_PARTIAL_PIT_CREATION, true);
        String[] indices = Strings.splitStringByCommaToArray((String)request.param("index"));
        TimeValue keepAlive = request.paramAsTime(KEEP_ALIVE, null);
        CreatePitRequest createPitRequest = new CreatePitRequest(keepAlive, Boolean.valueOf(allowPartialPitCreation), indices);
        createPitRequest.setIndicesOptions(IndicesOptions.fromRequest((RestRequest)request, (IndicesOptions)createPitRequest.indicesOptions()));
        createPitRequest.setPreference(request.param("preference"));
        createPitRequest.setRouting(request.param("routing"));
        return channel -> client.createPit(createPitRequest, new RestStatusToXContentListener((RestChannel)channel));
    }

    public List<RestHandler.Route> routes() {
        return Collections.unmodifiableList(Arrays.asList(new RestHandler.Route(RestRequest.Method.POST, "/{index}/_search/point_in_time")));
    }
}

