/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.rest.action.search;

import io.skylite.core.action.explain.ExplainRequest;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.common.Strings;
import io.skylite.core.index.query.QueryBuilder;
import io.skylite.core.rest.RestChannel;
import io.skylite.core.rest.RestHandler;
import io.skylite.core.rest.RestRequest;
import io.skylite.core.search.fetch.subphase.FetchSourceContext;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.action.RestActions;
import org.opensearch.rest.action.RestStatusToXContentListener;

public class RestExplainAction
extends BaseRestHandler {
    public List<RestHandler.Route> routes() {
        return Collections.unmodifiableList(Arrays.asList(new RestHandler.Route(RestRequest.Method.GET, "/{index}/_explain/{id}"), new RestHandler.Route(RestRequest.Method.POST, "/{index}/_explain/{id}")));
    }

    @Override
    public String getName() {
        return "explain_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        String[] sFields;
        ExplainRequest explainRequest = new ExplainRequest(request.param("index"), request.param("id"));
        explainRequest.parent(request.param("parent"));
        explainRequest.routing(request.param("routing"));
        explainRequest.preference(request.param("preference"));
        String queryString = request.param("q");
        request.withContentOrSourceParamParserOrNull(parser -> {
            if (parser != null) {
                explainRequest.query(RestActions.getQueryContent(parser));
            } else if (queryString != null) {
                QueryBuilder query = RestActions.urlParamsToQueryBuilder(request);
                explainRequest.query(query);
            }
        });
        if (request.param("fields") != null) {
            throw new IllegalArgumentException("The parameter [fields] is no longer supported, please use [stored_fields] to retrieve stored fields");
        }
        String sField = request.param("stored_fields");
        if (sField != null && (sFields = Strings.splitStringByCommaToArray((String)sField)) != null) {
            explainRequest.storedFields(sFields);
        }
        explainRequest.fetchSourceContext(FetchSourceContext.parseFromRestRequest((RestRequest)request));
        return channel -> client.explain(explainRequest, new RestStatusToXContentListener((RestChannel)channel));
    }
}

