/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.rest.action.search;

import io.skylite.common.Booleans;
import io.skylite.common.ExceptionsHelper;
import io.skylite.common.action.ActionRequestValidationException;
import io.skylite.common.action.ValidateActions;
import io.skylite.common.unit.TimeValue;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionType;
import io.skylite.core.action.search.SearchAction;
import io.skylite.core.action.search.SearchContextId;
import io.skylite.core.action.support.IndicesOptions;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.common.Strings;
import io.skylite.core.common.io.stream.NamedWriteableRegistry;
import io.skylite.core.index.query.QueryBuilder;
import io.skylite.core.rest.RestChannel;
import io.skylite.core.rest.RestHandler;
import io.skylite.core.rest.RestRequest;
import io.skylite.core.search.Scroll;
import io.skylite.core.search.SearchRequest;
import io.skylite.core.search.builder.SearchSourceBuilder;
import io.skylite.core.search.fetch.StoredFieldsContext;
import io.skylite.core.search.fetch.subphase.FetchSourceContext;
import io.skylite.core.search.internal.SearchExecutionContext;
import io.skylite.core.search.sort.SortOrder;
import io.skylite.core.search.suggest.SuggestBuilder;
import io.skylite.core.search.suggest.SuggestionBuilder;
import io.skylite.core.search.suggest.term.TermSuggestionBuilder;
import io.skylite.core.xcontent.XContentParser;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.IntConsumer;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.action.RestActions;
import org.opensearch.rest.action.RestCancellableNodeClient;
import org.opensearch.rest.action.RestStatusToXContentListener;
import org.opensearch.search.suggest.SuggestBuilders;

public class RestSearchAction
extends BaseRestHandler {
    private static final Set<String> RESPONSE_PARAMS;

    @Override
    public String getName() {
        return "search_action";
    }

    public List<RestHandler.Route> routes() {
        return Collections.unmodifiableList(Arrays.asList(new RestHandler.Route(RestRequest.Method.GET, "/_search"), new RestHandler.Route(RestRequest.Method.POST, "/_search"), new RestHandler.Route(RestRequest.Method.GET, "/{index}/_search"), new RestHandler.Route(RestRequest.Method.POST, "/{index}/_search")));
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        SearchRequest searchRequest = new SearchRequest();
        IntConsumer setSize = size -> searchRequest.source().size(size);
        request.withContentOrSourceParamParserOrNull(parser -> RestSearchAction.parseSearchRequest(searchRequest, request, parser, client.getNamedWriteableRegistry(), setSize));
        return channel -> {
            RestCancellableNodeClient cancelClient = new RestCancellableNodeClient(client, request.getHttpChannel());
            cancelClient.execute((ActionType)SearchAction.INSTANCE, (ActionRequest)searchRequest, new RestStatusToXContentListener((RestChannel)channel));
        };
    }

    public static void parseSearchRequest(SearchRequest searchRequest, RestRequest request, XContentParser requestContentParser, NamedWriteableRegistry namedWriteableRegistry, IntConsumer setSize) throws IOException {
        String searchType;
        if (searchRequest.source() == null) {
            searchRequest.source(new SearchSourceBuilder());
        }
        searchRequest.indices(Strings.splitStringByCommaToArray((String)request.param("index")));
        if (requestContentParser != null) {
            searchRequest.source().parseXContent(requestContentParser, true);
        }
        int batchedReduceSize = request.paramAsInt("batched_reduce_size", searchRequest.getBatchedReduceSize());
        searchRequest.setBatchedReduceSize(batchedReduceSize);
        if (request.hasParam("pre_filter_shard_size")) {
            searchRequest.setPreFilterShardSize(request.paramAsInt("pre_filter_shard_size", 128));
        }
        if (request.hasParam("max_concurrent_shard_requests")) {
            int maxConcurrentShardRequests = request.paramAsInt("max_concurrent_shard_requests", searchRequest.getMaxConcurrentShardRequests());
            searchRequest.setMaxConcurrentShardRequests(maxConcurrentShardRequests);
        }
        if (request.hasParam("allow_partial_search_results")) {
            searchRequest.allowPartialSearchResults(request.paramAsBoolean("allow_partial_search_results", null).booleanValue());
        }
        if (request.hasParam("phase_took")) {
            searchRequest.setPhaseTook(Boolean.valueOf(request.paramAsBoolean("phase_took", true)));
        }
        if ("query_and_fetch".equals(searchType = request.param("search_type")) || "dfs_query_and_fetch".equals(searchType)) {
            throw new IllegalArgumentException("Unsupported search type [" + searchType + "]");
        }
        searchRequest.searchType(searchType);
        RestSearchAction.parseSearchSource(searchRequest.source(), request, setSize);
        searchRequest.requestCache(request.paramAsBoolean("request_cache", searchRequest.requestCache()));
        String scroll = request.param("scroll");
        if (scroll != null) {
            searchRequest.scroll(new Scroll(TimeValue.parseTimeValue((String)scroll, null, (String)"scroll")));
        }
        searchRequest.routing(request.param("routing"));
        searchRequest.preference(request.param("preference"));
        searchRequest.indicesOptions(IndicesOptions.fromRequest((RestRequest)request, (IndicesOptions)searchRequest.indicesOptions()));
        searchRequest.pipeline(request.param("search_pipeline"));
        RestSearchAction.checkRestTotalHits(request, searchRequest);
        if (searchRequest.pointInTimeBuilder() != null) {
            RestSearchAction.preparePointInTime(searchRequest, request, namedWriteableRegistry);
        } else {
            searchRequest.setCcsMinimizeRoundtrips(request.paramAsBoolean("ccs_minimize_roundtrips", searchRequest.isCcsMinimizeRoundtrips()));
        }
        searchRequest.setCancelAfterTimeInterval(request.paramAsTime("cancel_after_time_interval", null));
    }

    private static void parseSearchSource(SearchSourceBuilder searchSourceBuilder, RestRequest request, IntConsumer setSize) {
        String suggestField;
        String sStats;
        String sSorts;
        FetchSourceContext fetchSourceContext;
        String sDocValueFields;
        StoredFieldsContext storedFieldsContext;
        int size;
        int from;
        QueryBuilder queryBuilder = RestActions.urlParamsToQueryBuilder(request);
        if (queryBuilder != null) {
            searchSourceBuilder.query(queryBuilder);
        }
        if ((from = request.paramAsInt("from", -1)) != -1) {
            searchSourceBuilder.from(from);
        }
        if ((size = request.paramAsInt("size", -1)) != -1) {
            setSize.accept(size);
        }
        if (request.hasParam("explain")) {
            searchSourceBuilder.explain(request.paramAsBoolean("explain", null));
        }
        if (request.hasParam("version")) {
            searchSourceBuilder.version(request.paramAsBoolean("version", null));
        }
        if (request.hasParam("seq_no_primary_term")) {
            searchSourceBuilder.seqNoAndPrimaryTerm(request.paramAsBoolean("seq_no_primary_term", null));
        }
        if (request.hasParam("timeout")) {
            searchSourceBuilder.timeout(request.paramAsTime("timeout", null));
        }
        if (request.hasParam("terminate_after")) {
            int terminateAfter = request.paramAsInt("terminate_after", 0);
            if (terminateAfter < 0) {
                throw new IllegalArgumentException("terminateAfter must be > 0");
            }
            if (terminateAfter > 0) {
                searchSourceBuilder.terminateAfter(terminateAfter);
            }
        }
        if ((storedFieldsContext = StoredFieldsContext.fromRestRequest((String)SearchSourceBuilder.STORED_FIELDS_FIELD.getPreferredName(), (RestRequest)request)) != null) {
            searchSourceBuilder.storedFields(storedFieldsContext);
        }
        if ((sDocValueFields = request.param("docvalue_fields")) != null && Strings.hasText((String)sDocValueFields)) {
            String[] sFields;
            for (String field : sFields = Strings.splitStringByCommaToArray((String)sDocValueFields)) {
                searchSourceBuilder.docValueField(field, null);
            }
        }
        if ((fetchSourceContext = FetchSourceContext.parseFromRestRequest((RestRequest)request)) != null) {
            searchSourceBuilder.fetchSource(fetchSourceContext);
        }
        if (request.hasParam("track_scores")) {
            searchSourceBuilder.trackScores(request.paramAsBoolean("track_scores", false));
        }
        if (request.hasParam("track_total_hits")) {
            if (Booleans.isBoolean((String)request.param("track_total_hits"))) {
                searchSourceBuilder.trackTotalHits(request.paramAsBoolean("track_total_hits", true));
            } else {
                searchSourceBuilder.trackTotalHitsUpTo(request.paramAsInt("track_total_hits", 10000));
            }
        }
        if ((sSorts = request.param("sort")) != null) {
            String[] sorts;
            for (String sort : sorts = Strings.splitStringByCommaToArray((String)sSorts)) {
                int delimiter = sort.lastIndexOf(":");
                if (delimiter != -1) {
                    String sortField = sort.substring(0, delimiter);
                    String reverse = sort.substring(delimiter + 1);
                    if ("asc".equals(reverse)) {
                        searchSourceBuilder.sort(sortField, SortOrder.ASC);
                        continue;
                    }
                    if (!"desc".equals(reverse)) continue;
                    searchSourceBuilder.sort(sortField, SortOrder.DESC);
                    continue;
                }
                searchSourceBuilder.sort(sort);
            }
        }
        if ((sStats = request.param("stats")) != null) {
            searchSourceBuilder.stats(Arrays.asList(Strings.splitStringByCommaToArray((String)sStats)));
        }
        if ((suggestField = request.param("suggest_field")) != null) {
            String suggestText = request.param("suggest_text", request.param("q"));
            int suggestSize = request.paramAsInt("suggest_size", 5);
            String suggestMode = request.param("suggest_mode");
            searchSourceBuilder.suggest(new SuggestBuilder().addSuggestion(suggestField, (SuggestionBuilder)((TermSuggestionBuilder)((TermSuggestionBuilder)SuggestBuilders.termSuggestion(suggestField).text(suggestText)).size(suggestSize)).suggestMode(TermSuggestionBuilder.SuggestMode.resolve((String)suggestMode))));
        }
    }

    static void preparePointInTime(SearchRequest request, RestRequest restRequest, NamedWriteableRegistry namedWriteableRegistry) {
        assert (request.pointInTimeBuilder() != null);
        ActionRequestValidationException validationException = null;
        if (request.indices().length > 0) {
            validationException = ValidateActions.addValidationError((String)"[indices] cannot be used with point in time", validationException);
        }
        if (request.indicesOptions() != SearchExecutionContext.DEFAULT_INDICES_OPTIONS) {
            validationException = ValidateActions.addValidationError((String)"[indicesOptions] cannot be used with point in time", (ActionRequestValidationException)validationException);
        }
        if (request.routing() != null) {
            validationException = ValidateActions.addValidationError((String)"[routing] cannot be used with point in time", (ActionRequestValidationException)validationException);
        }
        if (request.preference() != null) {
            validationException = ValidateActions.addValidationError((String)"[preference] cannot be used with point in time", (ActionRequestValidationException)validationException);
        }
        if (restRequest.paramAsBoolean("ccs_minimize_roundtrips", false)) {
            validationException = ValidateActions.addValidationError((String)"[ccs_minimize_roundtrips] cannot be used with point in time", (ActionRequestValidationException)validationException);
            request.setCcsMinimizeRoundtrips(false);
        }
        ExceptionsHelper.reThrowIfNotNull((Throwable)validationException);
        IndicesOptions indicesOptions = request.indicesOptions();
        IndicesOptions stricterIndicesOptions = IndicesOptions.fromOptions((boolean)indicesOptions.ignoreUnavailable(), (boolean)indicesOptions.allowNoIndices(), (boolean)false, (boolean)false, (boolean)false, (boolean)true, (boolean)true, (boolean)indicesOptions.ignoreThrottled());
        request.indicesOptions(stricterIndicesOptions);
        SearchContextId searchContextId = SearchContextId.decode((NamedWriteableRegistry)namedWriteableRegistry, (String)request.pointInTimeBuilder().getId());
        request.indices(searchContextId.getActualIndices());
    }

    public static void checkRestTotalHits(RestRequest restRequest, SearchRequest searchRequest) {
        Integer trackTotalHitsUpTo;
        boolean totalHitsAsInt = restRequest.paramAsBoolean("rest_total_hits_as_int", false);
        if (!totalHitsAsInt) {
            return;
        }
        if (searchRequest.source() == null) {
            searchRequest.source(new SearchSourceBuilder());
        }
        if ((trackTotalHitsUpTo = searchRequest.source().trackTotalHitsUpTo()) == null) {
            searchRequest.source().trackTotalHits(true);
        } else if (trackTotalHitsUpTo != Integer.MAX_VALUE && trackTotalHitsUpTo != -1) {
            throw new IllegalArgumentException("[rest_total_hits_as_int] cannot be used if the tracking of total hits is not accurate, got " + trackTotalHitsUpTo);
        }
    }

    @Override
    protected Set<String> responseParams() {
        return RESPONSE_PARAMS;
    }

    public boolean allowsUnsafeBuffers() {
        return true;
    }

    static {
        HashSet<String> responseParams = new HashSet<String>(Arrays.asList("typed_keys", "rest_total_hits_as_int"));
        RESPONSE_PARAMS = Collections.unmodifiableSet(responseParams);
    }
}

