/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.script;

import io.skylite.Version;
import io.skylite.common.MutatingMap;
import io.skylite.core.common.logging.DeprecationLogger;
import io.skylite.core.index.fielddata.ScriptDocValues;
import io.skylite.core.script.ScriptContext;
import io.skylite.core.script.ScriptFactory;
import io.skylite.core.search.lookup.LeafSearchLookup;
import io.skylite.core.search.lookup.SearchLookup;
import io.skylite.core.search.lookup.SourceLookup;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.DoubleSupplier;
import java.util.function.Function;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Scorable;
import org.opensearch.index.query.functionscore.TermFrequencyFunctionFactory;
import org.opensearch.search.lookup.LeafTermFrequencyLookup;

public abstract class ScoreScript {
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(MutatingMap.class);
    private static final Map<String, Function<Object, Object>> PARAMS_FUNCTIONS = Map.of("doc", value -> {
        deprecationLogger.deprecate("score-script_doc", "Accessing variable [doc] via [params.doc] from within an score-script is deprecated in favor of directly accessing [doc].", new Object[0]);
        return value;
    }, "_doc", value -> {
        deprecationLogger.deprecate("score-script__doc", "Accessing variable [doc] via [params._doc] from within an score-script is deprecated in favor of directly accessing [doc].", new Object[0]);
        return value;
    }, "_source", value -> ((SourceLookup)value).loadSourceIfNeeded());
    public static final String[] PARAMETERS = new String[]{"explanation"};
    private final Map<String, Object> params;
    private final LeafSearchLookup leafLookup;
    private final LeafTermFrequencyLookup leafTermFrequencyLookup;
    private DoubleSupplier scoreSupplier = () -> 0.0;
    private final int docBase;
    private int docId;
    private int shardId = -1;
    private String indexName = null;
    private Version indexVersion = null;
    public static final ScriptContext<Factory> CONTEXT = new ScriptContext("score", Factory.class);

    public ScoreScript(Map<String, Object> params, SearchLookup lookup, IndexSearcher indexSearcher, LeafReaderContext leafContext) {
        if (lookup == null) {
            assert (params == null);
            assert (leafContext == null);
            this.params = null;
            this.leafLookup = null;
            this.leafTermFrequencyLookup = null;
            this.docBase = 0;
        } else {
            this.leafLookup = lookup.getLeafSearchLookup(leafContext);
            this.leafTermFrequencyLookup = new LeafTermFrequencyLookup(indexSearcher, this.leafLookup);
            params = new HashMap<String, Object>(params);
            params.putAll(this.leafLookup.asMap());
            this.params = new MutatingMap(params, PARAMS_FUNCTIONS);
            this.docBase = leafContext.docBase;
        }
    }

    public abstract double execute(ExplanationHolder var1);

    public Map<String, Object> getParams() {
        return this.params;
    }

    public Map<String, ScriptDocValues<?>> getDoc() {
        return this.leafLookup.doc();
    }

    public Object getTermFrequency(TermFrequencyFunctionFactory.TermFrequencyFunctionName functionName, String field, String val) throws IOException {
        return this.leafTermFrequencyLookup.getTermFrequency(functionName, field, val, this.docId);
    }

    public void setDocument(int docid) {
        this.docId = docid;
        this.leafLookup.setDocument(docid);
    }

    public int docId() {
        return this.docId;
    }

    public void setScorer(Scorable scorer) {
        this.scoreSupplier = () -> {
            try {
                return scorer.score();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        };
    }

    public double get_score() {
        return this.scoreSupplier.getAsDouble();
    }

    public int _getDocId() {
        return this.docId;
    }

    public int _getDocBaseId() {
        return this.docBase + this.docId;
    }

    public int _getShardId() {
        if (this.shardId > -1) {
            return this.shardId;
        }
        throw new IllegalArgumentException("shard id can not be looked up!");
    }

    public String _getIndex() {
        if (this.indexName != null) {
            return this.indexName;
        }
        throw new IllegalArgumentException("index name can not be looked up!");
    }

    public Version _getIndexVersion() {
        if (this.indexVersion != null) {
            return this.indexVersion;
        }
        throw new IllegalArgumentException("index version can not be looked up!");
    }

    public void _setShard(int shardId) {
        this.shardId = shardId;
    }

    public void _setIndexName(String indexName) {
        this.indexName = indexName;
    }

    public void _setIndexVersion(Version indexVersion) {
        this.indexVersion = indexVersion;
    }

    public static interface Factory
    extends ScriptFactory {
        public LeafFactory newFactory(Map<String, Object> var1, SearchLookup var2, IndexSearcher var3);
    }

    public static interface LeafFactory {
        public boolean needs_score();

        public ScoreScript newInstance(LeafReaderContext var1) throws IOException;
    }

    public static class ExplanationHolder {
        private String description;

        public void set(String description) {
            this.description = description;
        }

        public Explanation get(double score, Explanation subQueryExplanation) {
            if (this.description == null) {
                return null;
            }
            if (subQueryExplanation != null) {
                return Explanation.match((Number)score, (String)this.description, (Explanation[])new Explanation[]{subQueryExplanation});
            }
            return Explanation.match((Number)score, (String)this.description, (Explanation[])new Explanation[0]);
        }
    }
}

