/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search;

import io.skylite.Version;
import io.skylite.common.Nullable;
import io.skylite.common.SetOnce;
import io.skylite.common.unit.TimeValue;
import io.skylite.common.util.concurrent.SkyliteRejectedExecutionException;
import io.skylite.core.FeatureFlags;
import io.skylite.core.action.search.SearchShardTask;
import io.skylite.core.action.search.SearchType;
import io.skylite.core.aggregations.BucketCollectorProcessor;
import io.skylite.core.aggregations.InternalAggregation;
import io.skylite.core.aggregations.SearchContextAggregations;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.util.BigArrays;
import io.skylite.core.index.IndexSettings;
import io.skylite.core.index.cache.bitset.BitsetFilterCache;
import io.skylite.core.index.engine.Engine;
import io.skylite.core.index.query.ParsedQuery;
import io.skylite.core.index.query.QueryBuilder;
import io.skylite.core.index.query.QueryRewriteContext;
import io.skylite.core.index.query.QueryShardContext;
import io.skylite.core.lucene.search.Queries;
import io.skylite.core.mapper.MapperService;
import io.skylite.core.search.SearchExtBuilder;
import io.skylite.core.search.SearchServiceSettings;
import io.skylite.core.search.SearchShardTarget;
import io.skylite.core.search.builder.SearchSourceBuilder;
import io.skylite.core.search.collapse.CollapseContext;
import io.skylite.core.search.dfs.DfsSearchResult;
import io.skylite.core.search.fetch.FetchSearchResult;
import io.skylite.core.search.fetch.StoredFieldsContext;
import io.skylite.core.search.fetch.subphase.FetchDocValuesContext;
import io.skylite.core.search.fetch.subphase.FetchFieldsContext;
import io.skylite.core.search.fetch.subphase.FetchSourceContext;
import io.skylite.core.search.fetch.subphase.ScriptFieldsContext;
import io.skylite.core.search.fetch.subphase.highlight.SearchHighlightContext;
import io.skylite.core.search.internal.ContextIndexSearcher;
import io.skylite.core.search.internal.ReaderContext;
import io.skylite.core.search.internal.ScrollContext;
import io.skylite.core.search.internal.SearchExecutionContext;
import io.skylite.core.search.internal.ShardSearchContextId;
import io.skylite.core.search.internal.ShardSearchRequest;
import io.skylite.core.search.nested.NestedDocuments;
import io.skylite.core.search.profile.Profilers;
import io.skylite.core.search.query.QueryPhaseExecutionException;
import io.skylite.core.search.query.QuerySearchResult;
import io.skylite.core.search.query.ReduceableSearchResult;
import io.skylite.core.search.rescore.RescoreContext;
import io.skylite.core.search.slice.SliceBuilder;
import io.skylite.core.search.sort.SortAndFormats;
import io.skylite.core.search.suggest.SuggestionSearchContext;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.function.LongSupplier;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.CollectorManager;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.opensearch.index.IndexService;
import org.opensearch.index.search.NestedHelper;
import org.opensearch.index.shard.IndexShard;
import org.opensearch.search.fetch.FetchPhase;
import org.opensearch.search.internal.PitReaderContext;
import org.opensearch.search.internal.SearchContext;

final class DefaultSearchContext
extends SearchContext {
    private final ReaderContext readerContext;
    private final ShardSearchRequest request;
    private final SearchShardTarget shardTarget;
    private final LongSupplier relativeTimeSupplier;
    private SearchType searchType;
    private final BigArrays bigArrays;
    private final IndexShard indexShard;
    private final ClusterService clusterService;
    private final IndexService indexService;
    private final ContextIndexSearcher searcher;
    private final DfsSearchResult dfsResult;
    private final QuerySearchResult queryResult;
    private final FetchSearchResult fetchResult;
    private final float queryBoost;
    private final boolean lowLevelCancellation;
    private TimeValue timeout;
    private int terminateAfter = 0;
    private List<String> groupStats;
    private boolean explain;
    private boolean version = false;
    private boolean seqAndPrimaryTerm = false;
    private StoredFieldsContext storedFields;
    private ScriptFieldsContext scriptFields;
    private FetchSourceContext fetchSourceContext;
    private FetchDocValuesContext docValuesContext;
    private FetchFieldsContext fetchFieldsContext;
    private int from = -1;
    private int size = -1;
    private SortAndFormats sort;
    private Float minimumScore;
    private boolean trackScores = false;
    private int trackTotalHitsUpTo = 10000;
    private FieldDoc searchAfter;
    private CollapseContext collapse;
    private SliceBuilder sliceBuilder;
    private SearchShardTask task;
    private final Version minNodeVersion;
    private ParsedQuery originalQuery;
    private Query query;
    private ParsedQuery postFilter;
    private Query aliasFilter;
    private int[] docIdsToLoad;
    private int docsIdsToLoadSize;
    private SearchContextAggregations aggregations;
    private SearchHighlightContext highlight;
    private SuggestionSearchContext suggest;
    private List<RescoreContext> rescore;
    private Profilers profilers;
    private BucketCollectorProcessor bucketCollectorProcessor = NO_OP_BUCKET_COLLECTOR_PROCESSOR;
    private final Map<String, SearchExtBuilder> searchExtBuilders = new HashMap<String, SearchExtBuilder>();
    private final Map<Class<?>, CollectorManager<? extends Collector, ReduceableSearchResult>> queryCollectorManagers = new HashMap();
    private final QueryShardContext queryShardContext;
    private final FetchPhase fetchPhase;
    private final Function<SearchSourceBuilder, InternalAggregation.ReduceContextBuilder> requestToAggReduceContextBuilder;
    private final boolean concurrentSearchSettingsEnabled;
    private final SetOnce<Boolean> requestShouldUseConcurrentSearch = new SetOnce();

    DefaultSearchContext(ReaderContext readerContext, ShardSearchRequest request, SearchShardTarget shardTarget, ClusterService clusterService, BigArrays bigArrays, LongSupplier relativeTimeSupplier, TimeValue timeout, FetchPhase fetchPhase, boolean lowLevelCancellation, Version minNodeVersion, boolean validate, Executor executor, Function<SearchSourceBuilder, InternalAggregation.ReduceContextBuilder> requestToAggReduceContextBuilder) throws IOException {
        this.readerContext = readerContext;
        this.request = request;
        this.fetchPhase = fetchPhase;
        this.searchType = request.searchType();
        this.shardTarget = shardTarget;
        this.bigArrays = bigArrays.withCircuitBreaking();
        this.dfsResult = new DfsSearchResult(readerContext.id(), shardTarget, request);
        this.queryResult = new QuerySearchResult(readerContext.id(), shardTarget, request);
        this.fetchResult = new FetchSearchResult(readerContext.id(), shardTarget);
        this.indexService = (IndexService)readerContext.indexService();
        this.indexShard = (IndexShard)readerContext.indexShard();
        this.clusterService = clusterService;
        Engine.Searcher engineSearcher = readerContext.acquireSearcher("search");
        this.concurrentSearchSettingsEnabled = this.evaluateConcurrentSegmentSearchSettings(executor);
        this.searcher = new ContextIndexSearcher(engineSearcher.getIndexReader(), engineSearcher.getSimilarity(), engineSearcher.getQueryCache(), engineSearcher.getQueryCachingPolicy(), lowLevelCancellation, this.concurrentSearchSettingsEnabled ? executor : null, (SearchExecutionContext)this);
        this.releasables.addAll(List.of(engineSearcher, this.searcher));
        this.relativeTimeSupplier = relativeTimeSupplier;
        this.timeout = timeout;
        this.minNodeVersion = minNodeVersion;
        this.queryShardContext = this.indexService.newQueryShardContext(request.shardId().id(), (IndexSearcher)this.searcher, () -> ((ShardSearchRequest)request).nowInMillis(), shardTarget.getClusterAlias(), request.getRuntimeMappings(), validate);
        this.queryBoost = request.indexBoost();
        this.lowLevelCancellation = lowLevelCancellation;
        this.requestToAggReduceContextBuilder = requestToAggReduceContextBuilder;
    }

    public void preProcess(boolean rewrite) {
        int sliceLimit;
        int maxResultWindow;
        long size;
        if (this.hasOnlySuggest()) {
            return;
        }
        long from = this.from() == -1 ? 0L : (long)this.from();
        long resultWindow = from + (size = this.size() == -1 ? 10L : (long)this.size());
        if (resultWindow > (long)(maxResultWindow = this.indexService.getIndexSettings().getMaxResultWindow())) {
            if (this.scrollContext() == null) {
                throw new IllegalArgumentException("Result window is too large, from + size must be less than or equal to: [" + maxResultWindow + "] but was [" + resultWindow + "]. See the scroll api for a more efficient way to request large data sets. This limit can be set by changing the [" + IndexSettings.MAX_RESULT_WINDOW_SETTING.getKey() + "] index level setting.");
            }
            throw new IllegalArgumentException("Batch size is too large, size must be less than or equal to: [" + maxResultWindow + "] but was [" + resultWindow + "]. Scroll batch sizes cost as much memory as result windows so they are controlled by the [" + IndexSettings.MAX_RESULT_WINDOW_SETTING.getKey() + "] index level setting.");
        }
        if (this.rescore != null) {
            if (this.sort != null) {
                throw new IllegalArgumentException("Cannot use [sort] option in conjunction with [rescore].");
            }
            int maxWindow = this.indexService.getIndexSettings().getMaxRescoreWindow();
            for (RescoreContext rescoreContext : this.rescore()) {
                if (rescoreContext.getWindowSize() <= maxWindow) continue;
                throw new IllegalArgumentException("Rescore window [" + rescoreContext.getWindowSize() + "] is too large. It must be less than [" + maxWindow + "]. This prevents allocating massive heaps for storing the results to be rescored. This limit can be set by changing the [" + IndexSettings.MAX_RESCORE_WINDOW_SETTING.getKey() + "] index level setting.");
            }
        }
        if (this.sliceBuilder != null && this.scrollContext() != null) {
            sliceLimit = this.indexService.getIndexSettings().getMaxSlicesPerScroll();
            int numSlices = this.sliceBuilder.getMax();
            if (numSlices > sliceLimit) {
                throw new IllegalArgumentException("The number of slices [" + numSlices + "] is too large. It must be less than [" + sliceLimit + "]. This limit can be set by changing the [" + IndexSettings.MAX_SLICES_PER_SCROLL.getKey() + "] index level setting.");
            }
        }
        if (this.sliceBuilder != null && this.readerContext != null && this.readerContext instanceof PitReaderContext) {
            sliceLimit = this.indexService.getIndexSettings().getMaxSlicesPerPit();
            int numSlices = this.sliceBuilder.getMax();
            if (numSlices > sliceLimit) {
                throw new SkyliteRejectedExecutionException("The number of slices [" + numSlices + "] is too large. It must be less than [" + sliceLimit + "]. This limit can be set by changing the [" + IndexSettings.MAX_SLICES_PER_PIT.getKey() + "] index level setting.");
            }
        }
        try {
            QueryBuilder queryBuilder = this.request.getAliasFilter().getQueryBuilder();
            this.aliasFilter = queryBuilder == null ? null : queryBuilder.toQuery((QueryRewriteContext)this.queryShardContext);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        if (this.query == null) {
            this.parsedQuery(ParsedQuery.parsedMatchAllQuery());
        }
        if (this.queryBoost != 1.0f) {
            this.parsedQuery(new ParsedQuery((Query)new BoostQuery(this.query(), this.queryBoost), this.parsedQuery()));
        }
        this.query = this.buildFilteredQuery(this.query);
        if (rewrite) {
            try {
                this.query = this.searcher.rewrite(this.query);
            }
            catch (IOException e) {
                throw new QueryPhaseExecutionException(this.shardTarget, "Failed to rewrite main query", (Throwable)e);
            }
        }
    }

    public Query buildFilteredQuery(Query query) {
        ArrayList<Query> filters = new ArrayList<Query>();
        NestedHelper nestedHelper = new NestedHelper(arg_0 -> ((MapperService)this.mapperService()).getObjectMapper(arg_0), field -> this.mapperService().fieldType(field) != null);
        if (this.mapperService().hasNested() && nestedHelper.mightMatchNestedDocs(query) && (this.aliasFilter == null || nestedHelper.mightMatchNestedDocs(this.aliasFilter))) {
            filters.add(Queries.newNonNestedFilter());
        }
        if (this.aliasFilter != null) {
            filters.add(this.aliasFilter);
        }
        if (this.sliceBuilder != null) {
            Query slicedQuery = this.sliceBuilder.toFilter(this.clusterService, this.request, this.queryShardContext, this.minNodeVersion);
            if (slicedQuery instanceof MatchNoDocsQuery) {
                return slicedQuery;
            }
            filters.add(slicedQuery);
        }
        if (filters.isEmpty()) {
            return query;
        }
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        builder.add(query, BooleanClause.Occur.MUST);
        for (Query filter : filters) {
            builder.add(filter, BooleanClause.Occur.FILTER);
        }
        return builder.build();
    }

    public ShardSearchContextId id() {
        return this.readerContext.id();
    }

    @Override
    public String source() {
        return "search";
    }

    public ShardSearchRequest request() {
        return this.request;
    }

    @Override
    public SearchType searchType() {
        return this.searchType;
    }

    public SearchShardTarget shardTarget() {
        return this.shardTarget;
    }

    public int numberOfShards() {
        return this.request.numberOfShards();
    }

    public ScrollContext scrollContext() {
        return this.readerContext.scrollContext();
    }

    public SearchContextAggregations aggregations() {
        return this.aggregations;
    }

    public SearchContext aggregations(SearchContextAggregations aggregations) {
        this.aggregations = aggregations;
        return this;
    }

    @Override
    public void addSearchExt(SearchExtBuilder searchExtBuilder) {
        this.searchExtBuilders.put(searchExtBuilder.getWriteableName(), searchExtBuilder);
    }

    @Override
    public SearchExtBuilder getSearchExt(String name) {
        return this.searchExtBuilders.get(name);
    }

    @Override
    public SearchHighlightContext highlight() {
        return this.highlight;
    }

    @Override
    public void highlight(SearchHighlightContext highlight) {
        this.highlight = highlight;
    }

    public SuggestionSearchContext suggest() {
        return this.suggest;
    }

    @Override
    public void suggest(SuggestionSearchContext suggest) {
        this.suggest = suggest;
    }

    public List<RescoreContext> rescore() {
        if (this.rescore == null) {
            return Collections.emptyList();
        }
        return this.rescore;
    }

    @Override
    public void addRescore(RescoreContext rescore) {
        if (this.rescore == null) {
            this.rescore = new ArrayList<RescoreContext>();
        }
        this.rescore.add(rescore);
    }

    @Override
    public boolean hasScriptFields() {
        return this.scriptFields != null;
    }

    @Override
    public ScriptFieldsContext scriptFields() {
        if (this.scriptFields == null) {
            this.scriptFields = new ScriptFieldsContext();
        }
        return this.scriptFields;
    }

    @Override
    public boolean sourceRequested() {
        return this.fetchSourceContext != null && this.fetchSourceContext.fetchSource();
    }

    @Override
    public boolean hasFetchSourceContext() {
        return this.fetchSourceContext != null;
    }

    @Override
    public FetchSourceContext fetchSourceContext() {
        return this.fetchSourceContext;
    }

    @Override
    public SearchContext fetchSourceContext(FetchSourceContext fetchSourceContext) {
        this.fetchSourceContext = fetchSourceContext;
        return this;
    }

    @Override
    public FetchDocValuesContext docValuesContext() {
        return this.docValuesContext;
    }

    @Override
    public SearchContext docValuesContext(FetchDocValuesContext docValuesContext) {
        this.docValuesContext = docValuesContext;
        return this;
    }

    @Override
    public FetchFieldsContext fetchFieldsContext() {
        return this.fetchFieldsContext;
    }

    @Override
    public SearchContext fetchFieldsContext(FetchFieldsContext fetchFieldsContext) {
        this.fetchFieldsContext = fetchFieldsContext;
        return this;
    }

    public ContextIndexSearcher searcher() {
        return this.searcher;
    }

    public IndexShard indexShard() {
        return this.indexShard;
    }

    @Override
    public MapperService mapperService() {
        return this.indexService.mapperService();
    }

    public BigArrays bigArrays() {
        return this.bigArrays;
    }

    public BitsetFilterCache bitsetFilterCache() {
        return this.indexService.cache().bitsetFilterCache();
    }

    public TimeValue timeout() {
        return this.timeout;
    }

    public void timeout(TimeValue timeout) {
        this.timeout = timeout;
    }

    public int terminateAfter() {
        return this.terminateAfter;
    }

    public void terminateAfter(int terminateAfter) {
        this.terminateAfter = terminateAfter;
    }

    public SearchContext minimumScore(float minimumScore) {
        this.minimumScore = Float.valueOf(minimumScore);
        return this;
    }

    public Float minimumScore() {
        return this.minimumScore;
    }

    public SearchContext sort(SortAndFormats sort) {
        this.sort = sort;
        return this;
    }

    public SortAndFormats sort() {
        return this.sort;
    }

    public SearchContext trackScores(boolean trackScores) {
        this.trackScores = trackScores;
        return this;
    }

    public boolean trackScores() {
        return this.trackScores;
    }

    public SearchContext trackTotalHitsUpTo(int trackTotalHitsUpTo) {
        this.trackTotalHitsUpTo = trackTotalHitsUpTo;
        return this;
    }

    public int trackTotalHitsUpTo() {
        return this.trackTotalHitsUpTo;
    }

    public SearchContext searchAfter(FieldDoc searchAfter) {
        this.searchAfter = searchAfter;
        return this;
    }

    public boolean lowLevelCancellation() {
        return this.lowLevelCancellation;
    }

    public FieldDoc searchAfter() {
        return this.searchAfter;
    }

    public SearchContext collapse(CollapseContext collapse) {
        this.collapse = collapse;
        return this;
    }

    public CollapseContext collapse() {
        return this.collapse;
    }

    public SearchContext sliceBuilder(SliceBuilder sliceBuilder) {
        this.sliceBuilder = sliceBuilder;
        return this;
    }

    public SearchContext parsedPostFilter(ParsedQuery postFilter) {
        this.postFilter = postFilter;
        return this;
    }

    public ParsedQuery parsedPostFilter() {
        return this.postFilter;
    }

    @Override
    public SearchContext parsedQuery(ParsedQuery query) {
        this.originalQuery = query;
        this.query = query.query();
        return this;
    }

    @Override
    public ParsedQuery parsedQuery() {
        return this.originalQuery;
    }

    public Query query() {
        return this.query;
    }

    public int from() {
        return this.from;
    }

    public SearchContext from(int from) {
        this.from = from;
        return this;
    }

    public int size() {
        return this.size;
    }

    public SearchContext size(int size) {
        this.size = size;
        return this;
    }

    public boolean hasStoredFields() {
        return this.storedFields != null && this.storedFields.fieldNames() != null;
    }

    public StoredFieldsContext storedFieldsContext() {
        return this.storedFields;
    }

    public SearchExecutionContext storedFieldsContext(StoredFieldsContext storedFieldsContext) {
        this.storedFields = storedFieldsContext;
        return this;
    }

    @Override
    public boolean explain() {
        return this.explain;
    }

    @Override
    public void explain(boolean explain) {
        this.explain = explain;
    }

    @Nullable
    public List<String> groupStats() {
        return this.groupStats;
    }

    @Override
    public void groupStats(List<String> groupStats) {
        this.groupStats = groupStats;
    }

    @Override
    public boolean version() {
        return this.version;
    }

    @Override
    public void version(boolean version) {
        this.version = version;
    }

    @Override
    public boolean seqNoAndPrimaryTerm() {
        return this.seqAndPrimaryTerm;
    }

    @Override
    public void seqNoAndPrimaryTerm(boolean seqNoAndPrimaryTerm) {
        this.seqAndPrimaryTerm = seqNoAndPrimaryTerm;
    }

    @Override
    public int[] docIdsToLoad() {
        return this.docIdsToLoad;
    }

    @Override
    public int docIdsToLoadSize() {
        return this.docsIdsToLoadSize;
    }

    @Override
    public SearchContext docIdsToLoad(int[] docIdsToLoad, int docsIdsToLoadSize) {
        this.docIdsToLoad = docIdsToLoad;
        this.docsIdsToLoadSize = docsIdsToLoadSize;
        return this;
    }

    @Override
    public DfsSearchResult dfsResult() {
        return this.dfsResult;
    }

    public QuerySearchResult queryResult() {
        return this.queryResult;
    }

    @Override
    public NestedDocuments getNestedDocuments() {
        return new NestedDocuments(this.indexService.mapperService(), arg_0 -> ((BitsetFilterCache)this.bitsetFilterCache()).getBitSetProducer(arg_0));
    }

    @Override
    public FetchPhase fetchPhase() {
        return this.fetchPhase;
    }

    @Override
    public FetchSearchResult fetchResult() {
        return this.fetchResult;
    }

    public long getRelativeTimeInMillis() {
        return this.relativeTimeSupplier.getAsLong();
    }

    public Map<Class<?>, CollectorManager<? extends Collector, ReduceableSearchResult>> queryCollectorManagers() {
        return this.queryCollectorManagers;
    }

    public QueryShardContext getQueryShardContext() {
        return this.queryShardContext;
    }

    public Profilers getProfilers() {
        return this.profilers;
    }

    public boolean shouldUseConcurrentSearch() {
        assert (this.requestShouldUseConcurrentSearch.get() != null) : "requestShouldUseConcurrentSearch must be set";
        return this.concurrentSearchSettingsEnabled && Boolean.TRUE.equals(this.requestShouldUseConcurrentSearch.get());
    }

    public void evaluateRequestShouldUseConcurrentSearch() {
        if (this.sort != null && this.sort.isSortOnTimeSeriesField()) {
            this.requestShouldUseConcurrentSearch.set((Object)false);
        } else if (this.aggregations() != null && this.aggregations().factories() != null && !this.aggregations().factories().allFactoriesSupportConcurrentSearch()) {
            this.requestShouldUseConcurrentSearch.set((Object)false);
        } else if (this.terminateAfter != 0) {
            this.requestShouldUseConcurrentSearch.set((Object)false);
        } else {
            this.requestShouldUseConcurrentSearch.set((Object)true);
        }
    }

    public void setProfilers(Profilers profilers) {
        this.profilers = profilers;
    }

    public void setTask(SearchShardTask task) {
        this.task = task;
    }

    public SearchShardTask getTask() {
        return this.task;
    }

    @Override
    public boolean isCancelled() {
        return this.task.isCancelled();
    }

    @Override
    public ReaderContext readerContext() {
        return this.readerContext;
    }

    public InternalAggregation.ReduceContext partialOnShard() {
        InternalAggregation.ReduceContext rc = this.requestToAggReduceContextBuilder.apply(this.request.source()).forPartialReduction();
        rc.setSliceLevel(this.shouldUseConcurrentSearch());
        return rc;
    }

    public void setBucketCollectorProcessor(BucketCollectorProcessor bucketCollectorProcessor) {
        this.bucketCollectorProcessor = bucketCollectorProcessor;
    }

    public BucketCollectorProcessor bucketCollectorProcessor() {
        return this.bucketCollectorProcessor;
    }

    private boolean evaluateConcurrentSegmentSearchSettings(Executor concurrentSearchExecutor) {
        if (FeatureFlags.isEnabled((String)"lucenia.experimental.feature.concurrent_segment_search.enabled") && this.clusterService != null && concurrentSearchExecutor != null) {
            return this.indexService.getIndexSettings().getSettings().getAsBoolean(IndexSettings.INDEX_CONCURRENT_SEGMENT_SEARCH_SETTING.getKey(), (Boolean)this.clusterService.getClusterSettings().get(SearchServiceSettings.CLUSTER_CONCURRENT_SEGMENT_SEARCH_SETTING));
        }
        return false;
    }

    public int getTargetMaxSliceCount() {
        if (!this.shouldUseConcurrentSearch()) {
            throw new IllegalStateException("Target slice count should not be used when concurrent search is disabled");
        }
        return (Integer)this.clusterService.getClusterSettings().get(SearchServiceSettings.CONCURRENT_SEGMENT_SEARCH_TARGET_MAX_SLICE_COUNT_SETTING);
    }

    public boolean shouldUseTimeSeriesDescSortOptimization() {
        return this.indexShard.isTimeSeriesDescSortOptimizationEnabled() && this.sort != null && this.sort.isSortOnTimeSeriesField() && !this.sort.sort.getSort()[0].getReverse();
    }
}

