/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.bucket.adjacency;

import io.skylite.common.collect.Tuple;
import io.skylite.core.ParseField;
import io.skylite.core.aggregations.AbstractAggregationBuilder;
import io.skylite.core.aggregations.AggregationBuilder;
import io.skylite.core.aggregations.AggregationContext;
import io.skylite.core.aggregations.AggregationProvider;
import io.skylite.core.aggregations.AggregationRegistry;
import io.skylite.core.aggregations.AggregatorFactories;
import io.skylite.core.aggregations.AggregatorFactory;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.index.IndexSettings;
import io.skylite.core.index.query.QueryBuilder;
import io.skylite.core.index.query.QueryRewriteContext;
import io.skylite.core.index.query.Rewriteable;
import io.skylite.core.xcontent.ContextParser;
import io.skylite.core.xcontent.ObjectParser;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import org.opensearch.search.aggregations.bucket.adjacency.AdjacencyMatrixAggregator;
import org.opensearch.search.aggregations.bucket.adjacency.AdjacencyMatrixAggregatorFactory;
import org.opensearch.search.aggregations.bucket.adjacency.InternalAdjacencyMatrix;

public class AdjacencyMatrixAggregationBuilder
extends AbstractAggregationBuilder<AdjacencyMatrixAggregationBuilder> {
    public static final String NAME = "adjacency_matrix";
    private static final String DEFAULT_SEPARATOR = "&";
    private static final ParseField SEPARATOR_FIELD = new ParseField("separator", new String[0]);
    private static final ParseField FILTERS_FIELD = new ParseField("filters", new String[0]);
    private List<AdjacencyMatrixAggregator.KeyedFilter> filters;
    private String separator = "&";
    private static final ObjectParser<AdjacencyMatrixAggregationBuilder, String> PARSER = ObjectParser.fromBuilder((String)"adjacency_matrix", AdjacencyMatrixAggregationBuilder::new);

    public static AggregationBuilder parse(XContentParser parser, String name) throws IOException {
        AdjacencyMatrixAggregationBuilder result = (AdjacencyMatrixAggregationBuilder)((Object)PARSER.parse(parser, (Object)name));
        result.checkConsistency();
        return result;
    }

    protected AdjacencyMatrixAggregationBuilder(String name) {
        super(name);
    }

    public AdjacencyMatrixAggregationBuilder(String name, Map<String, QueryBuilder> filters) {
        this(name, DEFAULT_SEPARATOR, filters);
    }

    protected AdjacencyMatrixAggregationBuilder(AdjacencyMatrixAggregationBuilder clone, AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metadata) {
        super((AbstractAggregationBuilder)clone, factoriesBuilder, metadata);
        this.filters = new ArrayList<AdjacencyMatrixAggregator.KeyedFilter>(clone.filters);
        this.separator = clone.separator;
    }

    protected AggregationBuilder shallowCopy(AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metadata) {
        return new AdjacencyMatrixAggregationBuilder(this, factoriesBuilder, metadata);
    }

    public AdjacencyMatrixAggregationBuilder(String name, String separator, Map<String, QueryBuilder> filters) {
        super(name);
        this.separator = separator;
        this.setFiltersAsMap(filters);
    }

    public AdjacencyMatrixAggregationBuilder(StreamInput in) throws IOException {
        super(in);
        int filtersSize = in.readVInt();
        this.separator = in.readString();
        this.filters = new ArrayList<AdjacencyMatrixAggregator.KeyedFilter>(filtersSize);
        for (int i = 0; i < filtersSize; ++i) {
            this.filters.add(new AdjacencyMatrixAggregator.KeyedFilter(in));
        }
    }

    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeVInt(this.filters.size());
        out.writeString(this.separator);
        for (AdjacencyMatrixAggregator.KeyedFilter keyedFilter : this.filters) {
            keyedFilter.writeTo(out);
        }
    }

    private void checkConsistency() {
        if (this.filters == null || this.filters.size() == 0) {
            throw new IllegalStateException("[" + this.name + "] is missing : " + FILTERS_FIELD.getPreferredName() + " parameter");
        }
    }

    private void setFiltersAsMap(Map<String, QueryBuilder> filters) {
        this.filters = new ArrayList<AdjacencyMatrixAggregator.KeyedFilter>(filters.size());
        for (Map.Entry<String, QueryBuilder> kv : filters.entrySet()) {
            this.filters.add(new AdjacencyMatrixAggregator.KeyedFilter(kv.getKey(), kv.getValue()));
        }
        Collections.sort(this.filters, Comparator.comparing(AdjacencyMatrixAggregator.KeyedFilter::key));
    }

    private AdjacencyMatrixAggregationBuilder setFiltersAsList(List<AdjacencyMatrixAggregator.KeyedFilter> filters) {
        this.filters = new ArrayList<AdjacencyMatrixAggregator.KeyedFilter>(filters);
        Collections.sort(this.filters, Comparator.comparing(AdjacencyMatrixAggregator.KeyedFilter::key));
        return this;
    }

    public AdjacencyMatrixAggregationBuilder separator(String separator) {
        if (separator == null) {
            throw new IllegalArgumentException("[separator] must not be null: [" + this.name + "]");
        }
        this.separator = separator;
        return this;
    }

    public String separator() {
        return this.separator;
    }

    public Map<String, QueryBuilder> filters() {
        HashMap<String, QueryBuilder> result = new HashMap<String, QueryBuilder>(this.filters.size());
        for (AdjacencyMatrixAggregator.KeyedFilter keyedFilter : this.filters) {
            result.put(keyedFilter.key(), keyedFilter.filter());
        }
        return result;
    }

    protected AdjacencyMatrixAggregationBuilder doRewrite(QueryRewriteContext queryShardContext) throws IOException {
        boolean modified = false;
        ArrayList<AdjacencyMatrixAggregator.KeyedFilter> rewrittenFilters = new ArrayList<AdjacencyMatrixAggregator.KeyedFilter>(this.filters.size());
        for (AdjacencyMatrixAggregator.KeyedFilter kf : this.filters) {
            QueryBuilder rewritten = (QueryBuilder)Rewriteable.rewrite((Rewriteable)kf.filter(), (QueryRewriteContext)queryShardContext);
            modified = modified || rewritten != kf.filter();
            rewrittenFilters.add(new AdjacencyMatrixAggregator.KeyedFilter(kf.key(), rewritten));
        }
        if (modified) {
            return new AdjacencyMatrixAggregationBuilder(this.name).separator(this.separator).setFiltersAsList(rewrittenFilters);
        }
        return this;
    }

    protected AggregatorFactory doBuild(AggregationContext context, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder) throws IOException {
        int maxFilters = context.getIndexSettings().getMaxAdjacencyMatrixFilters();
        if (this.filters.size() > maxFilters) {
            throw new IllegalArgumentException("Number of filters is too large, must be less than or equal to: [" + maxFilters + "] but was [" + this.filters.size() + "].This limit can be set by changing the [" + IndexSettings.MAX_ADJACENCY_MATRIX_FILTERS_SETTING.getKey() + "] index level setting.");
        }
        return new AdjacencyMatrixAggregatorFactory(this.name, this.filters, this.separator, context, parent, subFactoriesBuilder, this.metadata);
    }

    public AggregationBuilder.BucketCardinality bucketCardinality() {
        return AggregationBuilder.BucketCardinality.MANY;
    }

    protected XContentBuilder internalXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(SEPARATOR_FIELD.getPreferredName(), this.separator);
        builder.startObject(AdjacencyMatrixAggregator.FILTERS_FIELD.getPreferredName());
        for (AdjacencyMatrixAggregator.KeyedFilter keyedFilter : this.filters) {
            builder.field(keyedFilter.key(), (ToXContent)keyedFilter.filter());
        }
        builder.endObject();
        builder.endObject();
        return builder;
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.filters, this.separator);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        AdjacencyMatrixAggregationBuilder other = (AdjacencyMatrixAggregationBuilder)((Object)obj);
        return Objects.equals(this.filters, other.filters) && Objects.equals(this.separator, other.separator);
    }

    public String getType() {
        return NAME;
    }

    static {
        PARSER.declareString(AdjacencyMatrixAggregationBuilder::separator, SEPARATOR_FIELD);
        PARSER.declareNamedObjects(AdjacencyMatrixAggregationBuilder::setFiltersAsList, AdjacencyMatrixAggregator.KeyedFilter.PARSER, FILTERS_FIELD);
    }

    public static class AggregationProviderImpl
    implements AggregationProvider {
        public AggregationProvider.Type getType() {
            return AggregationProvider.Type.BUCKET;
        }

        public String getName() {
            return AdjacencyMatrixAggregationBuilder.NAME;
        }

        public Writeable.Reader getReader() {
            return AdjacencyMatrixAggregationBuilder::new;
        }

        public List<Tuple<Optional<String>, Writeable.Reader>> getResultReaders() {
            return Collections.singletonList(new Tuple(Optional.empty(), InternalAdjacencyMatrix::new));
        }

        public ContextParser<String, AggregationBuilder> getParser() {
            return AdjacencyMatrixAggregationBuilder::parse;
        }

        public Consumer<AggregationRegistry.Builder> getAggregatorRegistrar() {
            return null;
        }
    }
}

