/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.bucket.adjacency;

import io.skylite.core.aggregations.AggregationContext;
import io.skylite.core.aggregations.Aggregator;
import io.skylite.core.aggregations.AggregatorFactories;
import io.skylite.core.aggregations.AggregatorFactory;
import io.skylite.core.aggregations.CardinalityUpperBound;
import io.skylite.core.search.internal.SearchExecutionContext;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Weight;
import org.opensearch.search.aggregations.bucket.adjacency.AdjacencyMatrixAggregator;

public class AdjacencyMatrixAggregatorFactory
extends AggregatorFactory {
    private final String[] keys;
    private final Weight[] weights;
    private final String separator;

    public AdjacencyMatrixAggregatorFactory(String name, List<AdjacencyMatrixAggregator.KeyedFilter> filters, String separator, AggregationContext context, AggregatorFactory parent, AggregatorFactories.Builder subFactories, Map<String, Object> metadata) throws IOException {
        super(name, context, parent, subFactories, metadata);
        IndexSearcher contextSearcher = context.searcher();
        this.separator = separator;
        this.weights = new Weight[filters.size()];
        this.keys = new String[filters.size()];
        for (int i = 0; i < filters.size(); ++i) {
            AdjacencyMatrixAggregator.KeyedFilter keyedFilter = filters.get(i);
            this.keys[i] = keyedFilter.key();
            Query filter = context.buildQuery(keyedFilter.filter());
            this.weights[i] = contextSearcher.createWeight(contextSearcher.rewrite(filter), ScoreMode.COMPLETE_NO_SCORES, 1.0f);
        }
    }

    public Aggregator createInternal(SearchExecutionContext searchContext, Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        return new AdjacencyMatrixAggregator(this.name, this.factories, this.separator, this.keys, this.weights, searchContext, parent, metadata);
    }

    protected boolean supportsConcurrentSegmentSearch() {
        return true;
    }
}

