/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.bucket.composite;

import io.skylite.common.Nullable;
import io.skylite.core.aggregations.values.ValuesSource;
import io.skylite.core.common.util.BigArrays;
import io.skylite.core.index.fielddata.DocValueFormat;
import io.skylite.core.mapper.MappedFieldType;
import io.skylite.core.search.sort.SortOrder;
import java.util.function.LongConsumer;
import org.apache.lucene.index.IndexReader;
import org.opensearch.search.aggregations.bucket.composite.SingleDimensionValuesSource;
import org.opensearch.search.aggregations.bucket.missing.MissingOrder;

public class CompositeValuesSourceConfig {
    private final String name;
    @Nullable
    private final MappedFieldType fieldType;
    private final ValuesSource vs;
    private final DocValueFormat format;
    private final int reverseMul;
    private final boolean missingBucket;
    private final MissingOrder missingOrder;
    private final boolean hasScript;
    private final SingleDimensionValuesSourceProvider singleDimensionValuesSourceProvider;

    public CompositeValuesSourceConfig(String name, @Nullable MappedFieldType fieldType, ValuesSource vs, DocValueFormat format, SortOrder order, boolean missingBucket, MissingOrder missingOrder, boolean hasScript, SingleDimensionValuesSourceProvider singleDimensionValuesSourceProvider) {
        this.name = name;
        this.fieldType = fieldType;
        this.vs = vs;
        this.format = format;
        this.reverseMul = order == SortOrder.ASC ? 1 : -1;
        this.missingBucket = missingBucket;
        this.hasScript = hasScript;
        this.singleDimensionValuesSourceProvider = singleDimensionValuesSourceProvider;
        this.missingOrder = missingOrder;
    }

    protected String name() {
        return this.name;
    }

    public MappedFieldType fieldType() {
        return this.fieldType;
    }

    public ValuesSource valuesSource() {
        return this.vs;
    }

    public DocValueFormat format() {
        return this.format;
    }

    public boolean missingBucket() {
        return this.missingBucket;
    }

    public MissingOrder missingOrder() {
        return this.missingOrder;
    }

    protected boolean hasScript() {
        return this.hasScript;
    }

    public int reverseMul() {
        assert (this.reverseMul == -1 || this.reverseMul == 1);
        return this.reverseMul;
    }

    SingleDimensionValuesSource<?> createValuesSource(BigArrays bigArrays, IndexReader reader, int size, LongConsumer addRequestCircuitBreakerBytes) {
        return this.singleDimensionValuesSourceProvider.createValuesSource(bigArrays, reader, size, addRequestCircuitBreakerBytes, this);
    }

    @FunctionalInterface
    public static interface SingleDimensionValuesSourceProvider {
        public SingleDimensionValuesSource<?> createValuesSource(BigArrays var1, IndexReader var2, int var3, LongConsumer var4, CompositeValuesSourceConfig var5);
    }
}

