/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.bucket.composite;

import io.skylite.common.CheckedFunction;
import io.skylite.common.lease.Releasable;
import io.skylite.common.lease.Releasables;
import io.skylite.core.aggregations.LeafBucketCollector;
import io.skylite.core.common.util.BigArrays;
import io.skylite.core.common.util.LongArray;
import io.skylite.core.index.fielddata.DocValueFormat;
import io.skylite.core.mapper.MappedFieldType;
import io.skylite.core.mapper.StringFieldType;
import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.opensearch.search.aggregations.bucket.composite.SingleDimensionValuesSource;
import org.opensearch.search.aggregations.bucket.composite.SortedDocsProducer;
import org.opensearch.search.aggregations.bucket.composite.TermsSortedDocsProducer;
import org.opensearch.search.aggregations.bucket.missing.MissingOrder;

class GlobalOrdinalValuesSource
extends SingleDimensionValuesSource<BytesRef> {
    private final CheckedFunction<LeafReaderContext, SortedSetDocValues, IOException> docValuesFunc;
    private LongArray values;
    private SortedSetDocValues lookup;
    private long currentValue;
    private Long afterValueGlobalOrd;
    private boolean isTopValueInsertionPoint;
    private long lastLookupOrd = -1L;
    private BytesRef lastLookupValue;

    GlobalOrdinalValuesSource(BigArrays bigArrays, MappedFieldType type, CheckedFunction<LeafReaderContext, SortedSetDocValues, IOException> docValuesFunc, DocValueFormat format, boolean missingBucket, MissingOrder missingOrder, int size, int reverseMul) {
        super(bigArrays, format, type, missingBucket, missingOrder, size, reverseMul);
        this.docValuesFunc = docValuesFunc;
        this.values = bigArrays.newLongArray((long)Math.min(size, 100), false);
    }

    @Override
    void copyCurrent(int slot) {
        this.values = this.bigArrays.grow(this.values, (long)(slot + 1));
        this.values.set((long)slot, this.currentValue);
    }

    @Override
    int compare(int from, int to) {
        int result;
        if (this.missingBucket && !MissingOrder.unknownOrder(result = this.missingOrder.compare(() -> this.values.get((long)from) == -1L, () -> this.values.get((long)to) == -1L, this.reverseMul))) {
            return result;
        }
        return Long.compare(this.values.get((long)from), this.values.get((long)to)) * this.reverseMul;
    }

    @Override
    int compareCurrent(int slot) {
        int result;
        if (this.missingBucket && !MissingOrder.unknownOrder(result = this.missingOrder.compare(() -> this.currentValue == -1L, () -> this.values.get((long)slot) == -1L, this.reverseMul))) {
            return result;
        }
        return Long.compare(this.currentValue, this.values.get((long)slot)) * this.reverseMul;
    }

    @Override
    int compareCurrentWithAfter() {
        int result;
        if (this.missingBucket && !MissingOrder.unknownOrder(result = this.missingOrder.compare(() -> this.currentValue == -1L, () -> this.afterValueGlobalOrd == -1L, this.reverseMul))) {
            return result;
        }
        int cmp = Long.compare(this.currentValue, this.afterValueGlobalOrd);
        if (cmp == 0 && this.isTopValueInsertionPoint) {
            return this.reverseMul;
        }
        return cmp * this.reverseMul;
    }

    @Override
    int hashCode(int slot) {
        return Long.hashCode(this.values.get((long)slot));
    }

    @Override
    int hashCodeCurrent() {
        return Long.hashCode(this.currentValue);
    }

    @Override
    void setAfter(Comparable value) {
        if (this.missingBucket && value == null) {
            this.afterValue = null;
            this.afterValueGlobalOrd = -1L;
        } else if (value.getClass() == String.class) {
            this.afterValue = this.format.parseBytesRef(value.toString());
        } else {
            throw new IllegalArgumentException("invalid value, expected string, got " + value.getClass().getSimpleName());
        }
    }

    @Override
    BytesRef toComparable(int slot) throws IOException {
        long globalOrd = this.values.get((long)slot);
        if (this.missingBucket && globalOrd == -1L) {
            return null;
        }
        if (globalOrd == this.lastLookupOrd) {
            return this.lastLookupValue;
        }
        this.lastLookupOrd = globalOrd;
        this.lastLookupValue = BytesRef.deepCopyOf((BytesRef)this.lookup.lookupOrd(this.values.get((long)slot)));
        return this.lastLookupValue;
    }

    @Override
    LeafBucketCollector getLeafCollector(LeafReaderContext context, final LeafBucketCollector next) throws IOException {
        final SortedSetDocValues dvs = (SortedSetDocValues)this.docValuesFunc.apply((Object)context);
        if (this.lookup == null) {
            this.initLookup(dvs);
        }
        return new LeafBucketCollector(){

            public void collect(int doc, long bucket) throws IOException {
                if (dvs.advanceExact(doc)) {
                    for (int i = 0; i < dvs.docValueCount(); ++i) {
                        GlobalOrdinalValuesSource.this.currentValue = dvs.nextOrd();
                        next.collect(doc, bucket);
                    }
                } else if (GlobalOrdinalValuesSource.this.missingBucket) {
                    GlobalOrdinalValuesSource.this.currentValue = -1L;
                    next.collect(doc, bucket);
                }
            }
        };
    }

    @Override
    LeafBucketCollector getLeafCollector(Comparable value, LeafReaderContext context, final LeafBucketCollector next) throws IOException {
        if (value.getClass() != BytesRef.class) {
            throw new IllegalArgumentException("Expected BytesRef, got " + String.valueOf(value.getClass()));
        }
        final BytesRef term = (BytesRef)value;
        final SortedSetDocValues dvs = (SortedSetDocValues)this.docValuesFunc.apply((Object)context);
        if (this.lookup == null) {
            this.initLookup(dvs);
        }
        return new LeafBucketCollector(){
            boolean currentValueIsSet = false;

            public void collect(int doc, long bucket) throws IOException {
                if (!this.currentValueIsSet && dvs.advanceExact(doc)) {
                    for (int i = 0; i < dvs.docValueCount(); ++i) {
                        long ord = dvs.nextOrd();
                        if (!term.equals((Object)GlobalOrdinalValuesSource.this.lookup.lookupOrd(ord))) continue;
                        this.currentValueIsSet = true;
                        GlobalOrdinalValuesSource.this.currentValue = ord;
                        break;
                    }
                }
                assert (this.currentValueIsSet);
                next.collect(doc, bucket);
            }
        };
    }

    @Override
    SortedDocsProducer createSortedDocsProducerOrNull(IndexReader reader, Query query) {
        if (!this.checkIfSortedDocsIsApplicable(reader, this.fieldType) || !(this.fieldType instanceof StringFieldType) || query != null && query.getClass() != MatchAllDocsQuery.class) {
            return null;
        }
        return new TermsSortedDocsProducer(this.fieldType.name());
    }

    public void close() {
        Releasables.close((Releasable)this.values);
    }

    private void initLookup(SortedSetDocValues dvs) throws IOException {
        this.lookup = dvs;
        if (this.afterValue != null && this.afterValueGlobalOrd == null) {
            this.afterValueGlobalOrd = this.lookup.lookupTerm((BytesRef)this.afterValue);
            if (this.afterValueGlobalOrd < 0L) {
                this.afterValueGlobalOrd = -this.afterValueGlobalOrd.longValue() - 1L;
                this.isTopValueInsertionPoint = true;
            }
        }
    }
}

