/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.bucket.filter;

import io.skylite.common.collect.Tuple;
import io.skylite.core.aggregations.AbstractAggregationBuilder;
import io.skylite.core.aggregations.AggregationBuilder;
import io.skylite.core.aggregations.AggregationContext;
import io.skylite.core.aggregations.AggregationProvider;
import io.skylite.core.aggregations.AggregationRegistry;
import io.skylite.core.aggregations.AggregatorFactories;
import io.skylite.core.aggregations.AggregatorFactory;
import io.skylite.core.common.io.stream.NamedWriteable;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.index.query.QueryBuilder;
import io.skylite.core.index.query.QueryRewriteContext;
import io.skylite.core.index.query.Rewriteable;
import io.skylite.core.xcontent.ContextParser;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import org.opensearch.search.aggregations.bucket.filter.FilterAggregatorFactory;
import org.opensearch.search.aggregations.bucket.filter.InternalFilter;

public class FilterAggregationBuilder
extends AbstractAggregationBuilder<FilterAggregationBuilder> {
    public static final String NAME = "filter";
    private final QueryBuilder filter;

    public FilterAggregationBuilder(String name, QueryBuilder filter) {
        super(name);
        if (filter == null) {
            throw new IllegalArgumentException("[filter] must not be null: [" + name + "]");
        }
        this.filter = filter;
    }

    protected FilterAggregationBuilder(FilterAggregationBuilder clone, AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metadata) {
        super((AbstractAggregationBuilder)clone, factoriesBuilder, metadata);
        this.filter = clone.filter;
    }

    protected AggregationBuilder shallowCopy(AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metadata) {
        return new FilterAggregationBuilder(this, factoriesBuilder, metadata);
    }

    public FilterAggregationBuilder(StreamInput in) throws IOException {
        super(in);
        this.filter = (QueryBuilder)in.readNamedWriteable(QueryBuilder.class);
    }

    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeNamedWriteable((NamedWriteable)this.filter);
    }

    public AggregationBuilder.BucketCardinality bucketCardinality() {
        return AggregationBuilder.BucketCardinality.ONE;
    }

    protected AggregationBuilder doRewrite(QueryRewriteContext queryShardContext) throws IOException {
        QueryBuilder result = (QueryBuilder)Rewriteable.rewrite((Rewriteable)this.filter, (QueryRewriteContext)queryShardContext);
        if (result != this.filter) {
            return new FilterAggregationBuilder(this.getName(), result);
        }
        return this;
    }

    protected AggregatorFactory doBuild(AggregationContext context, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder) throws IOException {
        return new FilterAggregatorFactory(this.name, this.filter, context, parent, subFactoriesBuilder, this.metadata);
    }

    protected XContentBuilder internalXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.filter != null) {
            this.filter.toXContent(builder, params);
        }
        return builder;
    }

    public static FilterAggregationBuilder parse(XContentParser parser, String aggregationName) throws IOException {
        QueryBuilder filter = QueryBuilder.parseInnerQueryBuilder((XContentParser)parser);
        return new FilterAggregationBuilder(aggregationName, filter);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.filter);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        FilterAggregationBuilder other = (FilterAggregationBuilder)((Object)obj);
        return Objects.equals(this.filter, other.filter);
    }

    public String getType() {
        return NAME;
    }

    public QueryBuilder getFilter() {
        return this.filter;
    }

    public static class AggregationProviderImpl
    implements AggregationProvider {
        public AggregationProvider.Type getType() {
            return AggregationProvider.Type.BUCKET;
        }

        public String getName() {
            return FilterAggregationBuilder.NAME;
        }

        public Writeable.Reader getReader() {
            return FilterAggregationBuilder::new;
        }

        public List<Tuple<Optional<String>, Writeable.Reader>> getResultReaders() {
            return Collections.singletonList(new Tuple(Optional.empty(), InternalFilter::new));
        }

        public ContextParser<String, FilterAggregationBuilder> getParser() {
            return FilterAggregationBuilder::parse;
        }

        public Consumer<AggregationRegistry.Builder> getAggregatorRegistrar() {
            return null;
        }
    }
}

