/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.bucket.filter;

import io.skylite.core.aggregations.AggregationContext;
import io.skylite.core.aggregations.AggregationInitializationException;
import io.skylite.core.aggregations.Aggregator;
import io.skylite.core.aggregations.AggregatorFactories;
import io.skylite.core.aggregations.AggregatorFactory;
import io.skylite.core.aggregations.CardinalityUpperBound;
import io.skylite.core.index.query.QueryBuilder;
import io.skylite.core.search.internal.SearchExecutionContext;
import java.io.IOException;
import java.util.Map;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Weight;
import org.opensearch.search.aggregations.bucket.filter.FilterAggregator;

public class FilterAggregatorFactory
extends AggregatorFactory {
    private Weight weight;
    private final Query filter;

    public FilterAggregatorFactory(String name, QueryBuilder filterBuilder, AggregationContext context, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder, Map<String, Object> metadata) throws IOException {
        super(name, context, parent, subFactoriesBuilder, metadata);
        this.filter = context.buildQuery(filterBuilder);
    }

    public Weight getWeight() {
        if (this.weight == null) {
            IndexSearcher contextSearcher = this.context.searcher();
            try {
                this.weight = contextSearcher.createWeight(contextSearcher.rewrite(this.filter), ScoreMode.COMPLETE_NO_SCORES, 1.0f);
            }
            catch (IOException e) {
                throw new AggregationInitializationException("Failed to initialse filter", (Throwable)e);
            }
        }
        return this.weight;
    }

    public Aggregator createInternal(SearchExecutionContext searchContext, Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        return new FilterAggregator(this.name, () -> this.getWeight(), this.factories, searchContext, parent, cardinality, metadata);
    }

    protected boolean supportsConcurrentSegmentSearch() {
        return true;
    }
}

