/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.bucket.filter;

import io.skylite.core.aggregations.AggregationContext;
import io.skylite.core.aggregations.AggregationInitializationException;
import io.skylite.core.aggregations.Aggregator;
import io.skylite.core.aggregations.AggregatorFactories;
import io.skylite.core.aggregations.AggregatorFactory;
import io.skylite.core.aggregations.CardinalityUpperBound;
import io.skylite.core.search.internal.ContextIndexSearcher;
import io.skylite.core.search.internal.SearchExecutionContext;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Weight;
import org.opensearch.search.aggregations.bucket.filter.FiltersAggregator;
import org.opensearch.search.internal.SearchContext;

public class FiltersAggregatorFactory
extends AggregatorFactory {
    private final String[] keys;
    private final Query[] filters;
    private volatile Weight[] weights;
    private final boolean keyed;
    private final boolean otherBucket;
    private final String otherBucketKey;

    public FiltersAggregatorFactory(String name, List<FiltersAggregator.KeyedFilter> filters, boolean keyed, boolean otherBucket, String otherBucketKey, AggregationContext context, AggregatorFactory parent, AggregatorFactories.Builder subFactories, Map<String, Object> metadata) throws IOException {
        super(name, context, parent, subFactories, metadata);
        this.keyed = keyed;
        this.otherBucket = otherBucket;
        this.otherBucketKey = otherBucketKey;
        this.keys = new String[filters.size()];
        this.filters = new Query[filters.size()];
        for (int i = 0; i < filters.size(); ++i) {
            FiltersAggregator.KeyedFilter keyedFilter = filters.get(i);
            this.keys[i] = keyedFilter.key();
            this.filters[i] = context.buildQuery(keyedFilter.filter());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Weight[] getWeights(SearchContext searchContext) {
        if (this.weights != null) {
            return this.weights;
        }
        FiltersAggregatorFactory filtersAggregatorFactory = this;
        synchronized (filtersAggregatorFactory) {
            if (this.weights == null) {
                try {
                    Weight[] filterWeights = new Weight[this.filters.length];
                    ContextIndexSearcher contextSearcher = searchContext.searcher();
                    for (int i = 0; i < this.filters.length; ++i) {
                        filterWeights[i] = contextSearcher.createWeight(contextSearcher.rewrite(this.filters[i]), ScoreMode.COMPLETE_NO_SCORES, 1.0f);
                    }
                    this.weights = filterWeights;
                }
                catch (IOException e) {
                    throw new AggregationInitializationException("Failed to initialze filters for aggregation [" + this.name() + "]", (Throwable)e);
                }
            }
        }
        return this.weights;
    }

    public Aggregator createInternal(SearchExecutionContext searchContext, Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        return new FiltersAggregator(this.name, this.factories, this.keys, () -> this.getWeights((SearchContext)searchContext), this.keyed, this.otherBucket ? this.otherBucketKey : null, searchContext, parent, cardinality, metadata);
    }

    protected boolean supportsConcurrentSegmentSearch() {
        return true;
    }
}

