/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.bucket.global;

import io.skylite.core.aggregations.AggregationContext;
import io.skylite.core.aggregations.AggregationExecutionException;
import io.skylite.core.aggregations.Aggregator;
import io.skylite.core.aggregations.AggregatorFactories;
import io.skylite.core.aggregations.AggregatorFactory;
import io.skylite.core.aggregations.CardinalityUpperBound;
import io.skylite.core.search.internal.SearchExecutionContext;
import java.io.IOException;
import java.util.Map;
import org.opensearch.search.aggregations.bucket.global.GlobalAggregator;

public class GlobalAggregatorFactory
extends AggregatorFactory {
    public GlobalAggregatorFactory(String name, AggregationContext context, AggregatorFactory parent, AggregatorFactories.Builder subFactories, Map<String, Object> metadata) throws IOException {
        super(name, context, parent, subFactories, metadata);
    }

    public Aggregator createInternal(SearchExecutionContext searchContext, Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        if (parent != null) {
            throw new AggregationExecutionException("Aggregation [" + parent.name() + "] cannot have a global sub-aggregation [" + this.name + "]. Global aggregations can only be defined as top level aggregations");
        }
        if (cardinality != CardinalityUpperBound.ONE) {
            throw new AggregationExecutionException("Aggregation [" + this.name() + "] must have cardinality 1 but was [" + String.valueOf(cardinality) + "]");
        }
        return new GlobalAggregator(this.name, this.factories, searchContext, metadata);
    }

    protected boolean supportsConcurrentSegmentSearch() {
        return true;
    }

    public boolean isGlobalAggregation() {
        return true;
    }
}

