/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.bucket.histogram;

import io.skylite.common.collect.Tuple;
import io.skylite.core.ParseField;
import io.skylite.core.aggregations.AggregationBuilder;
import io.skylite.core.aggregations.AggregationContext;
import io.skylite.core.aggregations.AggregationProvider;
import io.skylite.core.aggregations.AggregationRegistry;
import io.skylite.core.aggregations.AggregatorFactories;
import io.skylite.core.aggregations.AggregatorFactory;
import io.skylite.core.aggregations.BucketOrder;
import io.skylite.core.aggregations.InternalOrder;
import io.skylite.core.aggregations.values.CoreValuesSourceType;
import io.skylite.core.aggregations.values.ValuesSourceConfig;
import io.skylite.core.aggregations.values.ValuesSourceType;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.xcontent.ObjectParser;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import org.opensearch.search.aggregations.bucket.histogram.DoubleBounds;
import org.opensearch.search.aggregations.bucket.histogram.Histogram;
import org.opensearch.search.aggregations.bucket.histogram.HistogramAggregatorFactory;
import org.opensearch.search.aggregations.bucket.histogram.HistogramAggregatorSupplier;
import org.opensearch.search.aggregations.bucket.histogram.InternalHistogram;
import org.opensearch.search.aggregations.support.ValuesSourceAggregationBuilder;
import org.opensearch.search.aggregations.support.ValuesSourceAggregatorFactory;

public class HistogramAggregationBuilder
extends ValuesSourceAggregationBuilder<HistogramAggregationBuilder> {
    public static final String NAME = "histogram";
    public static final AggregationRegistry.RegistryKey<HistogramAggregatorSupplier> REGISTRY_KEY = new AggregationRegistry.RegistryKey("histogram", HistogramAggregatorSupplier.class);
    private static final ObjectParser<double[], Void> EXTENDED_BOUNDS_PARSER = new ObjectParser(Histogram.EXTENDED_BOUNDS_FIELD.getPreferredName(), () -> new double[]{Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY});
    public static final ObjectParser<HistogramAggregationBuilder, String> PARSER;
    private double interval;
    private double offset = 0.0;
    private DoubleBounds extendedBounds;
    private DoubleBounds hardBounds;
    private BucketOrder order = BucketOrder.key((boolean)true);
    private boolean keyed = false;
    private long minDocCount = 0L;

    public static void registerAggregators(AggregationRegistry.Builder builder) {
        HistogramAggregatorFactory.registerAggregators(builder);
    }

    @Override
    protected ValuesSourceType defaultValueSourceType() {
        return CoreValuesSourceType.NUMERIC;
    }

    public HistogramAggregationBuilder(String name) {
        super(name);
    }

    protected HistogramAggregationBuilder(HistogramAggregationBuilder clone, AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metadata) {
        super(clone, factoriesBuilder, metadata);
        this.interval = clone.interval;
        this.offset = clone.offset;
        this.extendedBounds = clone.extendedBounds;
        this.hardBounds = clone.hardBounds;
        this.order = clone.order;
        this.keyed = clone.keyed;
        this.minDocCount = clone.minDocCount;
    }

    protected AggregationBuilder shallowCopy(AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metadata) {
        return new HistogramAggregationBuilder(this, factoriesBuilder, metadata);
    }

    public HistogramAggregationBuilder(StreamInput in) throws IOException {
        super(in);
        this.order = InternalOrder.Streams.readHistogramOrder((StreamInput)in, (boolean)true);
        this.keyed = in.readBoolean();
        this.minDocCount = in.readVLong();
        this.interval = in.readDouble();
        this.offset = in.readDouble();
        this.extendedBounds = (DoubleBounds)in.readOptionalWriteable(DoubleBounds::new);
        this.hardBounds = (DoubleBounds)in.readOptionalWriteable(DoubleBounds::new);
    }

    @Override
    protected void innerWriteTo(StreamOutput out) throws IOException {
        InternalOrder.Streams.writeHistogramOrder((BucketOrder)this.order, (StreamOutput)out, (boolean)true);
        out.writeBoolean(this.keyed);
        out.writeVLong(this.minDocCount);
        out.writeDouble(this.interval);
        out.writeDouble(this.offset);
        out.writeOptionalWriteable((Writeable)this.extendedBounds);
        out.writeOptionalWriteable((Writeable)this.hardBounds);
    }

    public double interval() {
        return this.interval;
    }

    public HistogramAggregationBuilder interval(double interval) {
        if (interval <= 0.0) {
            throw new IllegalArgumentException("[interval] must be >0 for histogram aggregation [" + this.name + "]");
        }
        this.interval = interval;
        return this;
    }

    public double offset() {
        return this.offset;
    }

    public HistogramAggregationBuilder offset(double offset) {
        this.offset = offset;
        return this;
    }

    public double minBound() {
        return DoubleBounds.getEffectiveMin(this.extendedBounds);
    }

    public double maxBound() {
        return DoubleBounds.getEffectiveMax(this.extendedBounds);
    }

    protected DoubleBounds extendedBounds() {
        return this.extendedBounds;
    }

    public HistogramAggregationBuilder extendedBounds(double minBound, double maxBound) {
        return this.extendedBounds(new DoubleBounds(minBound, maxBound));
    }

    public HistogramAggregationBuilder extendedBounds(DoubleBounds extendedBounds) {
        if (extendedBounds == null) {
            throw new IllegalArgumentException("[extended_bounds] must not be null: [" + this.name + "]");
        }
        this.extendedBounds = extendedBounds;
        return this;
    }

    public HistogramAggregationBuilder hardBounds(DoubleBounds hardBounds) {
        if (hardBounds == null) {
            throw new IllegalArgumentException("[hardBounds] must not be null: [" + this.name + "]");
        }
        this.hardBounds = hardBounds;
        return this;
    }

    public BucketOrder order() {
        return this.order;
    }

    public HistogramAggregationBuilder order(BucketOrder order) {
        if (order == null) {
            throw new IllegalArgumentException("[order] must not be null: [" + this.name + "]");
        }
        this.order = order instanceof InternalOrder.CompoundOrder || InternalOrder.isKeyOrder((BucketOrder)order) ? order : BucketOrder.compound((BucketOrder[])new BucketOrder[]{order});
        return this;
    }

    public HistogramAggregationBuilder order(List<BucketOrder> orders) {
        if (orders == null) {
            throw new IllegalArgumentException("[orders] must not be null: [" + this.name + "]");
        }
        this.order(orders.size() > 1 ? BucketOrder.compound(orders) : orders.get(0));
        return this;
    }

    public boolean keyed() {
        return this.keyed;
    }

    public HistogramAggregationBuilder keyed(boolean keyed) {
        this.keyed = keyed;
        return this;
    }

    public long minDocCount() {
        return this.minDocCount;
    }

    public HistogramAggregationBuilder minDocCount(long minDocCount) {
        if (minDocCount < 0L) {
            throw new IllegalArgumentException("[minDocCount] must be greater than or equal to 0. Found [" + minDocCount + "] in [" + this.name + "]");
        }
        this.minDocCount = minDocCount;
        return this;
    }

    public AggregationBuilder.BucketCardinality bucketCardinality() {
        return AggregationBuilder.BucketCardinality.MANY;
    }

    @Override
    protected XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(Histogram.INTERVAL_FIELD.getPreferredName(), this.interval);
        builder.field(Histogram.OFFSET_FIELD.getPreferredName(), this.offset);
        if (this.order != null) {
            builder.field(Histogram.ORDER_FIELD.getPreferredName());
            this.order.toXContent(builder, params);
        }
        builder.field(Histogram.KEYED_FIELD.getPreferredName(), this.keyed);
        builder.field(Histogram.MIN_DOC_COUNT_FIELD.getPreferredName(), this.minDocCount);
        if (this.extendedBounds != null) {
            builder.startObject(Histogram.EXTENDED_BOUNDS_FIELD.getPreferredName());
            this.extendedBounds.toXContent(builder, params);
            builder.endObject();
        }
        if (this.hardBounds != null) {
            builder.startObject(Histogram.HARD_BOUNDS_FIELD.getPreferredName());
            this.hardBounds.toXContent(builder, params);
            builder.endObject();
        }
        return builder;
    }

    public String getType() {
        return NAME;
    }

    @Override
    protected AggregationRegistry.RegistryKey<?> getRegistryKey() {
        return REGISTRY_KEY;
    }

    @Override
    protected ValuesSourceAggregatorFactory innerBuild(AggregationContext context, ValuesSourceConfig config, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder) throws IOException {
        if (this.hardBounds != null && this.extendedBounds != null) {
            if (this.hardBounds.getMax() != null && this.extendedBounds.getMax() != null && this.hardBounds.getMax() < this.extendedBounds.getMax()) {
                throw new IllegalArgumentException("Extended bounds have to be inside hard bounds, hard bounds: [" + String.valueOf(this.hardBounds) + "], extended bounds: [" + this.extendedBounds.getMin() + "--" + this.extendedBounds.getMax() + "]");
            }
            if (this.hardBounds.getMin() != null && this.extendedBounds.getMin() != null && this.hardBounds.getMin() > this.extendedBounds.getMin()) {
                throw new IllegalArgumentException("Extended bounds have to be inside hard bounds, hard bounds: [" + String.valueOf(this.hardBounds) + "], extended bounds: [" + this.extendedBounds.getMin() + "--" + this.extendedBounds.getMax() + "]");
            }
        }
        return new HistogramAggregatorFactory(this.name, config, this.interval, this.offset, this.order, this.keyed, this.minDocCount, this.extendedBounds, this.hardBounds, context, parent, subFactoriesBuilder, this.metadata);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.order, this.keyed, this.minDocCount, this.interval, this.offset, this.extendedBounds, this.hardBounds);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        HistogramAggregationBuilder other = (HistogramAggregationBuilder)((Object)obj);
        return Objects.equals(this.order, other.order) && Objects.equals(this.keyed, other.keyed) && Objects.equals(this.minDocCount, other.minDocCount) && Objects.equals(this.interval, other.interval) && Objects.equals(this.offset, other.offset) && Objects.equals(this.extendedBounds, other.extendedBounds) && Objects.equals(this.hardBounds, other.hardBounds);
    }

    public String validateParentAgg(String type, String name) {
        return this.minDocCount != 0L ? "parent histogram of " + type + " aggregation [" + name + "] must have min_doc_count of 0" : null;
    }

    static {
        EXTENDED_BOUNDS_PARSER.declareDouble((bounds, d) -> {
            bounds[0] = d;
        }, new ParseField("min", new String[0]));
        EXTENDED_BOUNDS_PARSER.declareDouble((bounds, d) -> {
            bounds[1] = d;
        }, new ParseField("max", new String[0]));
        PARSER = ObjectParser.fromBuilder((String)NAME, HistogramAggregationBuilder::new);
        ValuesSourceAggregationBuilder.declareFields(PARSER, true, true, false);
        PARSER.declareDouble(HistogramAggregationBuilder::interval, Histogram.INTERVAL_FIELD);
        PARSER.declareDouble(HistogramAggregationBuilder::offset, Histogram.OFFSET_FIELD);
        PARSER.declareBoolean(HistogramAggregationBuilder::keyed, Histogram.KEYED_FIELD);
        PARSER.declareLong(HistogramAggregationBuilder::minDocCount, Histogram.MIN_DOC_COUNT_FIELD);
        PARSER.declareField(HistogramAggregationBuilder::extendedBounds, parser -> (DoubleBounds)DoubleBounds.PARSER.apply(parser, null), Histogram.EXTENDED_BOUNDS_FIELD, ObjectParser.ValueType.OBJECT);
        PARSER.declareField(HistogramAggregationBuilder::hardBounds, parser -> (DoubleBounds)DoubleBounds.PARSER.apply(parser, null), Histogram.HARD_BOUNDS_FIELD, ObjectParser.ValueType.OBJECT);
        PARSER.declareObjectArray(HistogramAggregationBuilder::order, (p, c) -> InternalOrder.Parser.parseOrderParam((XContentParser)p), Histogram.ORDER_FIELD);
    }

    public static class AggregationProviderImpl
    implements AggregationProvider {
        public AggregationProvider.Type getType() {
            return AggregationProvider.Type.BUCKET;
        }

        public String getName() {
            return HistogramAggregationBuilder.NAME;
        }

        public Writeable.Reader getReader() {
            return HistogramAggregationBuilder::new;
        }

        public List<Tuple<Optional<String>, Writeable.Reader>> getResultReaders() {
            return Collections.singletonList(new Tuple(Optional.empty(), InternalHistogram::new));
        }

        public ObjectParser getParser() {
            return PARSER;
        }

        public Consumer<AggregationRegistry.Builder> getAggregatorRegistrar() {
            return HistogramAggregationBuilder::registerAggregators;
        }
    }
}

