/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.bucket.histogram;

import io.skylite.core.aggregations.AggregationContext;
import io.skylite.core.aggregations.AggregationRegistry;
import io.skylite.core.aggregations.Aggregator;
import io.skylite.core.aggregations.AggregatorFactories;
import io.skylite.core.aggregations.AggregatorFactory;
import io.skylite.core.aggregations.BucketOrder;
import io.skylite.core.aggregations.CardinalityUpperBound;
import io.skylite.core.aggregations.values.CoreValuesSourceType;
import io.skylite.core.aggregations.values.ValuesSourceConfig;
import io.skylite.core.aggregations.values.ValuesSourceType;
import io.skylite.core.search.internal.SearchExecutionContext;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.opensearch.search.aggregations.bucket.histogram.DoubleBounds;
import org.opensearch.search.aggregations.bucket.histogram.HistogramAggregationBuilder;
import org.opensearch.search.aggregations.bucket.histogram.HistogramAggregatorSupplier;
import org.opensearch.search.aggregations.bucket.histogram.NumericHistogramAggregator;
import org.opensearch.search.aggregations.bucket.histogram.RangeHistogramAggregator;
import org.opensearch.search.aggregations.support.ValuesSourceAggregatorFactory;

public final class HistogramAggregatorFactory
extends ValuesSourceAggregatorFactory {
    private final double interval;
    private final double offset;
    private final BucketOrder order;
    private final boolean keyed;
    private final long minDocCount;
    private final DoubleBounds extendedBounds;
    private final DoubleBounds hardBounds;

    static void registerAggregators(AggregationRegistry.Builder builder) {
        builder.register(HistogramAggregationBuilder.REGISTRY_KEY, (ValuesSourceType)CoreValuesSourceType.RANGE, RangeHistogramAggregator::new, true);
        builder.register(HistogramAggregationBuilder.REGISTRY_KEY, List.of(CoreValuesSourceType.NUMERIC, CoreValuesSourceType.DATE, CoreValuesSourceType.BOOLEAN), NumericHistogramAggregator::new, true);
    }

    public HistogramAggregatorFactory(String name, ValuesSourceConfig config, double interval, double offset, BucketOrder order, boolean keyed, long minDocCount, DoubleBounds extendedBounds, DoubleBounds hardBounds, AggregationContext context, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder, Map<String, Object> metadata) throws IOException {
        super(name, config, context, parent, subFactoriesBuilder, metadata);
        this.interval = interval;
        this.offset = offset;
        this.order = order;
        this.keyed = keyed;
        this.minDocCount = minDocCount;
        this.extendedBounds = extendedBounds;
        this.hardBounds = hardBounds;
    }

    public long minDocCount() {
        return this.minDocCount;
    }

    @Override
    protected Aggregator doCreateInternal(SearchExecutionContext searchContext, Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        return ((HistogramAggregatorSupplier)this.context.getAggregationRegistry().getAggregator(HistogramAggregationBuilder.REGISTRY_KEY, this.config)).build(this.name, this.factories, this.interval, this.offset, this.order, this.keyed, this.minDocCount, this.extendedBounds, this.hardBounds, this.config, searchContext, parent, cardinality, metadata);
    }

    @Override
    protected Aggregator createUnmapped(SearchExecutionContext searchContext, Aggregator parent, Map<String, Object> metadata) throws IOException {
        return new NumericHistogramAggregator(this.name, this.factories, this.interval, this.offset, this.order, this.keyed, this.minDocCount, this.extendedBounds, this.hardBounds, this.config, searchContext, parent, CardinalityUpperBound.NONE, metadata);
    }

    protected boolean supportsConcurrentSegmentSearch() {
        return true;
    }
}

