/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.bucket.histogram;

import io.skylite.core.aggregations.Aggregator;
import io.skylite.core.aggregations.AggregatorFactories;
import io.skylite.core.aggregations.BucketOrder;
import io.skylite.core.aggregations.CardinalityUpperBound;
import io.skylite.core.aggregations.LeafBucketCollector;
import io.skylite.core.aggregations.values.NumericValuesSource;
import io.skylite.core.aggregations.values.ValuesSourceConfig;
import io.skylite.core.index.fielddata.SortedNumericDoubleValues;
import io.skylite.core.search.internal.SearchExecutionContext;
import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.ScoreMode;
import org.opensearch.search.aggregations.LeafBucketCollectorBase;
import org.opensearch.search.aggregations.bucket.histogram.AbstractHistogramAggregator;
import org.opensearch.search.aggregations.bucket.histogram.DoubleBounds;

public class NumericHistogramAggregator
extends AbstractHistogramAggregator {
    private final NumericValuesSource valuesSource;

    public NumericHistogramAggregator(String name, AggregatorFactories factories, double interval, double offset, BucketOrder order, boolean keyed, long minDocCount, DoubleBounds extendedBounds, DoubleBounds hardBounds, ValuesSourceConfig valuesSourceConfig, SearchExecutionContext context, Aggregator parent, CardinalityUpperBound cardinalityUpperBound, Map<String, Object> metadata) throws IOException {
        super(name, factories, interval, offset, order, keyed, minDocCount, extendedBounds, hardBounds, valuesSourceConfig.format(), context, parent, cardinalityUpperBound, metadata);
        this.valuesSource = valuesSourceConfig.hasValues() ? (NumericValuesSource)valuesSourceConfig.getValuesSource() : null;
    }

    @Override
    public ScoreMode scoreMode() {
        if (this.valuesSource != null && this.valuesSource.needsScores()) {
            return ScoreMode.COMPLETE;
        }
        return super.scoreMode();
    }

    @Override
    public LeafBucketCollector getLeafCollector(LeafReaderContext ctx, final LeafBucketCollector sub) throws IOException {
        if (this.valuesSource == null) {
            return LeafBucketCollector.NO_OP_COLLECTOR;
        }
        final SortedNumericDoubleValues values = this.valuesSource.doubleValues(ctx);
        return new LeafBucketCollectorBase(sub, values){

            @Override
            public void collect(int doc, long owningBucketOrd) throws IOException {
                if (values.advanceExact(doc)) {
                    int valuesCount = values.docValueCount();
                    double previousKey = Double.NEGATIVE_INFINITY;
                    for (int i = 0; i < valuesCount; ++i) {
                        double value = values.nextValue();
                        double key = Math.floor((value - NumericHistogramAggregator.this.offset) / NumericHistogramAggregator.this.interval);
                        assert (key >= previousKey);
                        if (key == previousKey) continue;
                        if (NumericHistogramAggregator.this.hardBounds == null || NumericHistogramAggregator.this.hardBounds.contain(key * NumericHistogramAggregator.this.interval)) {
                            long bucketOrd = NumericHistogramAggregator.this.bucketOrds.add(owningBucketOrd, Double.doubleToLongBits(key));
                            if (bucketOrd < 0L) {
                                bucketOrd = -1L - bucketOrd;
                                NumericHistogramAggregator.this.collectExistingBucket(sub, doc, bucketOrd);
                            } else {
                                NumericHistogramAggregator.this.collectBucket(sub, doc, bucketOrd);
                            }
                        }
                        previousKey = key;
                    }
                }
            }
        };
    }
}

