/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.bucket.histogram;

import io.skylite.common.CheckedFunction;
import io.skylite.core.aggregations.Aggregation;
import io.skylite.core.xcontent.ObjectParser;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import java.io.IOException;
import java.time.Instant;
import java.time.ZoneOffset;
import java.util.List;
import org.opensearch.search.aggregations.ParsedMultiBucketAggregation;
import org.opensearch.search.aggregations.bucket.histogram.Histogram;

public class ParsedDateHistogram
extends ParsedMultiBucketAggregation<ParsedBucket>
implements Histogram {
    private static final ObjectParser<ParsedDateHistogram, Void> PARSER = new ObjectParser(ParsedDateHistogram.class.getSimpleName(), true, ParsedDateHistogram::new);

    public String getType() {
        return "date_histogram";
    }

    @Override
    public List<? extends Histogram.Bucket> getBuckets() {
        return this.buckets;
    }

    public static ParsedDateHistogram fromXContent(XContentParser parser, String name) throws IOException {
        ParsedDateHistogram aggregation = (ParsedDateHistogram)PARSER.parse(parser, null);
        aggregation.setName(name);
        return aggregation;
    }

    static {
        ParsedDateHistogram.declareMultiBucketAggregationFields(PARSER, (CheckedFunction<XContentParser, ParsedMultiBucketAggregation.ParsedBucket, IOException>)((CheckedFunction)parser -> ParsedBucket.fromXContent(parser, false)), (CheckedFunction<XContentParser, ParsedMultiBucketAggregation.ParsedBucket, IOException>)((CheckedFunction)parser -> ParsedBucket.fromXContent(parser, true)));
    }

    public static class ParsedBucket
    extends ParsedMultiBucketAggregation.ParsedBucket
    implements Histogram.Bucket {
        private Long key;

        public Object getKey() {
            if (this.key != null) {
                return Instant.ofEpochMilli(this.key).atZone(ZoneOffset.UTC);
            }
            return null;
        }

        @Override
        public String getKeyAsString() {
            String keyAsString = super.getKeyAsString();
            if (keyAsString != null) {
                return keyAsString;
            }
            if (this.key != null) {
                return Long.toString(this.key);
            }
            return null;
        }

        @Override
        protected XContentBuilder keyToXContent(XContentBuilder builder) throws IOException {
            return builder.field(Aggregation.CommonFields.KEY.getPreferredName(), this.key);
        }

        static ParsedBucket fromXContent(XContentParser parser, boolean keyed) throws IOException {
            return ParsedBucket.parseXContent(parser, keyed, ParsedBucket::new, (p, bucket) -> {
                bucket.key = p.longValue();
            });
        }
    }
}

