/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.bucket.histogram;

import io.skylite.core.aggregations.Aggregator;
import io.skylite.core.aggregations.AggregatorFactories;
import io.skylite.core.aggregations.BucketOrder;
import io.skylite.core.aggregations.CardinalityUpperBound;
import io.skylite.core.aggregations.LeafBucketCollector;
import io.skylite.core.aggregations.values.RangeValuesSource;
import io.skylite.core.aggregations.values.ValuesSourceConfig;
import io.skylite.core.index.fielddata.SortedBinaryDocValues;
import io.skylite.core.mapper.RangeFieldMapper;
import io.skylite.core.mapper.RangeType;
import io.skylite.core.search.internal.SearchExecutionContext;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.util.BytesRef;
import org.opensearch.search.aggregations.LeafBucketCollectorBase;
import org.opensearch.search.aggregations.bucket.histogram.AbstractHistogramAggregator;
import org.opensearch.search.aggregations.bucket.histogram.DoubleBounds;

public class RangeHistogramAggregator
extends AbstractHistogramAggregator {
    private final RangeValuesSource valuesSource;

    public RangeHistogramAggregator(String name, AggregatorFactories factories, double interval, double offset, BucketOrder order, boolean keyed, long minDocCount, DoubleBounds extendedBounds, DoubleBounds hardBounds, ValuesSourceConfig valuesSourceConfig, SearchExecutionContext context, Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        super(name, factories, interval, offset, order, keyed, minDocCount, extendedBounds, hardBounds, valuesSourceConfig.format(), context, parent, cardinality, metadata);
        RangeValuesSource rangeValuesSource = this.valuesSource = valuesSourceConfig.hasValues() ? (RangeValuesSource)valuesSourceConfig.getValuesSource() : null;
        if (!this.valuesSource.rangeType().isNumeric()) {
            throw new IllegalArgumentException("Expected numeric range type but found non-numeric range [" + this.valuesSource.rangeType().name + "]");
        }
    }

    @Override
    protected LeafBucketCollector getLeafCollector(LeafReaderContext ctx, final LeafBucketCollector sub) throws IOException {
        if (this.valuesSource == null) {
            return LeafBucketCollector.NO_OP_COLLECTOR;
        }
        final SortedBinaryDocValues values = this.valuesSource.bytesValues(ctx);
        final RangeType rangeType = this.valuesSource.rangeType();
        return new LeafBucketCollectorBase(sub, values){

            @Override
            public void collect(int doc, long owningBucketOrd) throws IOException {
                if (values.advanceExact(doc)) {
                    int valuesCount = values.docValueCount();
                    assert (valuesCount == 1) : "Value count for ranges should always be 1";
                    double previousKey = Double.NEGATIVE_INFINITY;
                    for (int i = 0; i < valuesCount; ++i) {
                        BytesRef encodedRanges = values.nextValue();
                        List ranges = rangeType.decodeRanges(encodedRanges);
                        double previousFrom = Double.NEGATIVE_INFINITY;
                        for (RangeFieldMapper.Range range : ranges) {
                            Double from = rangeType.doubleValue(range.getFrom());
                            assert (from >= previousFrom) : "Start of range not >= previous start";
                            Double to = rangeType.doubleValue(range.getTo());
                            double effectiveFrom = RangeHistogramAggregator.this.hardBounds != null && RangeHistogramAggregator.this.hardBounds.getMin() != null ? Double.max(from, RangeHistogramAggregator.this.hardBounds.getMin()) : from;
                            double effectiveTo = RangeHistogramAggregator.this.hardBounds != null && RangeHistogramAggregator.this.hardBounds.getMax() != null ? Double.min(to, RangeHistogramAggregator.this.hardBounds.getMax()) : to;
                            double startKey = Math.floor((effectiveFrom - RangeHistogramAggregator.this.offset) / RangeHistogramAggregator.this.interval);
                            double endKey = Math.floor((effectiveTo - RangeHistogramAggregator.this.offset) / RangeHistogramAggregator.this.interval);
                            for (double key = Math.max(startKey, previousKey); key <= endKey; key += 1.0) {
                                if (key == previousKey) continue;
                                long bucketOrd = RangeHistogramAggregator.this.bucketOrds.add(owningBucketOrd, Double.doubleToLongBits(key));
                                if (bucketOrd < 0L) {
                                    bucketOrd = -1L - bucketOrd;
                                    RangeHistogramAggregator.this.collectExistingBucket(sub, doc, bucketOrd);
                                    continue;
                                }
                                RangeHistogramAggregator.this.collectBucket(sub, doc, bucketOrd);
                            }
                            if (!(endKey > previousKey)) continue;
                            previousKey = endKey;
                        }
                    }
                }
            }
        };
    }
}

