/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.bucket.histogram;

import io.skylite.common.collect.Tuple;
import io.skylite.core.ParseField;
import io.skylite.core.aggregations.AggregationBuilder;
import io.skylite.core.aggregations.AggregationContext;
import io.skylite.core.aggregations.AggregationProvider;
import io.skylite.core.aggregations.AggregationRegistry;
import io.skylite.core.aggregations.AggregatorFactories;
import io.skylite.core.aggregations.AggregatorFactory;
import io.skylite.core.aggregations.MultiBucketConsumerService;
import io.skylite.core.aggregations.values.CoreValuesSourceType;
import io.skylite.core.aggregations.values.ValuesSourceConfig;
import io.skylite.core.aggregations.values.ValuesSourceType;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.settings.Settings;
import io.skylite.core.xcontent.ObjectParser;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import org.opensearch.search.aggregations.bucket.histogram.InternalVariableWidthHistogram;
import org.opensearch.search.aggregations.bucket.histogram.VariableWidthHistogramAggregator;
import org.opensearch.search.aggregations.bucket.histogram.VariableWidthHistogramAggregatorFactory;
import org.opensearch.search.aggregations.bucket.histogram.VariableWidthHistogramAggregatorSupplier;
import org.opensearch.search.aggregations.support.ValuesSourceAggregationBuilder;
import org.opensearch.search.aggregations.support.ValuesSourceAggregatorFactory;

public class VariableWidthHistogramAggregationBuilder
extends ValuesSourceAggregationBuilder<VariableWidthHistogramAggregationBuilder> {
    public static final String NAME = "variable_width_histogram";
    public static final AggregationRegistry.RegistryKey<VariableWidthHistogramAggregatorSupplier> REGISTRY_KEY = new AggregationRegistry.RegistryKey("variable_width_histogram", VariableWidthHistogramAggregatorSupplier.class);
    private static final ParseField NUM_BUCKETS_FIELD = new ParseField("buckets", new String[0]);
    private static final ParseField INITIAL_BUFFER_FIELD = new ParseField("initial_buffer", new String[0]);
    private static final ParseField SHARD_SIZE_FIELD = new ParseField("shard_size", new String[0]);
    public static final ObjectParser<VariableWidthHistogramAggregationBuilder, String> PARSER = ObjectParser.fromBuilder((String)"variable_width_histogram", VariableWidthHistogramAggregationBuilder::new);
    private int numBuckets = 10;
    private int shardSize = -1;
    private int initialBuffer = -1;

    public static void registerAggregators(AggregationRegistry.Builder builder) {
        VariableWidthHistogramAggregatorFactory.registerAggregators(builder);
    }

    public VariableWidthHistogramAggregationBuilder(String name) {
        super(name);
    }

    public VariableWidthHistogramAggregationBuilder(StreamInput in) throws IOException {
        super(in);
        this.numBuckets = in.readVInt();
    }

    protected VariableWidthHistogramAggregationBuilder(VariableWidthHistogramAggregationBuilder clone, AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metaData) {
        super(clone, factoriesBuilder, metaData);
        this.numBuckets = clone.numBuckets;
    }

    @Override
    protected ValuesSourceType defaultValueSourceType() {
        return CoreValuesSourceType.NUMERIC;
    }

    public VariableWidthHistogramAggregationBuilder setNumBuckets(int numBuckets) {
        if (numBuckets <= 0) {
            throw new IllegalArgumentException(NUM_BUCKETS_FIELD.getPreferredName() + " must be greater than [0] for [" + this.name + "]");
        }
        this.numBuckets = numBuckets;
        return this;
    }

    public VariableWidthHistogramAggregationBuilder setShardSize(int shardSize) {
        if (shardSize <= 1) {
            throw new IllegalArgumentException(SHARD_SIZE_FIELD.getPreferredName() + " must be greater than [1] for [" + this.name + "]");
        }
        this.shardSize = shardSize;
        return this;
    }

    public VariableWidthHistogramAggregationBuilder setInitialBuffer(int initialBuffer) {
        if (initialBuffer <= 0) {
            throw new IllegalArgumentException(INITIAL_BUFFER_FIELD.getPreferredName() + " must be greater than [0] for [" + this.name + "]");
        }
        this.initialBuffer = initialBuffer;
        return this;
    }

    public int getNumBuckets() {
        return this.numBuckets;
    }

    public int getShardSize() {
        if (this.shardSize == -1) {
            return this.numBuckets * 50;
        }
        return this.shardSize;
    }

    public int getInitialBuffer() {
        if (this.initialBuffer == -1) {
            return Math.min(10 * this.getShardSize(), 50000);
        }
        return this.initialBuffer;
    }

    public AggregationBuilder.BucketCardinality bucketCardinality() {
        return AggregationBuilder.BucketCardinality.MANY;
    }

    protected AggregationBuilder shallowCopy(AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metaData) {
        return new VariableWidthHistogramAggregationBuilder(this, factoriesBuilder, metaData);
    }

    @Override
    protected void innerWriteTo(StreamOutput out) throws IOException {
        out.writeVInt(this.numBuckets);
    }

    @Override
    protected ValuesSourceAggregatorFactory innerBuild(AggregationContext context, ValuesSourceConfig config, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder) throws IOException {
        Settings settings = context.getIndexSettings().getNodeSettings();
        int maxBuckets = (Integer)MultiBucketConsumerService.MAX_BUCKET_SETTING.get(settings);
        if (this.numBuckets > maxBuckets) {
            throw new IllegalArgumentException(NUM_BUCKETS_FIELD.getPreferredName() + " must be less than " + maxBuckets);
        }
        int initialBuffer = this.getInitialBuffer();
        int shardSize = this.getShardSize();
        if (initialBuffer < this.numBuckets) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "%s must be at least %s but was [%s<%s] for [%s]", INITIAL_BUFFER_FIELD.getPreferredName(), NUM_BUCKETS_FIELD.getPreferredName(), initialBuffer, this.numBuckets, this.name));
        }
        int mergePhaseInit = VariableWidthHistogramAggregator.mergePhaseInitialBucketCount(shardSize);
        if (mergePhaseInit < this.numBuckets) {
            throw new IllegalArgumentException("3/4 of " + SHARD_SIZE_FIELD.getPreferredName() + " must be at least " + NUM_BUCKETS_FIELD.getPreferredName() + " but was [" + mergePhaseInit + "<" + this.numBuckets + "] for [" + this.name + "]");
        }
        return new VariableWidthHistogramAggregatorFactory(this.name, config, this.numBuckets, shardSize, initialBuffer, context, parent, subFactoriesBuilder, this.metadata);
    }

    @Override
    protected XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(NUM_BUCKETS_FIELD.getPreferredName(), this.numBuckets);
        return builder;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.numBuckets, this.shardSize, this.initialBuffer);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        VariableWidthHistogramAggregationBuilder other = (VariableWidthHistogramAggregationBuilder)((Object)obj);
        return Objects.equals(this.numBuckets, other.numBuckets) && Objects.equals(this.shardSize, other.shardSize) && Objects.equals(this.initialBuffer, other.initialBuffer);
    }

    public String getType() {
        return NAME;
    }

    @Override
    protected AggregationRegistry.RegistryKey<?> getRegistryKey() {
        return REGISTRY_KEY;
    }

    static {
        ValuesSourceAggregationBuilder.declareFields(PARSER, true, true, true);
        PARSER.declareInt(VariableWidthHistogramAggregationBuilder::setNumBuckets, NUM_BUCKETS_FIELD);
        PARSER.declareInt(VariableWidthHistogramAggregationBuilder::setShardSize, SHARD_SIZE_FIELD);
        PARSER.declareInt(VariableWidthHistogramAggregationBuilder::setInitialBuffer, INITIAL_BUFFER_FIELD);
    }

    public static class AggregationProviderImpl
    implements AggregationProvider {
        public AggregationProvider.Type getType() {
            return AggregationProvider.Type.BUCKET;
        }

        public String getName() {
            return VariableWidthHistogramAggregationBuilder.NAME;
        }

        public Writeable.Reader getReader() {
            return VariableWidthHistogramAggregationBuilder::new;
        }

        public List<Tuple<Optional<String>, Writeable.Reader>> getResultReaders() {
            return Collections.singletonList(new Tuple(Optional.empty(), InternalVariableWidthHistogram::new));
        }

        public ObjectParser getParser() {
            return PARSER;
        }

        public Consumer<AggregationRegistry.Builder> getAggregatorRegistrar() {
            return VariableWidthHistogramAggregationBuilder::registerAggregators;
        }
    }
}

