/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.bucket.missing;

import io.skylite.common.index.fielddata.DocValueBits;
import io.skylite.core.aggregations.Aggregator;
import io.skylite.core.aggregations.AggregatorFactories;
import io.skylite.core.aggregations.CardinalityUpperBound;
import io.skylite.core.aggregations.InternalAggregation;
import io.skylite.core.aggregations.LeafBucketCollector;
import io.skylite.core.aggregations.bucket.SingleBucketAggregator;
import io.skylite.core.aggregations.values.ValuesSource;
import io.skylite.core.aggregations.values.ValuesSourceConfig;
import io.skylite.core.search.internal.SearchExecutionContext;
import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.opensearch.search.aggregations.LeafBucketCollectorBase;
import org.opensearch.search.aggregations.bucket.BucketsAggregator;
import org.opensearch.search.aggregations.bucket.missing.InternalMissing;

public class MissingAggregator
extends BucketsAggregator
implements SingleBucketAggregator {
    private final ValuesSource valuesSource;

    public MissingAggregator(String name, AggregatorFactories factories, ValuesSourceConfig valuesSourceConfig, SearchExecutionContext aggregationContext, Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        super(name, factories, aggregationContext, parent, cardinality, metadata);
        this.valuesSource = valuesSourceConfig.hasValues() ? valuesSourceConfig.getValuesSource() : null;
    }

    @Override
    public LeafBucketCollector getLeafCollector(LeafReaderContext ctx, final LeafBucketCollector sub) throws IOException {
        final DocValueBits docsWithValue = this.valuesSource != null ? this.valuesSource.docsWithValue(ctx) : new DocValueBits(this){

            public boolean advanceExact(int doc) throws IOException {
                return false;
            }
        };
        return new LeafBucketCollectorBase(sub, docsWithValue){

            @Override
            public void collect(int doc, long bucket) throws IOException {
                if (!docsWithValue.advanceExact(doc)) {
                    MissingAggregator.this.collectBucket(sub, doc, bucket);
                }
            }
        };
    }

    public InternalAggregation[] buildAggregations(long[] owningBucketOrds) throws IOException {
        return this.buildAggregationsForSingleBucket(owningBucketOrds, (owningBucketOrd, subAggregationResults) -> new InternalMissing(this.name, this.bucketDocCount(owningBucketOrd), subAggregationResults, this.metadata()));
    }

    public InternalAggregation buildEmptyAggregation() {
        return new InternalMissing(this.name, 0L, this.buildEmptySubAggregations(), this.metadata());
    }
}

