/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.bucket.missing;

import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import java.io.IOException;
import java.util.Locale;
import java.util.function.Supplier;

public enum MissingOrder implements Writeable
{
    FIRST{

        @Override
        public int compare(Supplier<Boolean> leftIsMissing, Supplier<Boolean> rightIsMissing, int reverseMul) {
            if (leftIsMissing.get().booleanValue()) {
                return rightIsMissing.get() != false ? 0 : -1;
            }
            if (rightIsMissing.get().booleanValue()) {
                return 1;
            }
            return MISSING_ORDER_UNKNOWN;
        }

        public String toString() {
            return "first";
        }
    }
    ,
    LAST{

        @Override
        public int compare(Supplier<Boolean> leftIsMissing, Supplier<Boolean> rightIsMissing, int reverseMul) {
            if (leftIsMissing.get().booleanValue()) {
                return rightIsMissing.get() != false ? 0 : 1;
            }
            if (rightIsMissing.get().booleanValue()) {
                return -1;
            }
            return MISSING_ORDER_UNKNOWN;
        }

        public String toString() {
            return "last";
        }
    }
    ,
    DEFAULT{

        @Override
        public int compare(Supplier<Boolean> leftIsMissing, Supplier<Boolean> rightIsMissing, int reverseMul) {
            if (leftIsMissing.get().booleanValue()) {
                return rightIsMissing.get() != false ? 0 : -1 * reverseMul;
            }
            if (rightIsMissing.get().booleanValue()) {
                return reverseMul;
            }
            return MISSING_ORDER_UNKNOWN;
        }

        public String toString() {
            return "default";
        }
    };

    public static final String NAME = "missing_order";
    private static int MISSING_ORDER_UNKNOWN;

    public static MissingOrder readFromStream(StreamInput in) throws IOException {
        return (MissingOrder)in.readEnum(MissingOrder.class);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeEnum((Enum)this);
    }

    public static boolean isDefault(MissingOrder order) {
        return order == DEFAULT;
    }

    public static MissingOrder fromString(String order) {
        return MissingOrder.valueOf(order.toUpperCase(Locale.ROOT));
    }

    public static boolean unknownOrder(int v) {
        return v == MISSING_ORDER_UNKNOWN;
    }

    public abstract int compare(Supplier<Boolean> var1, Supplier<Boolean> var2, int var3);

    static {
        MISSING_ORDER_UNKNOWN = Integer.MIN_VALUE;
    }
}

